/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFeaturedResultsSetRequest extends KendraRequest implements
        ToCopyableBuilder<DescribeFeaturedResultsSetRequest.Builder, DescribeFeaturedResultsSetRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DescribeFeaturedResultsSetRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> FEATURED_RESULTS_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeaturedResultsSetId").getter(getter(DescribeFeaturedResultsSetRequest::featuredResultsSetId))
            .setter(setter(Builder::featuredResultsSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            FEATURED_RESULTS_SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexId;

    private final String featuredResultsSetId;

    private DescribeFeaturedResultsSetRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.featuredResultsSetId = builder.featuredResultsSetId;
    }

    /**
     * <p>
     * The identifier of the index used for featuring results.
     * </p>
     * 
     * @return The identifier of the index used for featuring results.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the set of featured results that you want to get information on.
     * </p>
     * 
     * @return The identifier of the set of featured results that you want to get information on.
     */
    public final String featuredResultsSetId() {
        return featuredResultsSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(featuredResultsSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeaturedResultsSetRequest)) {
            return false;
        }
        DescribeFeaturedResultsSetRequest other = (DescribeFeaturedResultsSetRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(featuredResultsSetId(), other.featuredResultsSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFeaturedResultsSetRequest").add("IndexId", indexId())
                .add("FeaturedResultsSetId", featuredResultsSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "FeaturedResultsSetId":
            return Optional.ofNullable(clazz.cast(featuredResultsSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("FeaturedResultsSetId", FEATURED_RESULTS_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeaturedResultsSetRequest, T> g) {
        return obj -> g.apply((DescribeFeaturedResultsSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFeaturedResultsSetRequest> {
        /**
         * <p>
         * The identifier of the index used for featuring results.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index used for featuring results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the set of featured results that you want to get information on.
         * </p>
         * 
         * @param featuredResultsSetId
         *        The identifier of the set of featured results that you want to get information on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetId(String featuredResultsSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String featuredResultsSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeaturedResultsSetRequest model) {
            super(model);
            indexId(model.indexId);
            featuredResultsSetId(model.featuredResultsSetId);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getFeaturedResultsSetId() {
            return featuredResultsSetId;
        }

        public final void setFeaturedResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
        }

        @Override
        public final Builder featuredResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFeaturedResultsSetRequest build() {
            return new DescribeFeaturedResultsSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
