/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFeaturedResultsSetResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeFeaturedResultsSetResponse.Builder, DescribeFeaturedResultsSetResponse> {
    private static final SdkField<String> FEATURED_RESULTS_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeaturedResultsSetId").getter(getter(DescribeFeaturedResultsSetResponse::featuredResultsSetId))
            .setter(setter(Builder::featuredResultsSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetId").build())
            .build();

    private static final SdkField<String> FEATURED_RESULTS_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeaturedResultsSetName").getter(getter(DescribeFeaturedResultsSetResponse::featuredResultsSetName))
            .setter(setter(Builder::featuredResultsSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeFeaturedResultsSetResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeFeaturedResultsSetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> QUERY_TEXTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QueryTexts")
            .getter(getter(DescribeFeaturedResultsSetResponse::queryTexts))
            .setter(setter(Builder::queryTexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryTexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FeaturedDocumentWithMetadata>> FEATURED_DOCUMENTS_WITH_METADATA_FIELD = SdkField
            .<List<FeaturedDocumentWithMetadata>> builder(MarshallingType.LIST)
            .memberName("FeaturedDocumentsWithMetadata")
            .getter(getter(DescribeFeaturedResultsSetResponse::featuredDocumentsWithMetadata))
            .setter(setter(Builder::featuredDocumentsWithMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedDocumentsWithMetadata")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeaturedDocumentWithMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeaturedDocumentWithMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FeaturedDocumentMissing>> FEATURED_DOCUMENTS_MISSING_FIELD = SdkField
            .<List<FeaturedDocumentMissing>> builder(MarshallingType.LIST)
            .memberName("FeaturedDocumentsMissing")
            .getter(getter(DescribeFeaturedResultsSetResponse::featuredDocumentsMissing))
            .setter(setter(Builder::featuredDocumentsMissing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedDocumentsMissing").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeaturedDocumentMissing> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeaturedDocumentMissing::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastUpdatedTimestamp").getter(getter(DescribeFeaturedResultsSetResponse::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<Long> CREATION_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreationTimestamp").getter(getter(DescribeFeaturedResultsSetResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURED_RESULTS_SET_ID_FIELD,
            FEATURED_RESULTS_SET_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, QUERY_TEXTS_FIELD,
            FEATURED_DOCUMENTS_WITH_METADATA_FIELD, FEATURED_DOCUMENTS_MISSING_FIELD, LAST_UPDATED_TIMESTAMP_FIELD,
            CREATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String featuredResultsSetId;

    private final String featuredResultsSetName;

    private final String description;

    private final String status;

    private final List<String> queryTexts;

    private final List<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata;

    private final List<FeaturedDocumentMissing> featuredDocumentsMissing;

    private final Long lastUpdatedTimestamp;

    private final Long creationTimestamp;

    private DescribeFeaturedResultsSetResponse(BuilderImpl builder) {
        super(builder);
        this.featuredResultsSetId = builder.featuredResultsSetId;
        this.featuredResultsSetName = builder.featuredResultsSetName;
        this.description = builder.description;
        this.status = builder.status;
        this.queryTexts = builder.queryTexts;
        this.featuredDocumentsWithMetadata = builder.featuredDocumentsWithMetadata;
        this.featuredDocumentsMissing = builder.featuredDocumentsMissing;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.creationTimestamp = builder.creationTimestamp;
    }

    /**
     * <p>
     * The identifier of the set of featured results.
     * </p>
     * 
     * @return The identifier of the set of featured results.
     */
    public final String featuredResultsSetId() {
        return featuredResultsSetId;
    }

    /**
     * <p>
     * The name for the set of featured results.
     * </p>
     * 
     * @return The name for the set of featured results.
     */
    public final String featuredResultsSetName() {
        return featuredResultsSetName;
    }

    /**
     * <p>
     * The description for the set of featured results.
     * </p>
     * 
     * @return The description for the set of featured results.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are
     * ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can
     * set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
     * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
     * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeaturedResultsSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
     *         results are ready for use. You can still configure your settings before setting the status to
     *         <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
     *         UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
     *         featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * @see FeaturedResultsSetStatus
     */
    public final FeaturedResultsSetStatus status() {
        return FeaturedResultsSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are
     * ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can
     * set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
     * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
     * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeaturedResultsSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
     *         results are ready for use. You can still configure your settings before setting the status to
     *         <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
     *         UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
     *         featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * @see FeaturedResultsSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryTexts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueryTexts() {
        return queryTexts != null && !(queryTexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of queries for featuring results. For more information on the list of queries, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryTexts} method.
     * </p>
     * 
     * @return The list of queries for featuring results. For more information on the list of queries, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
     */
    public final List<String> queryTexts() {
        return queryTexts;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeaturedDocumentsWithMetadata property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFeaturedDocumentsWithMetadata() {
        return featuredDocumentsWithMetadata != null && !(featuredDocumentsWithMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of document IDs for the documents you want to feature with their metadata information. For more
     * information on the list of featured documents, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeaturedDocumentsWithMetadata} method.
     * </p>
     * 
     * @return The list of document IDs for the documents you want to feature with their metadata information. For more
     *         information on the list of featured documents, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
     */
    public final List<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata() {
        return featuredDocumentsWithMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeaturedDocumentsMissing property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFeaturedDocumentsMissing() {
        return featuredDocumentsMissing != null && !(featuredDocumentsMissing instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of document IDs that don't exist but you have specified as featured documents. Amazon Kendra cannot
     * feature these documents if they don't exist in the index. You can check the status of a document and its ID or
     * check for documents with status errors using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html">BatchGetDocumentStatus</a>
     * API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeaturedDocumentsMissing} method.
     * </p>
     * 
     * @return The list of document IDs that don't exist but you have specified as featured documents. Amazon Kendra
     *         cannot feature these documents if they don't exist in the index. You can check the status of a document
     *         and its ID or check for documents with status errors using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html"
     *         >BatchGetDocumentStatus</a> API.
     */
    public final List<FeaturedDocumentMissing> featuredDocumentsMissing() {
        return featuredDocumentsMissing;
    }

    /**
     * <p>
     * The timestamp when the set of featured results was last updated.
     * </p>
     * 
     * @return The timestamp when the set of featured results was last updated.
     */
    public final Long lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The Unix timestamp when the set of the featured results was created.
     * </p>
     * 
     * @return The Unix timestamp when the set of the featured results was created.
     */
    public final Long creationTimestamp() {
        return creationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featuredResultsSetId());
        hashCode = 31 * hashCode + Objects.hashCode(featuredResultsSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryTexts() ? queryTexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFeaturedDocumentsWithMetadata() ? featuredDocumentsWithMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFeaturedDocumentsMissing() ? featuredDocumentsMissing() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeaturedResultsSetResponse)) {
            return false;
        }
        DescribeFeaturedResultsSetResponse other = (DescribeFeaturedResultsSetResponse) obj;
        return Objects.equals(featuredResultsSetId(), other.featuredResultsSetId())
                && Objects.equals(featuredResultsSetName(), other.featuredResultsSetName())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasQueryTexts() == other.hasQueryTexts() && Objects.equals(queryTexts(), other.queryTexts())
                && hasFeaturedDocumentsWithMetadata() == other.hasFeaturedDocumentsWithMetadata()
                && Objects.equals(featuredDocumentsWithMetadata(), other.featuredDocumentsWithMetadata())
                && hasFeaturedDocumentsMissing() == other.hasFeaturedDocumentsMissing()
                && Objects.equals(featuredDocumentsMissing(), other.featuredDocumentsMissing())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(creationTimestamp(), other.creationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeFeaturedResultsSetResponse")
                .add("FeaturedResultsSetId", featuredResultsSetId())
                .add("FeaturedResultsSetName", featuredResultsSetName())
                .add("Description", description())
                .add("Status", statusAsString())
                .add("QueryTexts", hasQueryTexts() ? queryTexts() : null)
                .add("FeaturedDocumentsWithMetadata", hasFeaturedDocumentsWithMetadata() ? featuredDocumentsWithMetadata() : null)
                .add("FeaturedDocumentsMissing", hasFeaturedDocumentsMissing() ? featuredDocumentsMissing() : null)
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("CreationTimestamp", creationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeaturedResultsSetId":
            return Optional.ofNullable(clazz.cast(featuredResultsSetId()));
        case "FeaturedResultsSetName":
            return Optional.ofNullable(clazz.cast(featuredResultsSetName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "QueryTexts":
            return Optional.ofNullable(clazz.cast(queryTexts()));
        case "FeaturedDocumentsWithMetadata":
            return Optional.ofNullable(clazz.cast(featuredDocumentsWithMetadata()));
        case "FeaturedDocumentsMissing":
            return Optional.ofNullable(clazz.cast(featuredDocumentsMissing()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeaturedResultsSetId", FEATURED_RESULTS_SET_ID_FIELD);
        map.put("FeaturedResultsSetName", FEATURED_RESULTS_SET_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("QueryTexts", QUERY_TEXTS_FIELD);
        map.put("FeaturedDocumentsWithMetadata", FEATURED_DOCUMENTS_WITH_METADATA_FIELD);
        map.put("FeaturedDocumentsMissing", FEATURED_DOCUMENTS_MISSING_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeaturedResultsSetResponse, T> g) {
        return obj -> g.apply((DescribeFeaturedResultsSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFeaturedResultsSetResponse> {
        /**
         * <p>
         * The identifier of the set of featured results.
         * </p>
         * 
         * @param featuredResultsSetId
         *        The identifier of the set of featured results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetId(String featuredResultsSetId);

        /**
         * <p>
         * The name for the set of featured results.
         * </p>
         * 
         * @param featuredResultsSetName
         *        The name for the set of featured results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetName(String featuredResultsSetName);

        /**
         * <p>
         * The description for the set of featured results.
         * </p>
         * 
         * @param description
         *        The description for the set of featured results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results
         * are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>.
         * You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
         * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
         * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
         *        results are ready for use. You can still configure your settings before setting the status to
         *        <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the
         *        <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
         *        UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
         *        featured results set for each index, whether the status is <code>ACTIVE</code> or
         *        <code>INACTIVE</code>.
         * @see FeaturedResultsSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeaturedResultsSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results
         * are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>.
         * You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
         * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
         * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
         *        results are ready for use. You can still configure your settings before setting the status to
         *        <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the
         *        <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
         *        UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
         *        featured results set for each index, whether the status is <code>ACTIVE</code> or
         *        <code>INACTIVE</code>.
         * @see FeaturedResultsSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeaturedResultsSetStatus
         */
        Builder status(FeaturedResultsSetStatus status);

        /**
         * <p>
         * The list of queries for featuring results. For more information on the list of queries, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * 
         * @param queryTexts
         *        The list of queries for featuring results. For more information on the list of queries, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html"
         *        >FeaturedResultsSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTexts(Collection<String> queryTexts);

        /**
         * <p>
         * The list of queries for featuring results. For more information on the list of queries, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * 
         * @param queryTexts
         *        The list of queries for featuring results. For more information on the list of queries, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html"
         *        >FeaturedResultsSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTexts(String... queryTexts);

        /**
         * <p>
         * The list of document IDs for the documents you want to feature with their metadata information. For more
         * information on the list of featured documents, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * 
         * @param featuredDocumentsWithMetadata
         *        The list of document IDs for the documents you want to feature with their metadata information. For
         *        more information on the list of featured documents, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html"
         *        >FeaturedResultsSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredDocumentsWithMetadata(Collection<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata);

        /**
         * <p>
         * The list of document IDs for the documents you want to feature with their metadata information. For more
         * information on the list of featured documents, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * 
         * @param featuredDocumentsWithMetadata
         *        The list of document IDs for the documents you want to feature with their metadata information. For
         *        more information on the list of featured documents, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html"
         *        >FeaturedResultsSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredDocumentsWithMetadata(FeaturedDocumentWithMetadata... featuredDocumentsWithMetadata);

        /**
         * <p>
         * The list of document IDs for the documents you want to feature with their metadata information. For more
         * information on the list of featured documents, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #featuredDocumentsWithMetadata(List<FeaturedDocumentWithMetadata>)}.
         * 
         * @param featuredDocumentsWithMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featuredDocumentsWithMetadata(java.util.Collection<FeaturedDocumentWithMetadata>)
         */
        Builder featuredDocumentsWithMetadata(Consumer<FeaturedDocumentWithMetadata.Builder>... featuredDocumentsWithMetadata);

        /**
         * <p>
         * The list of document IDs that don't exist but you have specified as featured documents. Amazon Kendra cannot
         * feature these documents if they don't exist in the index. You can check the status of a document and its ID
         * or check for documents with status errors using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html"
         * >BatchGetDocumentStatus</a> API.
         * </p>
         * 
         * @param featuredDocumentsMissing
         *        The list of document IDs that don't exist but you have specified as featured documents. Amazon Kendra
         *        cannot feature these documents if they don't exist in the index. You can check the status of a
         *        document and its ID or check for documents with status errors using the <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html"
         *        >BatchGetDocumentStatus</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredDocumentsMissing(Collection<FeaturedDocumentMissing> featuredDocumentsMissing);

        /**
         * <p>
         * The list of document IDs that don't exist but you have specified as featured documents. Amazon Kendra cannot
         * feature these documents if they don't exist in the index. You can check the status of a document and its ID
         * or check for documents with status errors using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html"
         * >BatchGetDocumentStatus</a> API.
         * </p>
         * 
         * @param featuredDocumentsMissing
         *        The list of document IDs that don't exist but you have specified as featured documents. Amazon Kendra
         *        cannot feature these documents if they don't exist in the index. You can check the status of a
         *        document and its ID or check for documents with status errors using the <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html"
         *        >BatchGetDocumentStatus</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredDocumentsMissing(FeaturedDocumentMissing... featuredDocumentsMissing);

        /**
         * <p>
         * The list of document IDs that don't exist but you have specified as featured documents. Amazon Kendra cannot
         * feature these documents if they don't exist in the index. You can check the status of a document and its ID
         * or check for documents with status errors using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html"
         * >BatchGetDocumentStatus</a> API.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing.Builder#build()} is called
         * immediately and its result is passed to {@link #featuredDocumentsMissing(List<FeaturedDocumentMissing>)}.
         * 
         * @param featuredDocumentsMissing
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featuredDocumentsMissing(java.util.Collection<FeaturedDocumentMissing>)
         */
        Builder featuredDocumentsMissing(Consumer<FeaturedDocumentMissing.Builder>... featuredDocumentsMissing);

        /**
         * <p>
         * The timestamp when the set of featured results was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The timestamp when the set of featured results was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Long lastUpdatedTimestamp);

        /**
         * <p>
         * The Unix timestamp when the set of the featured results was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The Unix timestamp when the set of the featured results was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Long creationTimestamp);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String featuredResultsSetId;

        private String featuredResultsSetName;

        private String description;

        private String status;

        private List<String> queryTexts = DefaultSdkAutoConstructList.getInstance();

        private List<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata = DefaultSdkAutoConstructList.getInstance();

        private List<FeaturedDocumentMissing> featuredDocumentsMissing = DefaultSdkAutoConstructList.getInstance();

        private Long lastUpdatedTimestamp;

        private Long creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeaturedResultsSetResponse model) {
            super(model);
            featuredResultsSetId(model.featuredResultsSetId);
            featuredResultsSetName(model.featuredResultsSetName);
            description(model.description);
            status(model.status);
            queryTexts(model.queryTexts);
            featuredDocumentsWithMetadata(model.featuredDocumentsWithMetadata);
            featuredDocumentsMissing(model.featuredDocumentsMissing);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            creationTimestamp(model.creationTimestamp);
        }

        public final String getFeaturedResultsSetId() {
            return featuredResultsSetId;
        }

        public final void setFeaturedResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
        }

        @Override
        public final Builder featuredResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
            return this;
        }

        public final String getFeaturedResultsSetName() {
            return featuredResultsSetName;
        }

        public final void setFeaturedResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
        }

        @Override
        public final Builder featuredResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeaturedResultsSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getQueryTexts() {
            if (queryTexts instanceof SdkAutoConstructList) {
                return null;
            }
            return queryTexts;
        }

        public final void setQueryTexts(Collection<String> queryTexts) {
            this.queryTexts = QueryTextListCopier.copy(queryTexts);
        }

        @Override
        public final Builder queryTexts(Collection<String> queryTexts) {
            this.queryTexts = QueryTextListCopier.copy(queryTexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryTexts(String... queryTexts) {
            queryTexts(Arrays.asList(queryTexts));
            return this;
        }

        public final List<FeaturedDocumentWithMetadata.Builder> getFeaturedDocumentsWithMetadata() {
            List<FeaturedDocumentWithMetadata.Builder> result = FeaturedDocumentWithMetadataListCopier
                    .copyToBuilder(this.featuredDocumentsWithMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedDocumentsWithMetadata(
                Collection<FeaturedDocumentWithMetadata.BuilderImpl> featuredDocumentsWithMetadata) {
            this.featuredDocumentsWithMetadata = FeaturedDocumentWithMetadataListCopier
                    .copyFromBuilder(featuredDocumentsWithMetadata);
        }

        @Override
        public final Builder featuredDocumentsWithMetadata(Collection<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata) {
            this.featuredDocumentsWithMetadata = FeaturedDocumentWithMetadataListCopier.copy(featuredDocumentsWithMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocumentsWithMetadata(FeaturedDocumentWithMetadata... featuredDocumentsWithMetadata) {
            featuredDocumentsWithMetadata(Arrays.asList(featuredDocumentsWithMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocumentsWithMetadata(
                Consumer<FeaturedDocumentWithMetadata.Builder>... featuredDocumentsWithMetadata) {
            featuredDocumentsWithMetadata(Stream.of(featuredDocumentsWithMetadata)
                    .map(c -> FeaturedDocumentWithMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FeaturedDocumentMissing.Builder> getFeaturedDocumentsMissing() {
            List<FeaturedDocumentMissing.Builder> result = FeaturedDocumentMissingListCopier
                    .copyToBuilder(this.featuredDocumentsMissing);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedDocumentsMissing(Collection<FeaturedDocumentMissing.BuilderImpl> featuredDocumentsMissing) {
            this.featuredDocumentsMissing = FeaturedDocumentMissingListCopier.copyFromBuilder(featuredDocumentsMissing);
        }

        @Override
        public final Builder featuredDocumentsMissing(Collection<FeaturedDocumentMissing> featuredDocumentsMissing) {
            this.featuredDocumentsMissing = FeaturedDocumentMissingListCopier.copy(featuredDocumentsMissing);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocumentsMissing(FeaturedDocumentMissing... featuredDocumentsMissing) {
            featuredDocumentsMissing(Arrays.asList(featuredDocumentsMissing));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocumentsMissing(Consumer<FeaturedDocumentMissing.Builder>... featuredDocumentsMissing) {
            featuredDocumentsMissing(Stream.of(featuredDocumentsMissing)
                    .map(c -> FeaturedDocumentMissing.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Long lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Long lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Long getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public DescribeFeaturedResultsSetResponse build() {
            return new DescribeFeaturedResultsSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
