/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePrincipalMappingRequest extends KendraRequest implements
        ToCopyableBuilder<DescribePrincipalMappingRequest.Builder, DescribePrincipalMappingRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DescribePrincipalMappingRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(DescribePrincipalMappingRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(DescribePrincipalMappingRequest::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            DATA_SOURCE_ID_FIELD, GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexId;

    private final String dataSourceId;

    private final String groupId;

    private DescribePrincipalMappingRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.groupId = builder.groupId;
    }

    /**
     * <p>
     * The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code> actions
     * for mapping users to their groups.
     * </p>
     * 
     * @return The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code>
     *         actions for mapping users to their groups.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code> actions for
     * mapping users to their groups.
     * </p>
     * 
     * @return The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code>
     *         actions for mapping users to their groups.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code> actions
     * for mapping users to their groups.
     * </p>
     * 
     * @return The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code>
     *         actions for mapping users to their groups.
     */
    public final String groupId() {
        return groupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrincipalMappingRequest)) {
            return false;
        }
        DescribePrincipalMappingRequest other = (DescribePrincipalMappingRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(groupId(), other.groupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePrincipalMappingRequest").add("IndexId", indexId()).add("DataSourceId", dataSourceId())
                .add("GroupId", groupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("DataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePrincipalMappingRequest, T> g) {
        return obj -> g.apply((DescribePrincipalMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePrincipalMappingRequest> {
        /**
         * <p>
         * The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code>
         * actions for mapping users to their groups.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index required to check the processing of <code>PUT</code> and
         *        <code>DELETE</code> actions for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code> actions
         * for mapping users to their groups.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code>
         *        actions for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code>
         * actions for mapping users to their groups.
         * </p>
         * 
         * @param groupId
         *        The identifier of the group required to check the processing of <code>PUT</code> and
         *        <code>DELETE</code> actions for mapping users to their groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String dataSourceId;

        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrincipalMappingRequest model) {
            super(model);
            indexId(model.indexId);
            dataSourceId(model.dataSourceId);
            groupId(model.groupId);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePrincipalMappingRequest build() {
            return new DescribePrincipalMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
