/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQuerySuggestionsBlockListResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeQuerySuggestionsBlockListResponse.Builder, DescribeQuerySuggestionsBlockListResponse> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DescribeQuerySuggestionsBlockListResponse::indexId))
            .setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeQuerySuggestionsBlockListResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeQuerySuggestionsBlockListResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeQuerySuggestionsBlockListResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeQuerySuggestionsBlockListResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeQuerySuggestionsBlockListResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeQuerySuggestionsBlockListResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeQuerySuggestionsBlockListResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<S3Path> SOURCE_S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("SourceS3Path").getter(getter(DescribeQuerySuggestionsBlockListResponse::sourceS3Path))
            .setter(setter(Builder::sourceS3Path)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Path").build()).build();

    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ItemCount").getter(getter(DescribeQuerySuggestionsBlockListResponse::itemCount))
            .setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<Long> FILE_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FileSizeBytes").getter(getter(DescribeQuerySuggestionsBlockListResponse::fileSizeBytes))
            .setter(setter(Builder::fileSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSizeBytes").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeQuerySuggestionsBlockListResponse::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            SOURCE_S3_PATH_FIELD, ITEM_COUNT_FIELD, FILE_SIZE_BYTES_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexId;

    private final String id;

    private final String name;

    private final String description;

    private final String status;

    private final String errorMessage;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final S3Path sourceS3Path;

    private final Integer itemCount;

    private final Long fileSizeBytes;

    private final String roleArn;

    private DescribeQuerySuggestionsBlockListResponse(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.sourceS3Path = builder.sourceS3Path;
        this.itemCount = builder.itemCount;
        this.fileSizeBytes = builder.fileSizeBytes;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The identifier of the index for the block list.
     * </p>
     * 
     * @return The identifier of the index for the block list.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the block list.
     * </p>
     * 
     * @return The identifier of the block list.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the block list.
     * </p>
     * 
     * @return The name of the block list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the block list.
     * </p>
     * 
     * @return The description for the block list.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuerySuggestionsBlockListStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready for
     *         use.
     * @see QuerySuggestionsBlockListStatus
     */
    public final QuerySuggestionsBlockListStatus status() {
        return QuerySuggestionsBlockListStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuerySuggestionsBlockListStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready for
     *         use.
     * @see QuerySuggestionsBlockListStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error message containing details if there are issues processing the block list.
     * </p>
     * 
     * @return The error message containing details if there are issues processing the block list.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The Unix timestamp when a block list for query suggestions was created.
     * </p>
     * 
     * @return The Unix timestamp when a block list for query suggestions was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when a block list for query suggestions was last updated.
     * </p>
     * 
     * @return The Unix timestamp when a block list for query suggestions was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Shows the current S3 path to your block list text file in your S3 bucket.
     * </p>
     * <p>
     * Each block word or phrase should be on a separate line in a text file.
     * </p>
     * <p>
     * For information on the current quota limits for block lists, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     * </p>
     * 
     * @return Shows the current S3 path to your block list text file in your S3 bucket.</p>
     *         <p>
     *         Each block word or phrase should be on a separate line in a text file.
     *         </p>
     *         <p>
     *         For information on the current quota limits for block lists, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
     */
    public final S3Path sourceS3Path() {
        return sourceS3Path;
    }

    /**
     * <p>
     * The current number of valid, non-empty words or phrases in the block list text file.
     * </p>
     * 
     * @return The current number of valid, non-empty words or phrases in the block list text file.
     */
    public final Integer itemCount() {
        return itemCount;
    }

    /**
     * <p>
     * The current size of the block list text file in S3.
     * </p>
     * 
     * @return The current size of the block list text file in S3.
     */
    public final Long fileSizeBytes() {
        return fileSizeBytes;
    }

    /**
     * <p>
     * The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in S3.
     * </p>
     * <p>
     * The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role
     * permissions to Amazon Kendra.
     * </p>
     * 
     * @return The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in
     *         S3.</p>
     *         <p>
     *         The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service)
     *         assume role permissions to Amazon Kendra.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(fileSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQuerySuggestionsBlockListResponse)) {
            return false;
        }
        DescribeQuerySuggestionsBlockListResponse other = (DescribeQuerySuggestionsBlockListResponse) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(sourceS3Path(), other.sourceS3Path())
                && Objects.equals(itemCount(), other.itemCount()) && Objects.equals(fileSizeBytes(), other.fileSizeBytes())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeQuerySuggestionsBlockListResponse").add("IndexId", indexId()).add("Id", id())
                .add("Name", name()).add("Description", description()).add("Status", statusAsString())
                .add("ErrorMessage", errorMessage()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("SourceS3Path", sourceS3Path()).add("ItemCount", itemCount()).add("FileSizeBytes", fileSizeBytes())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "SourceS3Path":
            return Optional.ofNullable(clazz.cast(sourceS3Path()));
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "FileSizeBytes":
            return Optional.ofNullable(clazz.cast(fileSizeBytes()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("SourceS3Path", SOURCE_S3_PATH_FIELD);
        map.put("ItemCount", ITEM_COUNT_FIELD);
        map.put("FileSizeBytes", FILE_SIZE_BYTES_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeQuerySuggestionsBlockListResponse, T> g) {
        return obj -> g.apply((DescribeQuerySuggestionsBlockListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeQuerySuggestionsBlockListResponse> {
        /**
         * <p>
         * The identifier of the index for the block list.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for the block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the block list.
         * </p>
         * 
         * @param id
         *        The identifier of the block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the block list.
         * </p>
         * 
         * @param name
         *        The name of the block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the block list.
         * </p>
         * 
         * @param description
         *        The description for the block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready for use.
         * </p>
         * 
         * @param status
         *        The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready
         *        for use.
         * @see QuerySuggestionsBlockListStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuerySuggestionsBlockListStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready for use.
         * </p>
         * 
         * @param status
         *        The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready
         *        for use.
         * @see QuerySuggestionsBlockListStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuerySuggestionsBlockListStatus
         */
        Builder status(QuerySuggestionsBlockListStatus status);

        /**
         * <p>
         * The error message containing details if there are issues processing the block list.
         * </p>
         * 
         * @param errorMessage
         *        The error message containing details if there are issues processing the block list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The Unix timestamp when a block list for query suggestions was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when a block list for query suggestions was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when a block list for query suggestions was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when a block list for query suggestions was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Shows the current S3 path to your block list text file in your S3 bucket.
         * </p>
         * <p>
         * Each block word or phrase should be on a separate line in a text file.
         * </p>
         * <p>
         * For information on the current quota limits for block lists, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * </p>
         * 
         * @param sourceS3Path
         *        Shows the current S3 path to your block list text file in your S3 bucket.</p>
         *        <p>
         *        Each block word or phrase should be on a separate line in a text file.
         *        </p>
         *        <p>
         *        For information on the current quota limits for block lists, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Path(S3Path sourceS3Path);

        /**
         * <p>
         * Shows the current S3 path to your block list text file in your S3 bucket.
         * </p>
         * <p>
         * Each block word or phrase should be on a separate line in a text file.
         * </p>
         * <p>
         * For information on the current quota limits for block lists, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Path.Builder} avoiding the need to
         * create one manually via {@link S3Path#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceS3Path(S3Path)}.
         * 
         * @param sourceS3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Path(S3Path)
         */
        default Builder sourceS3Path(Consumer<S3Path.Builder> sourceS3Path) {
            return sourceS3Path(S3Path.builder().applyMutation(sourceS3Path).build());
        }

        /**
         * <p>
         * The current number of valid, non-empty words or phrases in the block list text file.
         * </p>
         * 
         * @param itemCount
         *        The current number of valid, non-empty words or phrases in the block list text file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Integer itemCount);

        /**
         * <p>
         * The current size of the block list text file in S3.
         * </p>
         * 
         * @param fileSizeBytes
         *        The current size of the block list text file in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSizeBytes(Long fileSizeBytes);

        /**
         * <p>
         * The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in S3.
         * </p>
         * <p>
         * The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume
         * role permissions to Amazon Kendra.
         * </p>
         * 
         * @param roleArn
         *        The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file
         *        in S3.</p>
         *        <p>
         *        The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service)
         *        assume role permissions to Amazon Kendra.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String indexId;

        private String id;

        private String name;

        private String description;

        private String status;

        private String errorMessage;

        private Instant createdAt;

        private Instant updatedAt;

        private S3Path sourceS3Path;

        private Integer itemCount;

        private Long fileSizeBytes;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQuerySuggestionsBlockListResponse model) {
            super(model);
            indexId(model.indexId);
            id(model.id);
            name(model.name);
            description(model.description);
            status(model.status);
            errorMessage(model.errorMessage);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            sourceS3Path(model.sourceS3Path);
            itemCount(model.itemCount);
            fileSizeBytes(model.fileSizeBytes);
            roleArn(model.roleArn);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuerySuggestionsBlockListStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final S3Path.Builder getSourceS3Path() {
            return sourceS3Path != null ? sourceS3Path.toBuilder() : null;
        }

        public final void setSourceS3Path(S3Path.BuilderImpl sourceS3Path) {
            this.sourceS3Path = sourceS3Path != null ? sourceS3Path.build() : null;
        }

        @Override
        public final Builder sourceS3Path(S3Path sourceS3Path) {
            this.sourceS3Path = sourceS3Path;
            return this;
        }

        public final Integer getItemCount() {
            return itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Long getFileSizeBytes() {
            return fileSizeBytes;
        }

        public final void setFileSizeBytes(Long fileSizeBytes) {
            this.fileSizeBytes = fileSizeBytes;
        }

        @Override
        public final Builder fileSizeBytes(Long fileSizeBytes) {
            this.fileSizeBytes = fileSizeBytes;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public DescribeQuerySuggestionsBlockListResponse build() {
            return new DescribeQuerySuggestionsBlockListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
