/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target document attribute or metadata field you want to alter when ingesting documents into Amazon Kendra.
 * </p>
 * <p>
 * For example, you can delete customer identification numbers associated with the documents, stored in the document
 * metadata field called 'Customer_ID'. You set the target key as 'Customer_ID' and the deletion flag to
 * <code>TRUE</code>. This removes all customer ID values in the field 'Customer_ID'. This would scrub personally
 * identifiable information from each document's metadata.
 * </p>
 * <p>
 * Amazon Kendra cannot create a target field if it has not already been created as an index field. After you create
 * your index field, you can create a document metadata field using <code>DocumentAttributeTarget</code>. Amazon Kendra
 * then will map your newly created metadata field to your index field.
 * </p>
 * <p>
 * You can also use this with <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeCondition.html">
 * DocumentAttributeCondition</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeTarget.Builder, DocumentAttributeTarget> {
    private static final SdkField<String> TARGET_DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetDocumentAttributeKey")
            .getter(getter(DocumentAttributeTarget::targetDocumentAttributeKey))
            .setter(setter(Builder::targetDocumentAttributeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDocumentAttributeKey").build())
            .build();

    private static final SdkField<Boolean> TARGET_DOCUMENT_ATTRIBUTE_VALUE_DELETION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TargetDocumentAttributeValueDeletion")
            .getter(getter(DocumentAttributeTarget::targetDocumentAttributeValueDeletion))
            .setter(setter(Builder::targetDocumentAttributeValueDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TargetDocumentAttributeValueDeletion").build()).build();

    private static final SdkField<DocumentAttributeValue> TARGET_DOCUMENT_ATTRIBUTE_VALUE_FIELD = SdkField
            .<DocumentAttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("TargetDocumentAttributeValue")
            .getter(getter(DocumentAttributeTarget::targetDocumentAttributeValue))
            .setter(setter(Builder::targetDocumentAttributeValue))
            .constructor(DocumentAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDocumentAttributeValue")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TARGET_DOCUMENT_ATTRIBUTE_KEY_FIELD, TARGET_DOCUMENT_ATTRIBUTE_VALUE_DELETION_FIELD,
            TARGET_DOCUMENT_ATTRIBUTE_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetDocumentAttributeKey;

    private final Boolean targetDocumentAttributeValueDeletion;

    private final DocumentAttributeValue targetDocumentAttributeValue;

    private DocumentAttributeTarget(BuilderImpl builder) {
        this.targetDocumentAttributeKey = builder.targetDocumentAttributeKey;
        this.targetDocumentAttributeValueDeletion = builder.targetDocumentAttributeValueDeletion;
        this.targetDocumentAttributeValue = builder.targetDocumentAttributeValue;
    }

    /**
     * <p>
     * The identifier of the target document attribute or metadata field.
     * </p>
     * <p>
     * For example, 'Department' could be an identifier for the target attribute or metadata field that includes the
     * department names associated with the documents.
     * </p>
     * 
     * @return The identifier of the target document attribute or metadata field.</p>
     *         <p>
     *         For example, 'Department' could be an identifier for the target attribute or metadata field that includes
     *         the department names associated with the documents.
     */
    public final String targetDocumentAttributeKey() {
        return targetDocumentAttributeKey;
    }

    /**
     * <p>
     * <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot create
     * a target value and set this to <code>TRUE</code>. To create a target value (
     * <code>TargetDocumentAttributeValue</code>), set this to <code>FALSE</code>.
     * </p>
     * 
     * @return <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot
     *         create a target value and set this to <code>TRUE</code>. To create a target value (
     *         <code>TargetDocumentAttributeValue</code>), set this to <code>FALSE</code>.
     */
    public final Boolean targetDocumentAttributeValueDeletion() {
        return targetDocumentAttributeValueDeletion;
    }

    /**
     * <p>
     * The target value you want to create for the target attribute.
     * </p>
     * <p>
     * For example, 'Finance' could be the target value for the target attribute key 'Department'.
     * </p>
     * 
     * @return The target value you want to create for the target attribute.</p>
     *         <p>
     *         For example, 'Finance' could be the target value for the target attribute key 'Department'.
     */
    public final DocumentAttributeValue targetDocumentAttributeValue() {
        return targetDocumentAttributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetDocumentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(targetDocumentAttributeValueDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(targetDocumentAttributeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeTarget)) {
            return false;
        }
        DocumentAttributeTarget other = (DocumentAttributeTarget) obj;
        return Objects.equals(targetDocumentAttributeKey(), other.targetDocumentAttributeKey())
                && Objects.equals(targetDocumentAttributeValueDeletion(), other.targetDocumentAttributeValueDeletion())
                && Objects.equals(targetDocumentAttributeValue(), other.targetDocumentAttributeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttributeTarget").add("TargetDocumentAttributeKey", targetDocumentAttributeKey())
                .add("TargetDocumentAttributeValueDeletion", targetDocumentAttributeValueDeletion())
                .add("TargetDocumentAttributeValue", targetDocumentAttributeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetDocumentAttributeKey":
            return Optional.ofNullable(clazz.cast(targetDocumentAttributeKey()));
        case "TargetDocumentAttributeValueDeletion":
            return Optional.ofNullable(clazz.cast(targetDocumentAttributeValueDeletion()));
        case "TargetDocumentAttributeValue":
            return Optional.ofNullable(clazz.cast(targetDocumentAttributeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetDocumentAttributeKey", TARGET_DOCUMENT_ATTRIBUTE_KEY_FIELD);
        map.put("TargetDocumentAttributeValueDeletion", TARGET_DOCUMENT_ATTRIBUTE_VALUE_DELETION_FIELD);
        map.put("TargetDocumentAttributeValue", TARGET_DOCUMENT_ATTRIBUTE_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeTarget, T> g) {
        return obj -> g.apply((DocumentAttributeTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeTarget> {
        /**
         * <p>
         * The identifier of the target document attribute or metadata field.
         * </p>
         * <p>
         * For example, 'Department' could be an identifier for the target attribute or metadata field that includes the
         * department names associated with the documents.
         * </p>
         * 
         * @param targetDocumentAttributeKey
         *        The identifier of the target document attribute or metadata field.</p>
         *        <p>
         *        For example, 'Department' could be an identifier for the target attribute or metadata field that
         *        includes the department names associated with the documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDocumentAttributeKey(String targetDocumentAttributeKey);

        /**
         * <p>
         * <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot
         * create a target value and set this to <code>TRUE</code>. To create a target value (
         * <code>TargetDocumentAttributeValue</code>), set this to <code>FALSE</code>.
         * </p>
         * 
         * @param targetDocumentAttributeValueDeletion
         *        <code>TRUE</code> to delete the existing target value for your specified target attribute key. You
         *        cannot create a target value and set this to <code>TRUE</code>. To create a target value (
         *        <code>TargetDocumentAttributeValue</code>), set this to <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDocumentAttributeValueDeletion(Boolean targetDocumentAttributeValueDeletion);

        /**
         * <p>
         * The target value you want to create for the target attribute.
         * </p>
         * <p>
         * For example, 'Finance' could be the target value for the target attribute key 'Department'.
         * </p>
         * 
         * @param targetDocumentAttributeValue
         *        The target value you want to create for the target attribute.</p>
         *        <p>
         *        For example, 'Finance' could be the target value for the target attribute key 'Department'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDocumentAttributeValue(DocumentAttributeValue targetDocumentAttributeValue);

        /**
         * <p>
         * The target value you want to create for the target attribute.
         * </p>
         * <p>
         * For example, 'Finance' could be the target value for the target attribute key 'Department'.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttributeValue.Builder} avoiding
         * the need to create one manually via {@link DocumentAttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #targetDocumentAttributeValue(DocumentAttributeValue)}.
         * 
         * @param targetDocumentAttributeValue
         *        a consumer that will call methods on {@link DocumentAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetDocumentAttributeValue(DocumentAttributeValue)
         */
        default Builder targetDocumentAttributeValue(Consumer<DocumentAttributeValue.Builder> targetDocumentAttributeValue) {
            return targetDocumentAttributeValue(DocumentAttributeValue.builder().applyMutation(targetDocumentAttributeValue)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetDocumentAttributeKey;

        private Boolean targetDocumentAttributeValueDeletion;

        private DocumentAttributeValue targetDocumentAttributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeTarget model) {
            targetDocumentAttributeKey(model.targetDocumentAttributeKey);
            targetDocumentAttributeValueDeletion(model.targetDocumentAttributeValueDeletion);
            targetDocumentAttributeValue(model.targetDocumentAttributeValue);
        }

        public final String getTargetDocumentAttributeKey() {
            return targetDocumentAttributeKey;
        }

        public final void setTargetDocumentAttributeKey(String targetDocumentAttributeKey) {
            this.targetDocumentAttributeKey = targetDocumentAttributeKey;
        }

        @Override
        public final Builder targetDocumentAttributeKey(String targetDocumentAttributeKey) {
            this.targetDocumentAttributeKey = targetDocumentAttributeKey;
            return this;
        }

        public final Boolean getTargetDocumentAttributeValueDeletion() {
            return targetDocumentAttributeValueDeletion;
        }

        public final void setTargetDocumentAttributeValueDeletion(Boolean targetDocumentAttributeValueDeletion) {
            this.targetDocumentAttributeValueDeletion = targetDocumentAttributeValueDeletion;
        }

        @Override
        public final Builder targetDocumentAttributeValueDeletion(Boolean targetDocumentAttributeValueDeletion) {
            this.targetDocumentAttributeValueDeletion = targetDocumentAttributeValueDeletion;
            return this;
        }

        public final DocumentAttributeValue.Builder getTargetDocumentAttributeValue() {
            return targetDocumentAttributeValue != null ? targetDocumentAttributeValue.toBuilder() : null;
        }

        public final void setTargetDocumentAttributeValue(DocumentAttributeValue.BuilderImpl targetDocumentAttributeValue) {
            this.targetDocumentAttributeValue = targetDocumentAttributeValue != null ? targetDocumentAttributeValue.build()
                    : null;
        }

        @Override
        public final Builder targetDocumentAttributeValue(DocumentAttributeValue targetDocumentAttributeValue) {
            this.targetDocumentAttributeValue = targetDocumentAttributeValue;
            return this;
        }

        @Override
        public DocumentAttributeTarget build() {
            return new DocumentAttributeTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
