/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the count of documents that match a particular document attribute or field when doing a faceted search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeValueCountPair implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeValueCountPair.Builder, DocumentAttributeValueCountPair> {
    private static final SdkField<DocumentAttributeValue> DOCUMENT_ATTRIBUTE_VALUE_FIELD = SdkField
            .<DocumentAttributeValue> builder(MarshallingType.SDK_POJO).memberName("DocumentAttributeValue")
            .getter(getter(DocumentAttributeValueCountPair::documentAttributeValue))
            .setter(setter(Builder::documentAttributeValue)).constructor(DocumentAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeValue").build())
            .build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(DocumentAttributeValueCountPair::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<List<FacetResult>> FACET_RESULTS_FIELD = SdkField
            .<List<FacetResult>> builder(MarshallingType.LIST)
            .memberName("FacetResults")
            .getter(getter(DocumentAttributeValueCountPair::facetResults))
            .setter(setter(Builder::facetResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FacetResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(FacetResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCUMENT_ATTRIBUTE_VALUE_FIELD, COUNT_FIELD, FACET_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentAttributeValue documentAttributeValue;

    private final Integer count;

    private final List<FacetResult> facetResults;

    private DocumentAttributeValueCountPair(BuilderImpl builder) {
        this.documentAttributeValue = builder.documentAttributeValue;
        this.count = builder.count;
        this.facetResults = builder.facetResults;
    }

    /**
     * <p>
     * The value of the attribute/field. For example, "HR".
     * </p>
     * 
     * @return The value of the attribute/field. For example, "HR".
     */
    public final DocumentAttributeValue documentAttributeValue() {
        return documentAttributeValue;
    }

    /**
     * <p>
     * The number of documents in the response that have the attribute/field value for the key.
     * </p>
     * 
     * @return The number of documents in the response that have the attribute/field value for the key.
     */
    public final Integer count() {
        return count;
    }

    /**
     * For responses, this returns true if the service returned a value for the FacetResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFacetResults() {
        return facetResults != null && !(facetResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the results of a document attribute/field that is a nested facet. A <code>FacetResult</code> contains
     * the counts for each facet nested within a facet.
     * </p>
     * <p>
     * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition, the
     * document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents assigned
     * to "Engineering". You can display nested facets in the search results so that documents can be searched not only
     * by department but also by a sub department within a department. The counts for documents that belong to
     * "Frontend" and "Backend" within "Engineering" are returned for a query.
     * </p>
     * <p/>
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFacetResults} method.
     * </p>
     * 
     * @return Contains the results of a document attribute/field that is a nested facet. A <code>FacetResult</code>
     *         contains the counts for each facet nested within a facet.</p>
     *         <p>
     *         For example, the document attribute or facet "Department" includes a value called "Engineering". In
     *         addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend"
     *         for documents assigned to "Engineering". You can display nested facets in the search results so that
     *         documents can be searched not only by department but also by a sub department within a department. The
     *         counts for documents that belong to "Frontend" and "Backend" within "Engineering" are returned for a
     *         query.
     *         </p>
     *         <p/>
     */
    public final List<FacetResult> facetResults() {
        return facetResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasFacetResults() ? facetResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeValueCountPair)) {
            return false;
        }
        DocumentAttributeValueCountPair other = (DocumentAttributeValueCountPair) obj;
        return Objects.equals(documentAttributeValue(), other.documentAttributeValue()) && Objects.equals(count(), other.count())
                && hasFacetResults() == other.hasFacetResults() && Objects.equals(facetResults(), other.facetResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttributeValueCountPair").add("DocumentAttributeValue", documentAttributeValue())
                .add("Count", count()).add("FacetResults", hasFacetResults() ? facetResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentAttributeValue":
            return Optional.ofNullable(clazz.cast(documentAttributeValue()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "FacetResults":
            return Optional.ofNullable(clazz.cast(facetResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentAttributeValue", DOCUMENT_ATTRIBUTE_VALUE_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("FacetResults", FACET_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeValueCountPair, T> g) {
        return obj -> g.apply((DocumentAttributeValueCountPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeValueCountPair> {
        /**
         * <p>
         * The value of the attribute/field. For example, "HR".
         * </p>
         * 
         * @param documentAttributeValue
         *        The value of the attribute/field. For example, "HR".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeValue(DocumentAttributeValue documentAttributeValue);

        /**
         * <p>
         * The value of the attribute/field. For example, "HR".
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttributeValue.Builder} avoiding
         * the need to create one manually via {@link DocumentAttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #documentAttributeValue(DocumentAttributeValue)}.
         * 
         * @param documentAttributeValue
         *        a consumer that will call methods on {@link DocumentAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributeValue(DocumentAttributeValue)
         */
        default Builder documentAttributeValue(Consumer<DocumentAttributeValue.Builder> documentAttributeValue) {
            return documentAttributeValue(DocumentAttributeValue.builder().applyMutation(documentAttributeValue).build());
        }

        /**
         * <p>
         * The number of documents in the response that have the attribute/field value for the key.
         * </p>
         * 
         * @param count
         *        The number of documents in the response that have the attribute/field value for the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * Contains the results of a document attribute/field that is a nested facet. A <code>FacetResult</code>
         * contains the counts for each facet nested within a facet.
         * </p>
         * <p>
         * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition,
         * the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents
         * assigned to "Engineering". You can display nested facets in the search results so that documents can be
         * searched not only by department but also by a sub department within a department. The counts for documents
         * that belong to "Frontend" and "Backend" within "Engineering" are returned for a query.
         * </p>
         * <p/>
         * <p/>
         * 
         * @param facetResults
         *        Contains the results of a document attribute/field that is a nested facet. A <code>FacetResult</code>
         *        contains the counts for each facet nested within a facet.
         *        </p>
         *        <p>
         *        For example, the document attribute or facet "Department" includes a value called "Engineering". In
         *        addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend"
         *        for documents assigned to "Engineering". You can display nested facets in the search results so that
         *        documents can be searched not only by department but also by a sub department within a department. The
         *        counts for documents that belong to "Frontend" and "Backend" within "Engineering" are returned for a
         *        query.
         *        </p>
         *        <p/>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetResults(Collection<FacetResult> facetResults);

        /**
         * <p>
         * Contains the results of a document attribute/field that is a nested facet. A <code>FacetResult</code>
         * contains the counts for each facet nested within a facet.
         * </p>
         * <p>
         * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition,
         * the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents
         * assigned to "Engineering". You can display nested facets in the search results so that documents can be
         * searched not only by department but also by a sub department within a department. The counts for documents
         * that belong to "Frontend" and "Backend" within "Engineering" are returned for a query.
         * </p>
         * <p/>
         * <p/>
         * 
         * @param facetResults
         *        Contains the results of a document attribute/field that is a nested facet. A <code>FacetResult</code>
         *        contains the counts for each facet nested within a facet.
         *        </p>
         *        <p>
         *        For example, the document attribute or facet "Department" includes a value called "Engineering". In
         *        addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend"
         *        for documents assigned to "Engineering". You can display nested facets in the search results so that
         *        documents can be searched not only by department but also by a sub department within a department. The
         *        counts for documents that belong to "Frontend" and "Backend" within "Engineering" are returned for a
         *        query.
         *        </p>
         *        <p/>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetResults(FacetResult... facetResults);

        /**
         * <p>
         * Contains the results of a document attribute/field that is a nested facet. A <code>FacetResult</code>
         * contains the counts for each facet nested within a facet.
         * </p>
         * <p>
         * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition,
         * the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents
         * assigned to "Engineering". You can display nested facets in the search results so that documents can be
         * searched not only by department but also by a sub department within a department. The counts for documents
         * that belong to "Frontend" and "Backend" within "Engineering" are returned for a query.
         * </p>
         * <p/>
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.FacetResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.FacetResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.FacetResult.Builder#build()} is called immediately and
         * its result is passed to {@link #facetResults(List<FacetResult>)}.
         * 
         * @param facetResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.FacetResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facetResults(java.util.Collection<FacetResult>)
         */
        Builder facetResults(Consumer<FacetResult.Builder>... facetResults);
    }

    static final class BuilderImpl implements Builder {
        private DocumentAttributeValue documentAttributeValue;

        private Integer count;

        private List<FacetResult> facetResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeValueCountPair model) {
            documentAttributeValue(model.documentAttributeValue);
            count(model.count);
            facetResults(model.facetResults);
        }

        public final DocumentAttributeValue.Builder getDocumentAttributeValue() {
            return documentAttributeValue != null ? documentAttributeValue.toBuilder() : null;
        }

        public final void setDocumentAttributeValue(DocumentAttributeValue.BuilderImpl documentAttributeValue) {
            this.documentAttributeValue = documentAttributeValue != null ? documentAttributeValue.build() : null;
        }

        @Override
        public final Builder documentAttributeValue(DocumentAttributeValue documentAttributeValue) {
            this.documentAttributeValue = documentAttributeValue;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final List<FacetResult.Builder> getFacetResults() {
            List<FacetResult.Builder> result = FacetResultListCopier.copyToBuilder(this.facetResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFacetResults(Collection<FacetResult.BuilderImpl> facetResults) {
            this.facetResults = FacetResultListCopier.copyFromBuilder(facetResults);
        }

        @Override
        public final Builder facetResults(Collection<FacetResult> facetResults) {
            this.facetResults = FacetResultListCopier.copy(facetResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(FacetResult... facetResults) {
            facetResults(Arrays.asList(facetResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(Consumer<FacetResult.Builder>... facetResults) {
            facetResults(Stream.of(facetResults).map(c -> FacetResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DocumentAttributeValueCountPair build() {
            return new DocumentAttributeValueCountPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
