/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Overrides the document relevance properties of a custom index field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentRelevanceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentRelevanceConfiguration.Builder, DocumentRelevanceConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DocumentRelevanceConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Relevance> RELEVANCE_FIELD = SdkField.<Relevance> builder(MarshallingType.SDK_POJO)
            .memberName("Relevance").getter(getter(DocumentRelevanceConfiguration::relevance)).setter(setter(Builder::relevance))
            .constructor(Relevance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relevance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RELEVANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Relevance relevance;

    private DocumentRelevanceConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.relevance = builder.relevance;
    }

    /**
     * <p>
     * The name of the index field.
     * </p>
     * 
     * @return The name of the index field.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Provides information for tuning the relevance of a field in a search. When a query includes terms that match the
     * field, the results are given a boost in the response based on these tuning parameters.
     * </p>
     * 
     * @return Provides information for tuning the relevance of a field in a search. When a query includes terms that
     *         match the field, the results are given a boost in the response based on these tuning parameters.
     */
    public final Relevance relevance() {
        return relevance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(relevance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentRelevanceConfiguration)) {
            return false;
        }
        DocumentRelevanceConfiguration other = (DocumentRelevanceConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(relevance(), other.relevance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentRelevanceConfiguration").add("Name", name()).add("Relevance", relevance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Relevance":
            return Optional.ofNullable(clazz.cast(relevance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Relevance", RELEVANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentRelevanceConfiguration, T> g) {
        return obj -> g.apply((DocumentRelevanceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentRelevanceConfiguration> {
        /**
         * <p>
         * The name of the index field.
         * </p>
         * 
         * @param name
         *        The name of the index field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Provides information for tuning the relevance of a field in a search. When a query includes terms that match
         * the field, the results are given a boost in the response based on these tuning parameters.
         * </p>
         * 
         * @param relevance
         *        Provides information for tuning the relevance of a field in a search. When a query includes terms that
         *        match the field, the results are given a boost in the response based on these tuning parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevance(Relevance relevance);

        /**
         * <p>
         * Provides information for tuning the relevance of a field in a search. When a query includes terms that match
         * the field, the results are given a boost in the response based on these tuning parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link Relevance.Builder} avoiding the need to
         * create one manually via {@link Relevance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Relevance.Builder#build()} is called immediately and its result
         * is passed to {@link #relevance(Relevance)}.
         * 
         * @param relevance
         *        a consumer that will call methods on {@link Relevance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relevance(Relevance)
         */
        default Builder relevance(Consumer<Relevance.Builder> relevance) {
            return relevance(Relevance.builder().applyMutation(relevance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Relevance relevance;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentRelevanceConfiguration model) {
            name(model.name);
            relevance(model.relevance);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Relevance.Builder getRelevance() {
            return relevance != null ? relevance.toBuilder() : null;
        }

        public final void setRelevance(Relevance.BuilderImpl relevance) {
            this.relevance = relevance != null ? relevance.build() : null;
        }

        @Override
        public final Builder relevance(Relevance relevance) {
            this.relevance = relevance;
            return this;
        }

        @Override
        public DocumentRelevanceConfiguration build() {
            return new DocumentRelevanceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
