/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A featured document with its metadata information. This document is displayed at the top of the search results page,
 * placed above all other results for certain queries. If there's an exact match of a query, then the document is
 * featured in the search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeaturedDocumentWithMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<FeaturedDocumentWithMetadata.Builder, FeaturedDocumentWithMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FeaturedDocumentWithMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(FeaturedDocumentWithMetadata::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("URI")
            .getter(getter(FeaturedDocumentWithMetadata::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD,
            URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String title;

    private final String uri;

    private FeaturedDocumentWithMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.uri = builder.uri;
    }

    /**
     * <p>
     * The identifier of the featured document with its metadata. You can use the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> API to search for specific documents
     * with their document IDs included in the result items, or you can use the console.
     * </p>
     * 
     * @return The identifier of the featured document with its metadata. You can use the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> API to search for specific
     *         documents with their document IDs included in the result items, or you can use the console.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The main title of the featured document.
     * </p>
     * 
     * @return The main title of the featured document.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source URI location of the featured document.
     * </p>
     * 
     * @return The source URI location of the featured document.
     */
    public final String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeaturedDocumentWithMetadata)) {
            return false;
        }
        FeaturedDocumentWithMetadata other = (FeaturedDocumentWithMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(title(), other.title()) && Objects.equals(uri(), other.uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FeaturedDocumentWithMetadata").add("Id", id()).add("Title", title()).add("URI", uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "URI":
            return Optional.ofNullable(clazz.cast(uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("URI", URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeaturedDocumentWithMetadata, T> g) {
        return obj -> g.apply((FeaturedDocumentWithMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeaturedDocumentWithMetadata> {
        /**
         * <p>
         * The identifier of the featured document with its metadata. You can use the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> API to search for specific
         * documents with their document IDs included in the result items, or you can use the console.
         * </p>
         * 
         * @param id
         *        The identifier of the featured document with its metadata. You can use the <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> API to search for
         *        specific documents with their document IDs included in the result items, or you can use the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The main title of the featured document.
         * </p>
         * 
         * @param title
         *        The main title of the featured document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source URI location of the featured document.
         * </p>
         * 
         * @param uri
         *        The source URI location of the featured document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String title;

        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturedDocumentWithMetadata model) {
            id(model.id);
            title(model.title);
            uri(model.uri);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public FeaturedDocumentWithMetadata build() {
            return new FeaturedDocumentWithMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
