/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error message with a list of conflicting queries used across different sets of featured results. This occurred
 * with the request for a new featured results set. Check that the queries you specified for featured results are unique
 * per featured results set for each index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeaturedResultsConflictException extends KendraException implements
        ToCopyableBuilder<FeaturedResultsConflictException.Builder, FeaturedResultsConflictException> {
    private static final SdkField<List<ConflictingItem>> CONFLICTING_ITEMS_FIELD = SdkField
            .<List<ConflictingItem>> builder(MarshallingType.LIST)
            .memberName("ConflictingItems")
            .getter(getter(FeaturedResultsConflictException::conflictingItems))
            .setter(setter(Builder::conflictingItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictingItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConflictingItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConflictingItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICTING_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ConflictingItem> conflictingItems;

    private FeaturedResultsConflictException(BuilderImpl builder) {
        super(builder);
        this.conflictingItems = builder.conflictingItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConflictingItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasConflictingItems() {
        return conflictingItems != null && !(conflictingItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the conflicting queries, including the query text, the name for the featured results set, and the
     * identifier of the featured results set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConflictingItems} method.
     * </p>
     * 
     * @return A list of the conflicting queries, including the query text, the name for the featured results set, and
     *         the identifier of the featured results set.
     */
    public List<ConflictingItem> conflictingItems() {
        return conflictingItems;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConflictingItems", CONFLICTING_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeaturedResultsConflictException, T> g) {
        return obj -> g.apply((FeaturedResultsConflictException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeaturedResultsConflictException>, KendraException.Builder {
        /**
         * <p>
         * A list of the conflicting queries, including the query text, the name for the featured results set, and the
         * identifier of the featured results set.
         * </p>
         * 
         * @param conflictingItems
         *        A list of the conflicting queries, including the query text, the name for the featured results set,
         *        and the identifier of the featured results set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictingItems(Collection<ConflictingItem> conflictingItems);

        /**
         * <p>
         * A list of the conflicting queries, including the query text, the name for the featured results set, and the
         * identifier of the featured results set.
         * </p>
         * 
         * @param conflictingItems
         *        A list of the conflicting queries, including the query text, the name for the featured results set,
         *        and the identifier of the featured results set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictingItems(ConflictingItem... conflictingItems);

        /**
         * <p>
         * A list of the conflicting queries, including the query text, the name for the featured results set, and the
         * identifier of the featured results set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.ConflictingItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.ConflictingItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.ConflictingItem.Builder#build()} is called immediately
         * and its result is passed to {@link #conflictingItems(List<ConflictingItem>)}.
         * 
         * @param conflictingItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.ConflictingItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictingItems(java.util.Collection<ConflictingItem>)
         */
        Builder conflictingItems(Consumer<ConflictingItem.Builder>... conflictingItems);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends KendraException.BuilderImpl implements Builder {
        private List<ConflictingItem> conflictingItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturedResultsConflictException model) {
            super(model);
            conflictingItems(model.conflictingItems);
        }

        public final List<ConflictingItem.Builder> getConflictingItems() {
            List<ConflictingItem.Builder> result = ConflictingItemsCopier.copyToBuilder(this.conflictingItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConflictingItems(Collection<ConflictingItem.BuilderImpl> conflictingItems) {
            this.conflictingItems = ConflictingItemsCopier.copyFromBuilder(conflictingItems);
        }

        @Override
        public final Builder conflictingItems(Collection<ConflictingItem> conflictingItems) {
            this.conflictingItems = ConflictingItemsCopier.copy(conflictingItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictingItems(ConflictingItem... conflictingItems) {
            conflictingItems(Arrays.asList(conflictingItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictingItems(Consumer<ConflictingItem.Builder>... conflictingItems) {
            conflictingItems(Stream.of(conflictingItems).map(c -> ConflictingItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public FeaturedResultsConflictException build() {
            return new FeaturedResultsConflictException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
