/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for a set of featured results. Featured results are placed above all other results for certain
 * queries. If there's an exact match of a query, then one or more specific documents are featured in the search
 * results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeaturedResultsSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FeaturedResultsSetSummary.Builder, FeaturedResultsSetSummary> {
    private static final SdkField<String> FEATURED_RESULTS_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeaturedResultsSetId").getter(getter(FeaturedResultsSetSummary::featuredResultsSetId))
            .setter(setter(Builder::featuredResultsSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetId").build())
            .build();

    private static final SdkField<String> FEATURED_RESULTS_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeaturedResultsSetName").getter(getter(FeaturedResultsSetSummary::featuredResultsSetName))
            .setter(setter(Builder::featuredResultsSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FeaturedResultsSetSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Long> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastUpdatedTimestamp").getter(getter(FeaturedResultsSetSummary::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<Long> CREATION_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreationTimestamp").getter(getter(FeaturedResultsSetSummary::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURED_RESULTS_SET_ID_FIELD,
            FEATURED_RESULTS_SET_NAME_FIELD, STATUS_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, CREATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String featuredResultsSetId;

    private final String featuredResultsSetName;

    private final String status;

    private final Long lastUpdatedTimestamp;

    private final Long creationTimestamp;

    private FeaturedResultsSetSummary(BuilderImpl builder) {
        this.featuredResultsSetId = builder.featuredResultsSetId;
        this.featuredResultsSetName = builder.featuredResultsSetName;
        this.status = builder.status;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.creationTimestamp = builder.creationTimestamp;
    }

    /**
     * <p>
     * The identifier of the set of featured results.
     * </p>
     * 
     * @return The identifier of the set of featured results.
     */
    public final String featuredResultsSetId() {
        return featuredResultsSetId;
    }

    /**
     * <p>
     * The name for the set of featured results.
     * </p>
     * 
     * @return The name for the set of featured results.
     */
    public final String featuredResultsSetName() {
        return featuredResultsSetName;
    }

    /**
     * <p>
     * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are
     * ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can
     * set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
     * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
     * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeaturedResultsSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
     *         results are ready for use. You can still configure your settings before setting the status to
     *         <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
     *         UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
     *         featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * @see FeaturedResultsSetStatus
     */
    public final FeaturedResultsSetStatus status() {
        return FeaturedResultsSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are
     * ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can
     * set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
     * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
     * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeaturedResultsSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
     *         results are ready for use. You can still configure your settings before setting the status to
     *         <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
     *         UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
     *         featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
     * @see FeaturedResultsSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Unix timestamp when the set of featured results was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the set of featured results was last updated.
     */
    public final Long lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The Unix timestamp when the set of featured results was created.
     * </p>
     * 
     * @return The Unix timestamp when the set of featured results was created.
     */
    public final Long creationTimestamp() {
        return creationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featuredResultsSetId());
        hashCode = 31 * hashCode + Objects.hashCode(featuredResultsSetName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeaturedResultsSetSummary)) {
            return false;
        }
        FeaturedResultsSetSummary other = (FeaturedResultsSetSummary) obj;
        return Objects.equals(featuredResultsSetId(), other.featuredResultsSetId())
                && Objects.equals(featuredResultsSetName(), other.featuredResultsSetName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(creationTimestamp(), other.creationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FeaturedResultsSetSummary").add("FeaturedResultsSetId", featuredResultsSetId())
                .add("FeaturedResultsSetName", featuredResultsSetName()).add("Status", statusAsString())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("CreationTimestamp", creationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeaturedResultsSetId":
            return Optional.ofNullable(clazz.cast(featuredResultsSetId()));
        case "FeaturedResultsSetName":
            return Optional.ofNullable(clazz.cast(featuredResultsSetName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FeaturedResultsSetId", FEATURED_RESULTS_SET_ID_FIELD);
        map.put("FeaturedResultsSetName", FEATURED_RESULTS_SET_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeaturedResultsSetSummary, T> g) {
        return obj -> g.apply((FeaturedResultsSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeaturedResultsSetSummary> {
        /**
         * <p>
         * The identifier of the set of featured results.
         * </p>
         * 
         * @param featuredResultsSetId
         *        The identifier of the set of featured results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetId(String featuredResultsSetId);

        /**
         * <p>
         * The name for the set of featured results.
         * </p>
         * 
         * @param featuredResultsSetName
         *        The name for the set of featured results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetName(String featuredResultsSetName);

        /**
         * <p>
         * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results
         * are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>.
         * You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
         * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
         * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
         *        results are ready for use. You can still configure your settings before setting the status to
         *        <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the
         *        <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
         *        UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
         *        featured results set for each index, whether the status is <code>ACTIVE</code> or
         *        <code>INACTIVE</code>.
         * @see FeaturedResultsSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeaturedResultsSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results
         * are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>.
         * You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html"
         * >UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured
         * results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured
         *        results are ready for use. You can still configure your settings before setting the status to
         *        <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the
         *        <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">
         *        UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per
         *        featured results set for each index, whether the status is <code>ACTIVE</code> or
         *        <code>INACTIVE</code>.
         * @see FeaturedResultsSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeaturedResultsSetStatus
         */
        Builder status(FeaturedResultsSetStatus status);

        /**
         * <p>
         * The Unix timestamp when the set of featured results was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The Unix timestamp when the set of featured results was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Long lastUpdatedTimestamp);

        /**
         * <p>
         * The Unix timestamp when the set of featured results was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The Unix timestamp when the set of featured results was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Long creationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String featuredResultsSetId;

        private String featuredResultsSetName;

        private String status;

        private Long lastUpdatedTimestamp;

        private Long creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturedResultsSetSummary model) {
            featuredResultsSetId(model.featuredResultsSetId);
            featuredResultsSetName(model.featuredResultsSetName);
            status(model.status);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            creationTimestamp(model.creationTimestamp);
        }

        public final String getFeaturedResultsSetId() {
            return featuredResultsSetId;
        }

        public final void setFeaturedResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
        }

        @Override
        public final Builder featuredResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
            return this;
        }

        public final String getFeaturedResultsSetName() {
            return featuredResultsSetName;
        }

        public final void setFeaturedResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
        }

        @Override
        public final Builder featuredResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeaturedResultsSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Long lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Long lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Long getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public FeaturedResultsSetSummary build() {
            return new FeaturedResultsSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
