/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQuerySuggestionsRequest extends KendraRequest implements
        ToCopyableBuilder<GetQuerySuggestionsRequest.Builder, GetQuerySuggestionsRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(GetQuerySuggestionsRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryText").getter(getter(GetQuerySuggestionsRequest::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()).build();

    private static final SdkField<Integer> MAX_SUGGESTIONS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSuggestionsCount").getter(getter(GetQuerySuggestionsRequest::maxSuggestionsCount))
            .setter(setter(Builder::maxSuggestionsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSuggestionsCount").build())
            .build();

    private static final SdkField<List<String>> SUGGESTION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SuggestionTypes")
            .getter(getter(GetQuerySuggestionsRequest::suggestionTypesAsStrings))
            .setter(setter(Builder::suggestionTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AttributeSuggestionsGetConfig> ATTRIBUTE_SUGGESTIONS_CONFIG_FIELD = SdkField
            .<AttributeSuggestionsGetConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AttributeSuggestionsConfig")
            .getter(getter(GetQuerySuggestionsRequest::attributeSuggestionsConfig))
            .setter(setter(Builder::attributeSuggestionsConfig))
            .constructor(AttributeSuggestionsGetConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeSuggestionsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            QUERY_TEXT_FIELD, MAX_SUGGESTIONS_COUNT_FIELD, SUGGESTION_TYPES_FIELD, ATTRIBUTE_SUGGESTIONS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexId;

    private final String queryText;

    private final Integer maxSuggestionsCount;

    private final List<String> suggestionTypes;

    private final AttributeSuggestionsGetConfig attributeSuggestionsConfig;

    private GetQuerySuggestionsRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryText = builder.queryText;
        this.maxSuggestionsCount = builder.maxSuggestionsCount;
        this.suggestionTypes = builder.suggestionTypes;
        this.attributeSuggestionsConfig = builder.attributeSuggestionsConfig;
    }

    /**
     * <p>
     * The identifier of the index you want to get query suggestions from.
     * </p>
     * 
     * @return The identifier of the index you want to get query suggestions from.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The text of a user's query to generate query suggestions.
     * </p>
     * <p>
     * A query is suggested if the query prefix matches what a user starts to type as their query.
     * </p>
     * <p>
     * Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters.
     * A query must also have at least one search result and contain at least one word of more than four characters.
     * </p>
     * 
     * @return The text of a user's query to generate query suggestions.</p>
     *         <p>
     *         A query is suggested if the query prefix matches what a user starts to type as their query.
     *         </p>
     *         <p>
     *         Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60
     *         characters. A query must also have at least one search result and contain at least one word of more than
     *         four characters.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * The maximum number of query suggestions you want to show to your users.
     * </p>
     * 
     * @return The maximum number of query suggestions you want to show to your users.
     */
    public final Integer maxSuggestionsCount() {
        return maxSuggestionsCount;
    }

    /**
     * <p>
     * The suggestions type to base query suggestions on. The suggestion types are query history or document
     * fields/attributes. You can set one type or the other.
     * </p>
     * <p>
     * If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users based on
     * popular queries in the query history.
     * </p>
     * <p>
     * If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant to your
     * users based on the contents of document fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestionTypes} method.
     * </p>
     * 
     * @return The suggestions type to base query suggestions on. The suggestion types are query history or document
     *         fields/attributes. You can set one type or the other.</p>
     *         <p>
     *         If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users
     *         based on popular queries in the query history.
     *         </p>
     *         <p>
     *         If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant
     *         to your users based on the contents of document fields.
     */
    public final List<SuggestionType> suggestionTypes() {
        return SuggestionTypesCopier.copyStringToEnum(suggestionTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestionTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestionTypes() {
        return suggestionTypes != null && !(suggestionTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The suggestions type to base query suggestions on. The suggestion types are query history or document
     * fields/attributes. You can set one type or the other.
     * </p>
     * <p>
     * If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users based on
     * popular queries in the query history.
     * </p>
     * <p>
     * If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant to your
     * users based on the contents of document fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestionTypes} method.
     * </p>
     * 
     * @return The suggestions type to base query suggestions on. The suggestion types are query history or document
     *         fields/attributes. You can set one type or the other.</p>
     *         <p>
     *         If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users
     *         based on popular queries in the query history.
     *         </p>
     *         <p>
     *         If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant
     *         to your users based on the contents of document fields.
     */
    public final List<String> suggestionTypesAsStrings() {
        return suggestionTypes;
    }

    /**
     * <p>
     * Configuration information for the document fields/attributes that you want to base query suggestions on.
     * </p>
     * 
     * @return Configuration information for the document fields/attributes that you want to base query suggestions on.
     */
    public final AttributeSuggestionsGetConfig attributeSuggestionsConfig() {
        return attributeSuggestionsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(maxSuggestionsCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestionTypes() ? suggestionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeSuggestionsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuerySuggestionsRequest)) {
            return false;
        }
        GetQuerySuggestionsRequest other = (GetQuerySuggestionsRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(queryText(), other.queryText())
                && Objects.equals(maxSuggestionsCount(), other.maxSuggestionsCount())
                && hasSuggestionTypes() == other.hasSuggestionTypes()
                && Objects.equals(suggestionTypesAsStrings(), other.suggestionTypesAsStrings())
                && Objects.equals(attributeSuggestionsConfig(), other.attributeSuggestionsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQuerySuggestionsRequest").add("IndexId", indexId()).add("QueryText", queryText())
                .add("MaxSuggestionsCount", maxSuggestionsCount())
                .add("SuggestionTypes", hasSuggestionTypes() ? suggestionTypesAsStrings() : null)
                .add("AttributeSuggestionsConfig", attributeSuggestionsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "QueryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "MaxSuggestionsCount":
            return Optional.ofNullable(clazz.cast(maxSuggestionsCount()));
        case "SuggestionTypes":
            return Optional.ofNullable(clazz.cast(suggestionTypesAsStrings()));
        case "AttributeSuggestionsConfig":
            return Optional.ofNullable(clazz.cast(attributeSuggestionsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("QueryText", QUERY_TEXT_FIELD);
        map.put("MaxSuggestionsCount", MAX_SUGGESTIONS_COUNT_FIELD);
        map.put("SuggestionTypes", SUGGESTION_TYPES_FIELD);
        map.put("AttributeSuggestionsConfig", ATTRIBUTE_SUGGESTIONS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQuerySuggestionsRequest, T> g) {
        return obj -> g.apply((GetQuerySuggestionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetQuerySuggestionsRequest> {
        /**
         * <p>
         * The identifier of the index you want to get query suggestions from.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index you want to get query suggestions from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The text of a user's query to generate query suggestions.
         * </p>
         * <p>
         * A query is suggested if the query prefix matches what a user starts to type as their query.
         * </p>
         * <p>
         * Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60
         * characters. A query must also have at least one search result and contain at least one word of more than four
         * characters.
         * </p>
         * 
         * @param queryText
         *        The text of a user's query to generate query suggestions.</p>
         *        <p>
         *        A query is suggested if the query prefix matches what a user starts to type as their query.
         *        </p>
         *        <p>
         *        Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60
         *        characters. A query must also have at least one search result and contain at least one word of more
         *        than four characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * The maximum number of query suggestions you want to show to your users.
         * </p>
         * 
         * @param maxSuggestionsCount
         *        The maximum number of query suggestions you want to show to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSuggestionsCount(Integer maxSuggestionsCount);

        /**
         * <p>
         * The suggestions type to base query suggestions on. The suggestion types are query history or document
         * fields/attributes. You can set one type or the other.
         * </p>
         * <p>
         * If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users
         * based on popular queries in the query history.
         * </p>
         * <p>
         * If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant to
         * your users based on the contents of document fields.
         * </p>
         * 
         * @param suggestionTypes
         *        The suggestions type to base query suggestions on. The suggestion types are query history or document
         *        fields/attributes. You can set one type or the other.</p>
         *        <p>
         *        If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your
         *        users based on popular queries in the query history.
         *        </p>
         *        <p>
         *        If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries
         *        relevant to your users based on the contents of document fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionTypesWithStrings(Collection<String> suggestionTypes);

        /**
         * <p>
         * The suggestions type to base query suggestions on. The suggestion types are query history or document
         * fields/attributes. You can set one type or the other.
         * </p>
         * <p>
         * If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users
         * based on popular queries in the query history.
         * </p>
         * <p>
         * If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant to
         * your users based on the contents of document fields.
         * </p>
         * 
         * @param suggestionTypes
         *        The suggestions type to base query suggestions on. The suggestion types are query history or document
         *        fields/attributes. You can set one type or the other.</p>
         *        <p>
         *        If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your
         *        users based on popular queries in the query history.
         *        </p>
         *        <p>
         *        If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries
         *        relevant to your users based on the contents of document fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionTypesWithStrings(String... suggestionTypes);

        /**
         * <p>
         * The suggestions type to base query suggestions on. The suggestion types are query history or document
         * fields/attributes. You can set one type or the other.
         * </p>
         * <p>
         * If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users
         * based on popular queries in the query history.
         * </p>
         * <p>
         * If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant to
         * your users based on the contents of document fields.
         * </p>
         * 
         * @param suggestionTypes
         *        The suggestions type to base query suggestions on. The suggestion types are query history or document
         *        fields/attributes. You can set one type or the other.</p>
         *        <p>
         *        If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your
         *        users based on popular queries in the query history.
         *        </p>
         *        <p>
         *        If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries
         *        relevant to your users based on the contents of document fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionTypes(Collection<SuggestionType> suggestionTypes);

        /**
         * <p>
         * The suggestions type to base query suggestions on. The suggestion types are query history or document
         * fields/attributes. You can set one type or the other.
         * </p>
         * <p>
         * If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users
         * based on popular queries in the query history.
         * </p>
         * <p>
         * If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant to
         * your users based on the contents of document fields.
         * </p>
         * 
         * @param suggestionTypes
         *        The suggestions type to base query suggestions on. The suggestion types are query history or document
         *        fields/attributes. You can set one type or the other.</p>
         *        <p>
         *        If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your
         *        users based on popular queries in the query history.
         *        </p>
         *        <p>
         *        If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries
         *        relevant to your users based on the contents of document fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionTypes(SuggestionType... suggestionTypes);

        /**
         * <p>
         * Configuration information for the document fields/attributes that you want to base query suggestions on.
         * </p>
         * 
         * @param attributeSuggestionsConfig
         *        Configuration information for the document fields/attributes that you want to base query suggestions
         *        on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeSuggestionsConfig(AttributeSuggestionsGetConfig attributeSuggestionsConfig);

        /**
         * <p>
         * Configuration information for the document fields/attributes that you want to base query suggestions on.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeSuggestionsGetConfig.Builder}
         * avoiding the need to create one manually via {@link AttributeSuggestionsGetConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeSuggestionsGetConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeSuggestionsConfig(AttributeSuggestionsGetConfig)}.
         * 
         * @param attributeSuggestionsConfig
         *        a consumer that will call methods on {@link AttributeSuggestionsGetConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeSuggestionsConfig(AttributeSuggestionsGetConfig)
         */
        default Builder attributeSuggestionsConfig(Consumer<AttributeSuggestionsGetConfig.Builder> attributeSuggestionsConfig) {
            return attributeSuggestionsConfig(AttributeSuggestionsGetConfig.builder().applyMutation(attributeSuggestionsConfig)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String queryText;

        private Integer maxSuggestionsCount;

        private List<String> suggestionTypes = DefaultSdkAutoConstructList.getInstance();

        private AttributeSuggestionsGetConfig attributeSuggestionsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuerySuggestionsRequest model) {
            super(model);
            indexId(model.indexId);
            queryText(model.queryText);
            maxSuggestionsCount(model.maxSuggestionsCount);
            suggestionTypesWithStrings(model.suggestionTypes);
            attributeSuggestionsConfig(model.attributeSuggestionsConfig);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getQueryText() {
            return queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final Integer getMaxSuggestionsCount() {
            return maxSuggestionsCount;
        }

        public final void setMaxSuggestionsCount(Integer maxSuggestionsCount) {
            this.maxSuggestionsCount = maxSuggestionsCount;
        }

        @Override
        public final Builder maxSuggestionsCount(Integer maxSuggestionsCount) {
            this.maxSuggestionsCount = maxSuggestionsCount;
            return this;
        }

        public final Collection<String> getSuggestionTypes() {
            if (suggestionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return suggestionTypes;
        }

        public final void setSuggestionTypes(Collection<String> suggestionTypes) {
            this.suggestionTypes = SuggestionTypesCopier.copy(suggestionTypes);
        }

        @Override
        public final Builder suggestionTypesWithStrings(Collection<String> suggestionTypes) {
            this.suggestionTypes = SuggestionTypesCopier.copy(suggestionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionTypesWithStrings(String... suggestionTypes) {
            suggestionTypesWithStrings(Arrays.asList(suggestionTypes));
            return this;
        }

        @Override
        public final Builder suggestionTypes(Collection<SuggestionType> suggestionTypes) {
            this.suggestionTypes = SuggestionTypesCopier.copyEnumToString(suggestionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionTypes(SuggestionType... suggestionTypes) {
            suggestionTypes(Arrays.asList(suggestionTypes));
            return this;
        }

        public final AttributeSuggestionsGetConfig.Builder getAttributeSuggestionsConfig() {
            return attributeSuggestionsConfig != null ? attributeSuggestionsConfig.toBuilder() : null;
        }

        public final void setAttributeSuggestionsConfig(AttributeSuggestionsGetConfig.BuilderImpl attributeSuggestionsConfig) {
            this.attributeSuggestionsConfig = attributeSuggestionsConfig != null ? attributeSuggestionsConfig.build() : null;
        }

        @Override
        public final Builder attributeSuggestionsConfig(AttributeSuggestionsGetConfig attributeSuggestionsConfig) {
            this.attributeSuggestionsConfig = attributeSuggestionsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQuerySuggestionsRequest build() {
            return new GetQuerySuggestionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
