/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSnapshotsRequest extends KendraRequest implements
        ToCopyableBuilder<GetSnapshotsRequest.Builder, GetSnapshotsRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(GetSnapshotsRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Interval").getter(getter(GetSnapshotsRequest::intervalAsString)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricType").getter(getter(GetSnapshotsRequest::metricTypeAsString)).setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSnapshotsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetSnapshotsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            INTERVAL_FIELD, METRIC_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexId;

    private final String interval;

    private final String metricType;

    private final String nextToken;

    private final Integer maxResults;

    private GetSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.interval = builder.interval;
        this.metricType = builder.metricType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of the index to get search metrics data.
     * </p>
     * 
     * @return The identifier of the index to get search metrics data.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The time interval or time window to get search metrics data. The time interval uses the time zone of your index.
     * You can view data in the following time windows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the following
     * Saturday.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day before
     * the current date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last day
     * of the month.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and
     * ending on last day of the month.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interval} will
     * return {@link Interval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalAsString}.
     * </p>
     * 
     * @return The time interval or time window to get search metrics data. The time interval uses the time zone of your
     *         index. You can view data in the following time windows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current
     *         date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following
     *         Saturday.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the
     *         following Saturday.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day
     *         before the current date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the
     *         last day of the month.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month
     *         and ending on last day of the month.
     *         </p>
     *         </li>
     * @see Interval
     */
    public final Interval interval() {
        return Interval.fromValue(interval);
    }

    /**
     * <p>
     * The time interval or time window to get search metrics data. The time interval uses the time zone of your index.
     * You can view data in the following time windows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the following
     * Saturday.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day before
     * the current date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last day
     * of the month.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and
     * ending on last day of the month.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interval} will
     * return {@link Interval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalAsString}.
     * </p>
     * 
     * @return The time interval or time window to get search metrics data. The time interval uses the time zone of your
     *         index. You can view data in the following time windows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current
     *         date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following
     *         Saturday.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the
     *         following Saturday.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day
     *         before the current date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the
     *         last day of the month.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month
     *         and ending on last day of the month.
     *         </p>
     *         </li>
     * @see Interval
     */
    public final String intervalAsString() {
        return interval;
    }

    /**
     * <p>
     * The metric you want to retrieve. You can specify only one metric per call.
     * </p>
     * <p>
     * For more information about the metrics you can view, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search
     * analytics</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The metric you want to retrieve. You can specify only one metric per call.</p>
     *         <p>
     *         For more information about the metrics you can view, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search
     *         analytics</a>.
     * @see MetricType
     */
    public final MetricType metricType() {
        return MetricType.fromValue(metricType);
    }

    /**
     * <p>
     * The metric you want to retrieve. You can specify only one metric per call.
     * </p>
     * <p>
     * For more information about the metrics you can view, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search
     * analytics</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The metric you want to retrieve. You can specify only one metric per call.</p>
     *         <p>
     *         For more information about the metrics you can view, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search
     *         analytics</a>.
     * @see MetricType
     */
    public final String metricTypeAsString() {
        return metricType;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of search metrics
     * data.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a
     *         pagination token in the response. You can use this pagination token to retrieve the next set of search
     *         metrics data.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of returned data for the metric.
     * </p>
     * 
     * @return The maximum number of returned data for the metric.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(intervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnapshotsRequest)) {
            return false;
        }
        GetSnapshotsRequest other = (GetSnapshotsRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(intervalAsString(), other.intervalAsString())
                && Objects.equals(metricTypeAsString(), other.metricTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSnapshotsRequest").add("IndexId", indexId()).add("Interval", intervalAsString())
                .add("MetricType", metricTypeAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(intervalAsString()));
        case "MetricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("Interval", INTERVAL_FIELD);
        map.put("MetricType", METRIC_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSnapshotsRequest, T> g) {
        return obj -> g.apply((GetSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSnapshotsRequest> {
        /**
         * <p>
         * The identifier of the index to get search metrics data.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index to get search metrics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The time interval or time window to get search metrics data. The time interval uses the time zone of your
         * index. You can view data in the following time windows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current
         * date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the
         * following Saturday.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day
         * before the current date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last
         * day of the month.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and
         * ending on last day of the month.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interval
         *        The time interval or time window to get search metrics data. The time interval uses the time zone of
         *        your index. You can view data in the following time windows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the
         *        current date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following
         *        Saturday.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on
         *        the following Saturday.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the
         *        day before the current date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on
         *        the last day of the month.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the
         *        month and ending on last day of the month.
         *        </p>
         *        </li>
         * @see Interval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Interval
         */
        Builder interval(String interval);

        /**
         * <p>
         * The time interval or time window to get search metrics data. The time interval uses the time zone of your
         * index. You can view data in the following time windows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current
         * date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the
         * following Saturday.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day
         * before the current date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last
         * day of the month.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and
         * ending on last day of the month.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interval
         *        The time interval or time window to get search metrics data. The time interval uses the time zone of
         *        your index. You can view data in the following time windows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the
         *        current date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following
         *        Saturday.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on
         *        the following Saturday.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the
         *        day before the current date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on
         *        the last day of the month.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the
         *        month and ending on last day of the month.
         *        </p>
         *        </li>
         * @see Interval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Interval
         */
        Builder interval(Interval interval);

        /**
         * <p>
         * The metric you want to retrieve. You can specify only one metric per call.
         * </p>
         * <p>
         * For more information about the metrics you can view, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search
         * analytics</a>.
         * </p>
         * 
         * @param metricType
         *        The metric you want to retrieve. You can specify only one metric per call.</p>
         *        <p>
         *        For more information about the metrics you can view, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search
         *        analytics</a>.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * The metric you want to retrieve. You can specify only one metric per call.
         * </p>
         * <p>
         * For more information about the metrics you can view, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search
         * analytics</a>.
         * </p>
         * 
         * @param metricType
         *        The metric you want to retrieve. You can specify only one metric per call.</p>
         *        <p>
         *        For more information about the metrics you can view, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search
         *        analytics</a>.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metricType(MetricType metricType);

        /**
         * <p>
         * If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a
         * pagination token in the response. You can use this pagination token to retrieve the next set of search
         * metrics data.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra
         *        returns a pagination token in the response. You can use this pagination token to retrieve the next set
         *        of search metrics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of returned data for the metric.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of returned data for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String interval;

        private String metricType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnapshotsRequest model) {
            super(model);
            indexId(model.indexId);
            interval(model.interval);
            metricType(model.metricType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getInterval() {
            return interval;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public final Builder interval(Interval interval) {
            this.interval(interval == null ? null : interval.toString());
            return this;
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(MetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSnapshotsRequest build() {
            return new GetSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
