/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to include certain types of GitHub content. You can configure to index
 * repository files only, or also include issues and pull requests, comments, and comment attachments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitHubDocumentCrawlProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<GitHubDocumentCrawlProperties.Builder, GitHubDocumentCrawlProperties> {
    private static final SdkField<Boolean> CRAWL_REPOSITORY_DOCUMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlRepositoryDocuments").getter(getter(GitHubDocumentCrawlProperties::crawlRepositoryDocuments))
            .setter(setter(Builder::crawlRepositoryDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlRepositoryDocuments").build())
            .build();

    private static final SdkField<Boolean> CRAWL_ISSUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlIssue").getter(getter(GitHubDocumentCrawlProperties::crawlIssue))
            .setter(setter(Builder::crawlIssue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlIssue").build()).build();

    private static final SdkField<Boolean> CRAWL_ISSUE_COMMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlIssueComment").getter(getter(GitHubDocumentCrawlProperties::crawlIssueComment))
            .setter(setter(Builder::crawlIssueComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlIssueComment").build()).build();

    private static final SdkField<Boolean> CRAWL_ISSUE_COMMENT_ATTACHMENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlIssueCommentAttachment")
            .getter(getter(GitHubDocumentCrawlProperties::crawlIssueCommentAttachment))
            .setter(setter(Builder::crawlIssueCommentAttachment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlIssueCommentAttachment")
                    .build()).build();

    private static final SdkField<Boolean> CRAWL_PULL_REQUEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlPullRequest").getter(getter(GitHubDocumentCrawlProperties::crawlPullRequest))
            .setter(setter(Builder::crawlPullRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlPullRequest").build()).build();

    private static final SdkField<Boolean> CRAWL_PULL_REQUEST_COMMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlPullRequestComment").getter(getter(GitHubDocumentCrawlProperties::crawlPullRequestComment))
            .setter(setter(Builder::crawlPullRequestComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlPullRequestComment").build())
            .build();

    private static final SdkField<Boolean> CRAWL_PULL_REQUEST_COMMENT_ATTACHMENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlPullRequestCommentAttachment")
            .getter(getter(GitHubDocumentCrawlProperties::crawlPullRequestCommentAttachment))
            .setter(setter(Builder::crawlPullRequestCommentAttachment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlPullRequestCommentAttachment")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CRAWL_REPOSITORY_DOCUMENTS_FIELD, CRAWL_ISSUE_FIELD, CRAWL_ISSUE_COMMENT_FIELD, CRAWL_ISSUE_COMMENT_ATTACHMENT_FIELD,
            CRAWL_PULL_REQUEST_FIELD, CRAWL_PULL_REQUEST_COMMENT_FIELD, CRAWL_PULL_REQUEST_COMMENT_ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean crawlRepositoryDocuments;

    private final Boolean crawlIssue;

    private final Boolean crawlIssueComment;

    private final Boolean crawlIssueCommentAttachment;

    private final Boolean crawlPullRequest;

    private final Boolean crawlPullRequestComment;

    private final Boolean crawlPullRequestCommentAttachment;

    private GitHubDocumentCrawlProperties(BuilderImpl builder) {
        this.crawlRepositoryDocuments = builder.crawlRepositoryDocuments;
        this.crawlIssue = builder.crawlIssue;
        this.crawlIssueComment = builder.crawlIssueComment;
        this.crawlIssueCommentAttachment = builder.crawlIssueCommentAttachment;
        this.crawlPullRequest = builder.crawlPullRequest;
        this.crawlPullRequestComment = builder.crawlPullRequestComment;
        this.crawlPullRequestCommentAttachment = builder.crawlPullRequestCommentAttachment;
    }

    /**
     * <p>
     * <code>TRUE</code> to index all files with a repository.
     * </p>
     * 
     * @return <code>TRUE</code> to index all files with a repository.
     */
    public final Boolean crawlRepositoryDocuments() {
        return crawlRepositoryDocuments;
    }

    /**
     * <p>
     * <code>TRUE</code> to index all issues within a repository.
     * </p>
     * 
     * @return <code>TRUE</code> to index all issues within a repository.
     */
    public final Boolean crawlIssue() {
        return crawlIssue;
    }

    /**
     * <p>
     * <code>TRUE</code> to index all comments on issues.
     * </p>
     * 
     * @return <code>TRUE</code> to index all comments on issues.
     */
    public final Boolean crawlIssueComment() {
        return crawlIssueComment;
    }

    /**
     * <p>
     * <code>TRUE</code> to include all comment attachments for issues.
     * </p>
     * 
     * @return <code>TRUE</code> to include all comment attachments for issues.
     */
    public final Boolean crawlIssueCommentAttachment() {
        return crawlIssueCommentAttachment;
    }

    /**
     * <p>
     * <code>TRUE</code> to index all pull requests within a repository.
     * </p>
     * 
     * @return <code>TRUE</code> to index all pull requests within a repository.
     */
    public final Boolean crawlPullRequest() {
        return crawlPullRequest;
    }

    /**
     * <p>
     * <code>TRUE</code> to index all comments on pull requests.
     * </p>
     * 
     * @return <code>TRUE</code> to index all comments on pull requests.
     */
    public final Boolean crawlPullRequestComment() {
        return crawlPullRequestComment;
    }

    /**
     * <p>
     * <code>TRUE</code> to include all comment attachments for pull requests.
     * </p>
     * 
     * @return <code>TRUE</code> to include all comment attachments for pull requests.
     */
    public final Boolean crawlPullRequestCommentAttachment() {
        return crawlPullRequestCommentAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlRepositoryDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(crawlIssue());
        hashCode = 31 * hashCode + Objects.hashCode(crawlIssueComment());
        hashCode = 31 * hashCode + Objects.hashCode(crawlIssueCommentAttachment());
        hashCode = 31 * hashCode + Objects.hashCode(crawlPullRequest());
        hashCode = 31 * hashCode + Objects.hashCode(crawlPullRequestComment());
        hashCode = 31 * hashCode + Objects.hashCode(crawlPullRequestCommentAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubDocumentCrawlProperties)) {
            return false;
        }
        GitHubDocumentCrawlProperties other = (GitHubDocumentCrawlProperties) obj;
        return Objects.equals(crawlRepositoryDocuments(), other.crawlRepositoryDocuments())
                && Objects.equals(crawlIssue(), other.crawlIssue())
                && Objects.equals(crawlIssueComment(), other.crawlIssueComment())
                && Objects.equals(crawlIssueCommentAttachment(), other.crawlIssueCommentAttachment())
                && Objects.equals(crawlPullRequest(), other.crawlPullRequest())
                && Objects.equals(crawlPullRequestComment(), other.crawlPullRequestComment())
                && Objects.equals(crawlPullRequestCommentAttachment(), other.crawlPullRequestCommentAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GitHubDocumentCrawlProperties").add("CrawlRepositoryDocuments", crawlRepositoryDocuments())
                .add("CrawlIssue", crawlIssue()).add("CrawlIssueComment", crawlIssueComment())
                .add("CrawlIssueCommentAttachment", crawlIssueCommentAttachment()).add("CrawlPullRequest", crawlPullRequest())
                .add("CrawlPullRequestComment", crawlPullRequestComment())
                .add("CrawlPullRequestCommentAttachment", crawlPullRequestCommentAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlRepositoryDocuments":
            return Optional.ofNullable(clazz.cast(crawlRepositoryDocuments()));
        case "CrawlIssue":
            return Optional.ofNullable(clazz.cast(crawlIssue()));
        case "CrawlIssueComment":
            return Optional.ofNullable(clazz.cast(crawlIssueComment()));
        case "CrawlIssueCommentAttachment":
            return Optional.ofNullable(clazz.cast(crawlIssueCommentAttachment()));
        case "CrawlPullRequest":
            return Optional.ofNullable(clazz.cast(crawlPullRequest()));
        case "CrawlPullRequestComment":
            return Optional.ofNullable(clazz.cast(crawlPullRequestComment()));
        case "CrawlPullRequestCommentAttachment":
            return Optional.ofNullable(clazz.cast(crawlPullRequestCommentAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CrawlRepositoryDocuments", CRAWL_REPOSITORY_DOCUMENTS_FIELD);
        map.put("CrawlIssue", CRAWL_ISSUE_FIELD);
        map.put("CrawlIssueComment", CRAWL_ISSUE_COMMENT_FIELD);
        map.put("CrawlIssueCommentAttachment", CRAWL_ISSUE_COMMENT_ATTACHMENT_FIELD);
        map.put("CrawlPullRequest", CRAWL_PULL_REQUEST_FIELD);
        map.put("CrawlPullRequestComment", CRAWL_PULL_REQUEST_COMMENT_FIELD);
        map.put("CrawlPullRequestCommentAttachment", CRAWL_PULL_REQUEST_COMMENT_ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GitHubDocumentCrawlProperties, T> g) {
        return obj -> g.apply((GitHubDocumentCrawlProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitHubDocumentCrawlProperties> {
        /**
         * <p>
         * <code>TRUE</code> to index all files with a repository.
         * </p>
         * 
         * @param crawlRepositoryDocuments
         *        <code>TRUE</code> to index all files with a repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlRepositoryDocuments(Boolean crawlRepositoryDocuments);

        /**
         * <p>
         * <code>TRUE</code> to index all issues within a repository.
         * </p>
         * 
         * @param crawlIssue
         *        <code>TRUE</code> to index all issues within a repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlIssue(Boolean crawlIssue);

        /**
         * <p>
         * <code>TRUE</code> to index all comments on issues.
         * </p>
         * 
         * @param crawlIssueComment
         *        <code>TRUE</code> to index all comments on issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlIssueComment(Boolean crawlIssueComment);

        /**
         * <p>
         * <code>TRUE</code> to include all comment attachments for issues.
         * </p>
         * 
         * @param crawlIssueCommentAttachment
         *        <code>TRUE</code> to include all comment attachments for issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlIssueCommentAttachment(Boolean crawlIssueCommentAttachment);

        /**
         * <p>
         * <code>TRUE</code> to index all pull requests within a repository.
         * </p>
         * 
         * @param crawlPullRequest
         *        <code>TRUE</code> to index all pull requests within a repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlPullRequest(Boolean crawlPullRequest);

        /**
         * <p>
         * <code>TRUE</code> to index all comments on pull requests.
         * </p>
         * 
         * @param crawlPullRequestComment
         *        <code>TRUE</code> to index all comments on pull requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlPullRequestComment(Boolean crawlPullRequestComment);

        /**
         * <p>
         * <code>TRUE</code> to include all comment attachments for pull requests.
         * </p>
         * 
         * @param crawlPullRequestCommentAttachment
         *        <code>TRUE</code> to include all comment attachments for pull requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlPullRequestCommentAttachment(Boolean crawlPullRequestCommentAttachment);
    }

    static final class BuilderImpl implements Builder {
        private Boolean crawlRepositoryDocuments;

        private Boolean crawlIssue;

        private Boolean crawlIssueComment;

        private Boolean crawlIssueCommentAttachment;

        private Boolean crawlPullRequest;

        private Boolean crawlPullRequestComment;

        private Boolean crawlPullRequestCommentAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubDocumentCrawlProperties model) {
            crawlRepositoryDocuments(model.crawlRepositoryDocuments);
            crawlIssue(model.crawlIssue);
            crawlIssueComment(model.crawlIssueComment);
            crawlIssueCommentAttachment(model.crawlIssueCommentAttachment);
            crawlPullRequest(model.crawlPullRequest);
            crawlPullRequestComment(model.crawlPullRequestComment);
            crawlPullRequestCommentAttachment(model.crawlPullRequestCommentAttachment);
        }

        public final Boolean getCrawlRepositoryDocuments() {
            return crawlRepositoryDocuments;
        }

        public final void setCrawlRepositoryDocuments(Boolean crawlRepositoryDocuments) {
            this.crawlRepositoryDocuments = crawlRepositoryDocuments;
        }

        @Override
        public final Builder crawlRepositoryDocuments(Boolean crawlRepositoryDocuments) {
            this.crawlRepositoryDocuments = crawlRepositoryDocuments;
            return this;
        }

        public final Boolean getCrawlIssue() {
            return crawlIssue;
        }

        public final void setCrawlIssue(Boolean crawlIssue) {
            this.crawlIssue = crawlIssue;
        }

        @Override
        public final Builder crawlIssue(Boolean crawlIssue) {
            this.crawlIssue = crawlIssue;
            return this;
        }

        public final Boolean getCrawlIssueComment() {
            return crawlIssueComment;
        }

        public final void setCrawlIssueComment(Boolean crawlIssueComment) {
            this.crawlIssueComment = crawlIssueComment;
        }

        @Override
        public final Builder crawlIssueComment(Boolean crawlIssueComment) {
            this.crawlIssueComment = crawlIssueComment;
            return this;
        }

        public final Boolean getCrawlIssueCommentAttachment() {
            return crawlIssueCommentAttachment;
        }

        public final void setCrawlIssueCommentAttachment(Boolean crawlIssueCommentAttachment) {
            this.crawlIssueCommentAttachment = crawlIssueCommentAttachment;
        }

        @Override
        public final Builder crawlIssueCommentAttachment(Boolean crawlIssueCommentAttachment) {
            this.crawlIssueCommentAttachment = crawlIssueCommentAttachment;
            return this;
        }

        public final Boolean getCrawlPullRequest() {
            return crawlPullRequest;
        }

        public final void setCrawlPullRequest(Boolean crawlPullRequest) {
            this.crawlPullRequest = crawlPullRequest;
        }

        @Override
        public final Builder crawlPullRequest(Boolean crawlPullRequest) {
            this.crawlPullRequest = crawlPullRequest;
            return this;
        }

        public final Boolean getCrawlPullRequestComment() {
            return crawlPullRequestComment;
        }

        public final void setCrawlPullRequestComment(Boolean crawlPullRequestComment) {
            this.crawlPullRequestComment = crawlPullRequestComment;
        }

        @Override
        public final Builder crawlPullRequestComment(Boolean crawlPullRequestComment) {
            this.crawlPullRequestComment = crawlPullRequestComment;
            return this;
        }

        public final Boolean getCrawlPullRequestCommentAttachment() {
            return crawlPullRequestCommentAttachment;
        }

        public final void setCrawlPullRequestCommentAttachment(Boolean crawlPullRequestCommentAttachment) {
            this.crawlPullRequestCommentAttachment = crawlPullRequestCommentAttachment;
        }

        @Override
        public final Builder crawlPullRequestCommentAttachment(Boolean crawlPullRequestCommentAttachment) {
            this.crawlPullRequestCommentAttachment = crawlPullRequestCommentAttachment;
            return this;
        }

        @Override
        public GitHubDocumentCrawlProperties build() {
            return new GitHubDocumentCrawlProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
