/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to Google Drive as your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GoogleDriveConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GoogleDriveConfiguration.Builder, GoogleDriveConfiguration> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(GoogleDriveConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionPatterns")
            .getter(getter(GoogleDriveConfiguration::inclusionPatterns))
            .setter(setter(Builder::inclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionPatterns")
            .getter(getter(GoogleDriveConfiguration::exclusionPatterns))
            .setter(setter(Builder::exclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FieldMappings")
            .getter(getter(GoogleDriveConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_MIME_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeMimeTypes")
            .getter(getter(GoogleDriveConfiguration::excludeMimeTypes))
            .setter(setter(Builder::excludeMimeTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeMimeTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_USER_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeUserAccounts")
            .getter(getter(GoogleDriveConfiguration::excludeUserAccounts))
            .setter(setter(Builder::excludeUserAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeUserAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_SHARED_DRIVES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeSharedDrives")
            .getter(getter(GoogleDriveConfiguration::excludeSharedDrives))
            .setter(setter(Builder::excludeSharedDrives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeSharedDrives").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, FIELD_MAPPINGS_FIELD, EXCLUDE_MIME_TYPES_FIELD,
            EXCLUDE_USER_ACCOUNTS_FIELD, EXCLUDE_SHARED_DRIVES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final List<String> inclusionPatterns;

    private final List<String> exclusionPatterns;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private final List<String> excludeMimeTypes;

    private final List<String> excludeUserAccounts;

    private final List<String> excludeSharedDrives;

    private GoogleDriveConfiguration(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.fieldMappings = builder.fieldMappings;
        this.excludeMimeTypes = builder.excludeMimeTypes;
        this.excludeUserAccounts = builder.excludeUserAccounts;
        this.excludeSharedDrives = builder.excludeSharedDrives;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the credentials required to connect to
     * Google Drive. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive
     * data source</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the credentials required to
     *         connect to Google Drive. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google
     *         Workspace Drive data source</a>.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionPatterns() {
        return inclusionPatterns != null && !(inclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain items in your Google Drive, including shared drives and
     * users' My Drives. Items that match the patterns are included in the index. Items that don't match the patterns
     * are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern
     * takes precedence and the item isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain items in your Google Drive, including shared
     *         drives and users' My Drives. Items that match the patterns are included in the index. Items that don't
     *         match the patterns are excluded from the index. If an item matches both an inclusion and exclusion
     *         pattern, the exclusion pattern takes precedence and the item isn't included in the index.
     */
    public final List<String> inclusionPatterns() {
        return inclusionPatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionPatterns() {
        return exclusionPatterns != null && !(exclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain items in your Google Drive, including shared drives and
     * users' My Drives. Items that match the patterns are excluded from the index. Items that don't match the patterns
     * are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern
     * takes precedence and the item isn't included in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain items in your Google Drive, including shared
     *         drives and users' My Drives. Items that match the patterns are excluded from the index. Items that don't
     *         match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern,
     *         the exclusion pattern takes precedence and the item isn't included in the index.
     */
    public final List<String> exclusionPatterns() {
        return exclusionPatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create custom
     * fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Google
     * Drive data source field names must exist in your Google Drive custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldMappings} method.
     * </p>
     * 
     * @return Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create
     *         custom fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more
     *         information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data
     *         source fields</a>. The Google Drive data source field names must exist in your Google Drive custom
     *         metadata.
     */
    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeMimeTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeMimeTypes() {
        return excludeMimeTypes != null && !(excludeMimeTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded.
     * </p>
     * <p>
     * For a list of MIME types, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive
     * data source</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeMimeTypes} method.
     * </p>
     * 
     * @return A list of MIME types to exclude from the index. All documents matching the specified MIME type are
     *         excluded. </p>
     *         <p>
     *         For a list of MIME types, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google
     *         Workspace Drive data source</a>.
     */
    public final List<String> excludeMimeTypes() {
        return excludeMimeTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeUserAccounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeUserAccounts() {
        return excludeUserAccounts != null && !(excludeUserAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of email addresses of the users. Documents owned by these users are excluded from the index. Documents
     * shared with excluded users are indexed unless they are excluded in another way.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeUserAccounts} method.
     * </p>
     * 
     * @return A list of email addresses of the users. Documents owned by these users are excluded from the index.
     *         Documents shared with excluded users are indexed unless they are excluded in another way.
     */
    public final List<String> excludeUserAccounts() {
        return excludeUserAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeSharedDrives property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeSharedDrives() {
        return excludeSharedDrives != null && !(excludeSharedDrives instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identifiers or shared drives to exclude from the index. All files and folders stored on the shared
     * drive are excluded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeSharedDrives} method.
     * </p>
     * 
     * @return A list of identifiers or shared drives to exclude from the index. All files and folders stored on the
     *         shared drive are excluded.
     */
    public final List<String> excludeSharedDrives() {
        return excludeSharedDrives;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionPatterns() ? inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionPatterns() ? exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMappings() ? fieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeMimeTypes() ? excludeMimeTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeUserAccounts() ? excludeUserAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeSharedDrives() ? excludeSharedDrives() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GoogleDriveConfiguration)) {
            return false;
        }
        GoogleDriveConfiguration other = (GoogleDriveConfiguration) obj;
        return Objects.equals(secretArn(), other.secretArn()) && hasInclusionPatterns() == other.hasInclusionPatterns()
                && Objects.equals(inclusionPatterns(), other.inclusionPatterns())
                && hasExclusionPatterns() == other.hasExclusionPatterns()
                && Objects.equals(exclusionPatterns(), other.exclusionPatterns())
                && hasFieldMappings() == other.hasFieldMappings() && Objects.equals(fieldMappings(), other.fieldMappings())
                && hasExcludeMimeTypes() == other.hasExcludeMimeTypes()
                && Objects.equals(excludeMimeTypes(), other.excludeMimeTypes())
                && hasExcludeUserAccounts() == other.hasExcludeUserAccounts()
                && Objects.equals(excludeUserAccounts(), other.excludeUserAccounts())
                && hasExcludeSharedDrives() == other.hasExcludeSharedDrives()
                && Objects.equals(excludeSharedDrives(), other.excludeSharedDrives());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GoogleDriveConfiguration").add("SecretArn", secretArn())
                .add("InclusionPatterns", hasInclusionPatterns() ? inclusionPatterns() : null)
                .add("ExclusionPatterns", hasExclusionPatterns() ? exclusionPatterns() : null)
                .add("FieldMappings", hasFieldMappings() ? fieldMappings() : null)
                .add("ExcludeMimeTypes", hasExcludeMimeTypes() ? excludeMimeTypes() : null)
                .add("ExcludeUserAccounts", hasExcludeUserAccounts() ? excludeUserAccounts() : null)
                .add("ExcludeSharedDrives", hasExcludeSharedDrives() ? excludeSharedDrives() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "InclusionPatterns":
            return Optional.ofNullable(clazz.cast(inclusionPatterns()));
        case "ExclusionPatterns":
            return Optional.ofNullable(clazz.cast(exclusionPatterns()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        case "ExcludeMimeTypes":
            return Optional.ofNullable(clazz.cast(excludeMimeTypes()));
        case "ExcludeUserAccounts":
            return Optional.ofNullable(clazz.cast(excludeUserAccounts()));
        case "ExcludeSharedDrives":
            return Optional.ofNullable(clazz.cast(excludeSharedDrives()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("InclusionPatterns", INCLUSION_PATTERNS_FIELD);
        map.put("ExclusionPatterns", EXCLUSION_PATTERNS_FIELD);
        map.put("FieldMappings", FIELD_MAPPINGS_FIELD);
        map.put("ExcludeMimeTypes", EXCLUDE_MIME_TYPES_FIELD);
        map.put("ExcludeUserAccounts", EXCLUDE_USER_ACCOUNTS_FIELD);
        map.put("ExcludeSharedDrives", EXCLUDE_SHARED_DRIVES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GoogleDriveConfiguration, T> g) {
        return obj -> g.apply((GoogleDriveConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GoogleDriveConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the credentials required to connect
         * to Google Drive. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace
         * Drive data source</a>.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the credentials required to
         *        connect to Google Drive. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google
         *        Workspace Drive data source</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * A list of regular expression patterns to include certain items in your Google Drive, including shared drives
         * and users' My Drives. Items that match the patterns are included in the index. Items that don't match the
         * patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the item isn't included in the index.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain items in your Google Drive, including shared
         *        drives and users' My Drives. Items that match the patterns are included in the index. Items that don't
         *        match the patterns are excluded from the index. If an item matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(Collection<String> inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain items in your Google Drive, including shared drives
         * and users' My Drives. Items that match the patterns are included in the index. Items that don't match the
         * patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the
         * exclusion pattern takes precedence and the item isn't included in the index.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain items in your Google Drive, including shared
         *        drives and users' My Drives. Items that match the patterns are included in the index. Items that don't
         *        match the patterns are excluded from the index. If an item matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(String... inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain items in your Google Drive, including shared drives
         * and users' My Drives. Items that match the patterns are excluded from the index. Items that don't match the
         * patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion
         * pattern takes precedence and the item isn't included in the index.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain items in your Google Drive, including shared
         *        drives and users' My Drives. Items that match the patterns are excluded from the index. Items that
         *        don't match the patterns are included in the index. If an item matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(Collection<String> exclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain items in your Google Drive, including shared drives
         * and users' My Drives. Items that match the patterns are excluded from the index. Items that don't match the
         * patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion
         * pattern takes precedence and the item isn't included in the index.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain items in your Google Drive, including shared
         *        drives and users' My Drives. Items that match the patterns are excluded from the index. Items that
         *        don't match the patterns are included in the index. If an item matches both an inclusion and exclusion
         *        pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(String... exclusionPatterns);

        /**
         * <p>
         * Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create custom
         * fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more information, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Google Drive data source field names must exist in your Google Drive custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create
         *        custom fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more
         *        information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
         *        data source fields</a>. The Google Drive data source field names must exist in your Google Drive
         *        custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create custom
         * fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more information, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Google Drive data source field names must exist in your Google Drive custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create
         *        custom fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more
         *        information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
         *        data source fields</a>. The Google Drive data source field names must exist in your Google Drive
         *        custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create custom
         * fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more information, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * Google Drive data source field names must exist in your Google Drive custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);

        /**
         * <p>
         * A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded.
         * </p>
         * <p>
         * For a list of MIME types, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace
         * Drive data source</a>.
         * </p>
         * 
         * @param excludeMimeTypes
         *        A list of MIME types to exclude from the index. All documents matching the specified MIME type are
         *        excluded. </p>
         *        <p>
         *        For a list of MIME types, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google
         *        Workspace Drive data source</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeMimeTypes(Collection<String> excludeMimeTypes);

        /**
         * <p>
         * A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded.
         * </p>
         * <p>
         * For a list of MIME types, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace
         * Drive data source</a>.
         * </p>
         * 
         * @param excludeMimeTypes
         *        A list of MIME types to exclude from the index. All documents matching the specified MIME type are
         *        excluded. </p>
         *        <p>
         *        For a list of MIME types, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google
         *        Workspace Drive data source</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeMimeTypes(String... excludeMimeTypes);

        /**
         * <p>
         * A list of email addresses of the users. Documents owned by these users are excluded from the index. Documents
         * shared with excluded users are indexed unless they are excluded in another way.
         * </p>
         * 
         * @param excludeUserAccounts
         *        A list of email addresses of the users. Documents owned by these users are excluded from the index.
         *        Documents shared with excluded users are indexed unless they are excluded in another way.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeUserAccounts(Collection<String> excludeUserAccounts);

        /**
         * <p>
         * A list of email addresses of the users. Documents owned by these users are excluded from the index. Documents
         * shared with excluded users are indexed unless they are excluded in another way.
         * </p>
         * 
         * @param excludeUserAccounts
         *        A list of email addresses of the users. Documents owned by these users are excluded from the index.
         *        Documents shared with excluded users are indexed unless they are excluded in another way.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeUserAccounts(String... excludeUserAccounts);

        /**
         * <p>
         * A list of identifiers or shared drives to exclude from the index. All files and folders stored on the shared
         * drive are excluded.
         * </p>
         * 
         * @param excludeSharedDrives
         *        A list of identifiers or shared drives to exclude from the index. All files and folders stored on the
         *        shared drive are excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeSharedDrives(Collection<String> excludeSharedDrives);

        /**
         * <p>
         * A list of identifiers or shared drives to exclude from the index. All files and folders stored on the shared
         * drive are excluded.
         * </p>
         * 
         * @param excludeSharedDrives
         *        A list of identifiers or shared drives to exclude from the index. All files and folders stored on the
         *        shared drive are excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeSharedDrives(String... excludeSharedDrives);
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeMimeTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeUserAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeSharedDrives = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GoogleDriveConfiguration model) {
            secretArn(model.secretArn);
            inclusionPatterns(model.inclusionPatterns);
            exclusionPatterns(model.exclusionPatterns);
            fieldMappings(model.fieldMappings);
            excludeMimeTypes(model.excludeMimeTypes);
            excludeUserAccounts(model.excludeUserAccounts);
            excludeSharedDrives(model.excludeSharedDrives);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String... inclusionPatterns) {
            inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String... exclusionPatterns) {
            exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getExcludeMimeTypes() {
            if (excludeMimeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeMimeTypes;
        }

        public final void setExcludeMimeTypes(Collection<String> excludeMimeTypes) {
            this.excludeMimeTypes = ExcludeMimeTypesListCopier.copy(excludeMimeTypes);
        }

        @Override
        public final Builder excludeMimeTypes(Collection<String> excludeMimeTypes) {
            this.excludeMimeTypes = ExcludeMimeTypesListCopier.copy(excludeMimeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeMimeTypes(String... excludeMimeTypes) {
            excludeMimeTypes(Arrays.asList(excludeMimeTypes));
            return this;
        }

        public final Collection<String> getExcludeUserAccounts() {
            if (excludeUserAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeUserAccounts;
        }

        public final void setExcludeUserAccounts(Collection<String> excludeUserAccounts) {
            this.excludeUserAccounts = ExcludeUserAccountsListCopier.copy(excludeUserAccounts);
        }

        @Override
        public final Builder excludeUserAccounts(Collection<String> excludeUserAccounts) {
            this.excludeUserAccounts = ExcludeUserAccountsListCopier.copy(excludeUserAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeUserAccounts(String... excludeUserAccounts) {
            excludeUserAccounts(Arrays.asList(excludeUserAccounts));
            return this;
        }

        public final Collection<String> getExcludeSharedDrives() {
            if (excludeSharedDrives instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeSharedDrives;
        }

        public final void setExcludeSharedDrives(Collection<String> excludeSharedDrives) {
            this.excludeSharedDrives = ExcludeSharedDrivesListCopier.copy(excludeSharedDrives);
        }

        @Override
        public final Builder excludeSharedDrives(Collection<String> excludeSharedDrives) {
            this.excludeSharedDrives = ExcludeSharedDrivesListCopier.copy(excludeSharedDrives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeSharedDrives(String... excludeSharedDrives) {
            excludeSharedDrives(Arrays.asList(excludeSharedDrives));
            return this;
        }

        @Override
        public GoogleDriveConfiguration build() {
            return new GoogleDriveConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
