/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupSummary implements SdkPojo, Serializable, ToCopyableBuilder<GroupSummary.Builder, GroupSummary> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(GroupSummary::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<Long> ORDERING_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OrderingId").getter(getter(GroupSummary::orderingId)).setter(setter(Builder::orderingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            ORDERING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final Long orderingId;

    private GroupSummary(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.orderingId = builder.orderingId;
    }

    /**
     * <p>
     * The identifier of the group you want group summary information on.
     * </p>
     * 
     * @return The identifier of the group you want group summary information on.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action.
     * </p>
     * 
     * @return The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action.
     */
    public final Long orderingId() {
        return orderingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(orderingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupSummary)) {
            return false;
        }
        GroupSummary other = (GroupSummary) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(orderingId(), other.orderingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupSummary").add("GroupId", groupId()).add("OrderingId", orderingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "OrderingId":
            return Optional.ofNullable(clazz.cast(orderingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("OrderingId", ORDERING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupSummary, T> g) {
        return obj -> g.apply((GroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupSummary> {
        /**
         * <p>
         * The identifier of the group you want group summary information on.
         * </p>
         * 
         * @param groupId
         *        The identifier of the group you want group summary information on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action.
         * </p>
         * 
         * @param orderingId
         *        The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingId(Long orderingId);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private Long orderingId;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupSummary model) {
            groupId(model.groupId);
            orderingId(model.orderingId);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Long getOrderingId() {
            return orderingId;
        }

        public final void setOrderingId(Long orderingId) {
            this.orderingId = orderingId;
        }

        @Override
        public final Builder orderingId(Long orderingId) {
            this.orderingId = orderingId;
            return this;
        }

        @Override
        public GroupSummary build() {
            return new GroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
