/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFaqsResponse extends KendraResponse implements
        ToCopyableBuilder<ListFaqsResponse.Builder, ListFaqsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFaqsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<FaqSummary>> FAQ_SUMMARY_ITEMS_FIELD = SdkField
            .<List<FaqSummary>> builder(MarshallingType.LIST)
            .memberName("FaqSummaryItems")
            .getter(getter(ListFaqsResponse::faqSummaryItems))
            .setter(setter(Builder::faqSummaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaqSummaryItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FaqSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FaqSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            FAQ_SUMMARY_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<FaqSummary> faqSummaryItems;

    private ListFaqsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.faqSummaryItems = builder.faqSummaryItems;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
     * retrieve the next set of FAQs.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request
     *         to retrieve the next set of FAQs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FaqSummaryItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFaqSummaryItems() {
        return faqSummaryItems != null && !(faqSummaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the FAQs for a specified index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFaqSummaryItems} method.
     * </p>
     * 
     * @return Summary information about the FAQs for a specified index.
     */
    public final List<FaqSummary> faqSummaryItems() {
        return faqSummaryItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFaqSummaryItems() ? faqSummaryItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFaqsResponse)) {
            return false;
        }
        ListFaqsResponse other = (ListFaqsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasFaqSummaryItems() == other.hasFaqSummaryItems()
                && Objects.equals(faqSummaryItems(), other.faqSummaryItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFaqsResponse").add("NextToken", nextToken())
                .add("FaqSummaryItems", hasFaqSummaryItems() ? faqSummaryItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FaqSummaryItems":
            return Optional.ofNullable(clazz.cast(faqSummaryItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("FaqSummaryItems", FAQ_SUMMARY_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFaqsResponse, T> g) {
        return obj -> g.apply((ListFaqsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFaqsResponse> {
        /**
         * <p>
         * If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to
         * retrieve the next set of FAQs.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent
         *        request to retrieve the next set of FAQs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Summary information about the FAQs for a specified index.
         * </p>
         * 
         * @param faqSummaryItems
         *        Summary information about the FAQs for a specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faqSummaryItems(Collection<FaqSummary> faqSummaryItems);

        /**
         * <p>
         * Summary information about the FAQs for a specified index.
         * </p>
         * 
         * @param faqSummaryItems
         *        Summary information about the FAQs for a specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faqSummaryItems(FaqSummary... faqSummaryItems);

        /**
         * <p>
         * Summary information about the FAQs for a specified index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.FaqSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.FaqSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.FaqSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #faqSummaryItems(List<FaqSummary>)}.
         * 
         * @param faqSummaryItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.FaqSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faqSummaryItems(java.util.Collection<FaqSummary>)
         */
        Builder faqSummaryItems(Consumer<FaqSummary.Builder>... faqSummaryItems);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FaqSummary> faqSummaryItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFaqsResponse model) {
            super(model);
            nextToken(model.nextToken);
            faqSummaryItems(model.faqSummaryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FaqSummary.Builder> getFaqSummaryItems() {
            List<FaqSummary.Builder> result = FaqSummaryItemsCopier.copyToBuilder(this.faqSummaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaqSummaryItems(Collection<FaqSummary.BuilderImpl> faqSummaryItems) {
            this.faqSummaryItems = FaqSummaryItemsCopier.copyFromBuilder(faqSummaryItems);
        }

        @Override
        public final Builder faqSummaryItems(Collection<FaqSummary> faqSummaryItems) {
            this.faqSummaryItems = FaqSummaryItemsCopier.copy(faqSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faqSummaryItems(FaqSummary... faqSummaryItems) {
            faqSummaryItems(Arrays.asList(faqSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faqSummaryItems(Consumer<FaqSummary.Builder>... faqSummaryItems) {
            faqSummaryItems(Stream.of(faqSummaryItems).map(c -> FaqSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFaqsResponse build() {
            return new ListFaqsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
