/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to GitHub Enterprise Server (on premises).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnPremiseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OnPremiseConfiguration.Builder, OnPremiseConfiguration> {
    private static final SdkField<String> HOST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostUrl").getter(getter(OnPremiseConfiguration::hostUrl)).setter(setter(Builder::hostUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostUrl").build()).build();

    private static final SdkField<String> ORGANIZATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationName").getter(getter(OnPremiseConfiguration::organizationName))
            .setter(setter(Builder::organizationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationName").build()).build();

    private static final SdkField<S3Path> SSL_CERTIFICATE_S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("SslCertificateS3Path").getter(getter(OnPremiseConfiguration::sslCertificateS3Path))
            .setter(setter(Builder::sslCertificateS3Path)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCertificateS3Path").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_URL_FIELD,
            ORGANIZATION_NAME_FIELD, SSL_CERTIFICATE_S3_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hostUrl;

    private final String organizationName;

    private final S3Path sslCertificateS3Path;

    private OnPremiseConfiguration(BuilderImpl builder) {
        this.hostUrl = builder.hostUrl;
        this.organizationName = builder.organizationName;
        this.sslCertificateS3Path = builder.sslCertificateS3Path;
    }

    /**
     * <p>
     * The GitHub host URL or API endpoint URL. For example, <i>https://on-prem-host-url/api/v3/</i>
     * </p>
     * 
     * @return The GitHub host URL or API endpoint URL. For example, <i>https://on-prem-host-url/api/v3/</i>
     */
    public final String hostUrl() {
        return hostUrl;
    }

    /**
     * <p>
     * The name of the organization of the GitHub Enterprise Server (on-premises) account you want to connect to. You
     * can find your organization name by logging into GitHub desktop and selecting <b>Your organizations</b> under your
     * profile picture dropdown.
     * </p>
     * 
     * @return The name of the organization of the GitHub Enterprise Server (on-premises) account you want to connect
     *         to. You can find your organization name by logging into GitHub desktop and selecting <b>Your
     *         organizations</b> under your profile picture dropdown.
     */
    public final String organizationName() {
        return organizationName;
    }

    /**
     * <p>
     * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to GitHub if you require a
     * secure SSL connection.
     * </p>
     * <p>
     * You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using
     * OpenSSL to create an X509 certificate, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an X509
     * certificate</a>.
     * </p>
     * 
     * @return The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to GitHub if you
     *         require a secure SSL connection.</p>
     *         <p>
     *         You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example of
     *         using OpenSSL to create an X509 certificate, see <a
     *         href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign
     *         an X509 certificate</a>.
     */
    public final S3Path sslCertificateS3Path() {
        return sslCertificateS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(organizationName());
        hashCode = 31 * hashCode + Objects.hashCode(sslCertificateS3Path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnPremiseConfiguration)) {
            return false;
        }
        OnPremiseConfiguration other = (OnPremiseConfiguration) obj;
        return Objects.equals(hostUrl(), other.hostUrl()) && Objects.equals(organizationName(), other.organizationName())
                && Objects.equals(sslCertificateS3Path(), other.sslCertificateS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnPremiseConfiguration").add("HostUrl", hostUrl()).add("OrganizationName", organizationName())
                .add("SslCertificateS3Path", sslCertificateS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostUrl":
            return Optional.ofNullable(clazz.cast(hostUrl()));
        case "OrganizationName":
            return Optional.ofNullable(clazz.cast(organizationName()));
        case "SslCertificateS3Path":
            return Optional.ofNullable(clazz.cast(sslCertificateS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HostUrl", HOST_URL_FIELD);
        map.put("OrganizationName", ORGANIZATION_NAME_FIELD);
        map.put("SslCertificateS3Path", SSL_CERTIFICATE_S3_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OnPremiseConfiguration, T> g) {
        return obj -> g.apply((OnPremiseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnPremiseConfiguration> {
        /**
         * <p>
         * The GitHub host URL or API endpoint URL. For example, <i>https://on-prem-host-url/api/v3/</i>
         * </p>
         * 
         * @param hostUrl
         *        The GitHub host URL or API endpoint URL. For example, <i>https://on-prem-host-url/api/v3/</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostUrl(String hostUrl);

        /**
         * <p>
         * The name of the organization of the GitHub Enterprise Server (on-premises) account you want to connect to.
         * You can find your organization name by logging into GitHub desktop and selecting <b>Your organizations</b>
         * under your profile picture dropdown.
         * </p>
         * 
         * @param organizationName
         *        The name of the organization of the GitHub Enterprise Server (on-premises) account you want to connect
         *        to. You can find your organization name by logging into GitHub desktop and selecting <b>Your
         *        organizations</b> under your profile picture dropdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationName(String organizationName);

        /**
         * <p>
         * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to GitHub if you
         * require a secure SSL connection.
         * </p>
         * <p>
         * You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using
         * OpenSSL to create an X509 certificate, see <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an
         * X509 certificate</a>.
         * </p>
         * 
         * @param sslCertificateS3Path
         *        The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to GitHub if
         *        you require a secure SSL connection.</p>
         *        <p>
         *        You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example
         *        of using OpenSSL to create an X509 certificate, see <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and
         *        sign an X509 certificate</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslCertificateS3Path(S3Path sslCertificateS3Path);

        /**
         * <p>
         * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to GitHub if you
         * require a secure SSL connection.
         * </p>
         * <p>
         * You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using
         * OpenSSL to create an X509 certificate, see <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an
         * X509 certificate</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Path.Builder} avoiding the need to
         * create one manually via {@link S3Path#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #sslCertificateS3Path(S3Path)}.
         * 
         * @param sslCertificateS3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sslCertificateS3Path(S3Path)
         */
        default Builder sslCertificateS3Path(Consumer<S3Path.Builder> sslCertificateS3Path) {
            return sslCertificateS3Path(S3Path.builder().applyMutation(sslCertificateS3Path).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String hostUrl;

        private String organizationName;

        private S3Path sslCertificateS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(OnPremiseConfiguration model) {
            hostUrl(model.hostUrl);
            organizationName(model.organizationName);
            sslCertificateS3Path(model.sslCertificateS3Path);
        }

        public final String getHostUrl() {
            return hostUrl;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public final String getOrganizationName() {
            return organizationName;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final S3Path.Builder getSslCertificateS3Path() {
            return sslCertificateS3Path != null ? sslCertificateS3Path.toBuilder() : null;
        }

        public final void setSslCertificateS3Path(S3Path.BuilderImpl sslCertificateS3Path) {
            this.sslCertificateS3Path = sslCertificateS3Path != null ? sslCertificateS3Path.build() : null;
        }

        @Override
        public final Builder sslCertificateS3Path(S3Path sslCertificateS3Path) {
            this.sslCertificateS3Path = sslCertificateS3Path;
            return this;
        }

        @Override
        public OnPremiseConfiguration build() {
            return new OnPremiseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
