/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to OneDrive as your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OneDriveConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OneDriveConfiguration.Builder, OneDriveConfiguration> {
    private static final SdkField<String> TENANT_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDomain").getter(getter(OneDriveConfiguration::tenantDomain)).setter(setter(Builder::tenantDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDomain").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(OneDriveConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<OneDriveUsers> ONE_DRIVE_USERS_FIELD = SdkField
            .<OneDriveUsers> builder(MarshallingType.SDK_POJO).memberName("OneDriveUsers")
            .getter(getter(OneDriveConfiguration::oneDriveUsers)).setter(setter(Builder::oneDriveUsers))
            .constructor(OneDriveUsers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneDriveUsers").build()).build();

    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionPatterns")
            .getter(getter(OneDriveConfiguration::inclusionPatterns))
            .setter(setter(Builder::inclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionPatterns")
            .getter(getter(OneDriveConfiguration::exclusionPatterns))
            .setter(setter(Builder::exclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FieldMappings")
            .getter(getter(OneDriveConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLE_LOCAL_GROUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableLocalGroups").getter(getter(OneDriveConfiguration::disableLocalGroups))
            .setter(setter(Builder::disableLocalGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableLocalGroups").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_DOMAIN_FIELD,
            SECRET_ARN_FIELD, ONE_DRIVE_USERS_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, FIELD_MAPPINGS_FIELD,
            DISABLE_LOCAL_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantDomain;

    private final String secretArn;

    private final OneDriveUsers oneDriveUsers;

    private final List<String> inclusionPatterns;

    private final List<String> exclusionPatterns;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private final Boolean disableLocalGroups;

    private OneDriveConfiguration(BuilderImpl builder) {
        this.tenantDomain = builder.tenantDomain;
        this.secretArn = builder.secretArn;
        this.oneDriveUsers = builder.oneDriveUsers;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.fieldMappings = builder.fieldMappings;
        this.disableLocalGroups = builder.disableLocalGroups;
    }

    /**
     * <p>
     * The Azure Active Directory domain of the organization.
     * </p>
     * 
     * @return The Azure Active Directory domain of the organization.
     */
    public final String tenantDomain() {
        return tenantDomain;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the user name and password to connect to
     * OneDrive. The user name should be the application ID for the OneDrive application, and the password is the
     * application key for the OneDrive application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the user name and password to
     *         connect to OneDrive. The user name should be the application ID for the OneDrive application, and the
     *         password is the application key for the OneDrive application.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * A list of user accounts whose documents should be indexed.
     * </p>
     * 
     * @return A list of user accounts whose documents should be indexed.
     */
    public final OneDriveUsers oneDriveUsers() {
        return oneDriveUsers;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionPatterns() {
        return inclusionPatterns != null && !(inclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain documents in your OneDrive. Documents that match the
     * patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a
     * document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document
     * isn't included in the index.
     * </p>
     * <p>
     * The pattern is applied to the file name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain documents in your OneDrive. Documents that match
     *         the patterns are included in the index. Documents that don't match the patterns are excluded from the
     *         index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes
     *         precedence and the document isn't included in the index.</p>
     *         <p>
     *         The pattern is applied to the file name.
     */
    public final List<String> inclusionPatterns() {
        return inclusionPatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionPatterns() {
        return exclusionPatterns != null && !(exclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that match the
     * patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a
     * document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document
     * isn't included in the index.
     * </p>
     * <p>
     * The pattern is applied to the file name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that match
     *         the patterns are excluded from the index. Documents that don't match the patterns are included in the
     *         index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes
     *         precedence and the document isn't included in the index.</p>
     *         <p>
     *         The pattern is applied to the file name.
     */
    public final List<String> exclusionPatterns() {
        return exclusionPatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map OneDrive data source attributes or field
     * names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before
     * you map to OneDrive fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
     * OneDrive data source field names must exist in your OneDrive custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map OneDrive data source attributes or
     *         field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code>
     *         API before you map to OneDrive fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The OneDrive data source field names must exist in your OneDrive custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    /**
     * <p>
     * <code>TRUE</code> to disable local groups information.
     * </p>
     * 
     * @return <code>TRUE</code> to disable local groups information.
     */
    public final Boolean disableLocalGroups() {
        return disableLocalGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantDomain());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(oneDriveUsers());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionPatterns() ? inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionPatterns() ? exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMappings() ? fieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disableLocalGroups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OneDriveConfiguration)) {
            return false;
        }
        OneDriveConfiguration other = (OneDriveConfiguration) obj;
        return Objects.equals(tenantDomain(), other.tenantDomain()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(oneDriveUsers(), other.oneDriveUsers())
                && hasInclusionPatterns() == other.hasInclusionPatterns()
                && Objects.equals(inclusionPatterns(), other.inclusionPatterns())
                && hasExclusionPatterns() == other.hasExclusionPatterns()
                && Objects.equals(exclusionPatterns(), other.exclusionPatterns())
                && hasFieldMappings() == other.hasFieldMappings() && Objects.equals(fieldMappings(), other.fieldMappings())
                && Objects.equals(disableLocalGroups(), other.disableLocalGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OneDriveConfiguration").add("TenantDomain", tenantDomain()).add("SecretArn", secretArn())
                .add("OneDriveUsers", oneDriveUsers())
                .add("InclusionPatterns", hasInclusionPatterns() ? inclusionPatterns() : null)
                .add("ExclusionPatterns", hasExclusionPatterns() ? exclusionPatterns() : null)
                .add("FieldMappings", hasFieldMappings() ? fieldMappings() : null)
                .add("DisableLocalGroups", disableLocalGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantDomain":
            return Optional.ofNullable(clazz.cast(tenantDomain()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "OneDriveUsers":
            return Optional.ofNullable(clazz.cast(oneDriveUsers()));
        case "InclusionPatterns":
            return Optional.ofNullable(clazz.cast(inclusionPatterns()));
        case "ExclusionPatterns":
            return Optional.ofNullable(clazz.cast(exclusionPatterns()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        case "DisableLocalGroups":
            return Optional.ofNullable(clazz.cast(disableLocalGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantDomain", TENANT_DOMAIN_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("OneDriveUsers", ONE_DRIVE_USERS_FIELD);
        map.put("InclusionPatterns", INCLUSION_PATTERNS_FIELD);
        map.put("ExclusionPatterns", EXCLUSION_PATTERNS_FIELD);
        map.put("FieldMappings", FIELD_MAPPINGS_FIELD);
        map.put("DisableLocalGroups", DISABLE_LOCAL_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OneDriveConfiguration, T> g) {
        return obj -> g.apply((OneDriveConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OneDriveConfiguration> {
        /**
         * <p>
         * The Azure Active Directory domain of the organization.
         * </p>
         * 
         * @param tenantDomain
         *        The Azure Active Directory domain of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDomain(String tenantDomain);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the user name and password to
         * connect to OneDrive. The user name should be the application ID for the OneDrive application, and the
         * password is the application key for the OneDrive application.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the user name and password to
         *        connect to OneDrive. The user name should be the application ID for the OneDrive application, and the
         *        password is the application key for the OneDrive application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * A list of user accounts whose documents should be indexed.
         * </p>
         * 
         * @param oneDriveUsers
         *        A list of user accounts whose documents should be indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oneDriveUsers(OneDriveUsers oneDriveUsers);

        /**
         * <p>
         * A list of user accounts whose documents should be indexed.
         * </p>
         * This is a convenience method that creates an instance of the {@link OneDriveUsers.Builder} avoiding the need
         * to create one manually via {@link OneDriveUsers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OneDriveUsers.Builder#build()} is called immediately and its
         * result is passed to {@link #oneDriveUsers(OneDriveUsers)}.
         * 
         * @param oneDriveUsers
         *        a consumer that will call methods on {@link OneDriveUsers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oneDriveUsers(OneDriveUsers)
         */
        default Builder oneDriveUsers(Consumer<OneDriveUsers.Builder> oneDriveUsers) {
            return oneDriveUsers(OneDriveUsers.builder().applyMutation(oneDriveUsers).build());
        }

        /**
         * <p>
         * A list of regular expression patterns to include certain documents in your OneDrive. Documents that match the
         * patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a
         * document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * </p>
         * <p>
         * The pattern is applied to the file name.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain documents in your OneDrive. Documents that
         *        match the patterns are included in the index. Documents that don't match the patterns are excluded
         *        from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern
         *        takes precedence and the document isn't included in the index.</p>
         *        <p>
         *        The pattern is applied to the file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(Collection<String> inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain documents in your OneDrive. Documents that match the
         * patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a
         * document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * </p>
         * <p>
         * The pattern is applied to the file name.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain documents in your OneDrive. Documents that
         *        match the patterns are included in the index. Documents that don't match the patterns are excluded
         *        from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern
         *        takes precedence and the document isn't included in the index.</p>
         *        <p>
         *        The pattern is applied to the file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(String... inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that match the
         * patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a
         * document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * </p>
         * <p>
         * The pattern is applied to the file name.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that
         *        match the patterns are excluded from the index. Documents that don't match the patterns are included
         *        in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern
         *        takes precedence and the document isn't included in the index.</p>
         *        <p>
         *        The pattern is applied to the file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(Collection<String> exclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that match the
         * patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a
         * document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * </p>
         * <p>
         * The pattern is applied to the file name.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that
         *        match the patterns are excluded from the index. Documents that don't match the patterns are included
         *        in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern
         *        takes precedence and the document isn't included in the index.</p>
         *        <p>
         *        The pattern is applied to the file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(String... exclusionPatterns);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map OneDrive data source attributes or
         * field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to OneDrive fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * OneDrive data source field names must exist in your OneDrive custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map OneDrive data source attributes
         *        or field names to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to OneDrive fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The OneDrive data source field names must exist in your OneDrive custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map OneDrive data source attributes or
         * field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to OneDrive fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * OneDrive data source field names must exist in your OneDrive custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map OneDrive data source attributes
         *        or field names to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to OneDrive fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The OneDrive data source field names must exist in your OneDrive custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map OneDrive data source attributes or
         * field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to OneDrive fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * OneDrive data source field names must exist in your OneDrive custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);

        /**
         * <p>
         * <code>TRUE</code> to disable local groups information.
         * </p>
         * 
         * @param disableLocalGroups
         *        <code>TRUE</code> to disable local groups information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableLocalGroups(Boolean disableLocalGroups);
    }

    static final class BuilderImpl implements Builder {
        private String tenantDomain;

        private String secretArn;

        private OneDriveUsers oneDriveUsers;

        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private Boolean disableLocalGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(OneDriveConfiguration model) {
            tenantDomain(model.tenantDomain);
            secretArn(model.secretArn);
            oneDriveUsers(model.oneDriveUsers);
            inclusionPatterns(model.inclusionPatterns);
            exclusionPatterns(model.exclusionPatterns);
            fieldMappings(model.fieldMappings);
            disableLocalGroups(model.disableLocalGroups);
        }

        public final String getTenantDomain() {
            return tenantDomain;
        }

        public final void setTenantDomain(String tenantDomain) {
            this.tenantDomain = tenantDomain;
        }

        @Override
        public final Builder tenantDomain(String tenantDomain) {
            this.tenantDomain = tenantDomain;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final OneDriveUsers.Builder getOneDriveUsers() {
            return oneDriveUsers != null ? oneDriveUsers.toBuilder() : null;
        }

        public final void setOneDriveUsers(OneDriveUsers.BuilderImpl oneDriveUsers) {
            this.oneDriveUsers = oneDriveUsers != null ? oneDriveUsers.build() : null;
        }

        @Override
        public final Builder oneDriveUsers(OneDriveUsers oneDriveUsers) {
            this.oneDriveUsers = oneDriveUsers;
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String... inclusionPatterns) {
            inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String... exclusionPatterns) {
            exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDisableLocalGroups() {
            return disableLocalGroups;
        }

        public final void setDisableLocalGroups(Boolean disableLocalGroups) {
            this.disableLocalGroups = disableLocalGroups;
        }

        @Override
        public final Builder disableLocalGroups(Boolean disableLocalGroups) {
            this.disableLocalGroups = disableLocalGroups;
            return this;
        }

        @Override
        public OneDriveConfiguration build() {
            return new OneDriveConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
