/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryResponse extends KendraResponse implements ToCopyableBuilder<QueryResponse.Builder, QueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(QueryResponse::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<List<QueryResultItem>> RESULT_ITEMS_FIELD = SdkField
            .<List<QueryResultItem>> builder(MarshallingType.LIST)
            .memberName("ResultItems")
            .getter(getter(QueryResponse::resultItems))
            .setter(setter(Builder::resultItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FacetResult>> FACET_RESULTS_FIELD = SdkField
            .<List<FacetResult>> builder(MarshallingType.LIST)
            .memberName("FacetResults")
            .getter(getter(QueryResponse::facetResults))
            .setter(setter(Builder::facetResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FacetResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(FacetResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_NUMBER_OF_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNumberOfResults").getter(getter(QueryResponse::totalNumberOfResults))
            .setter(setter(Builder::totalNumberOfResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResults").build())
            .build();

    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField
            .<List<Warning>> builder(MarshallingType.LIST)
            .memberName("Warnings")
            .getter(getter(QueryResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Warning> builder(MarshallingType.SDK_POJO)
                                            .constructor(Warning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SpellCorrectedQuery>> SPELL_CORRECTED_QUERIES_FIELD = SdkField
            .<List<SpellCorrectedQuery>> builder(MarshallingType.LIST)
            .memberName("SpellCorrectedQueries")
            .getter(getter(QueryResponse::spellCorrectedQueries))
            .setter(setter(Builder::spellCorrectedQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpellCorrectedQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SpellCorrectedQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpellCorrectedQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FeaturedResultsItem>> FEATURED_RESULTS_ITEMS_FIELD = SdkField
            .<List<FeaturedResultsItem>> builder(MarshallingType.LIST)
            .memberName("FeaturedResultsItems")
            .getter(getter(QueryResponse::featuredResultsItems))
            .setter(setter(Builder::featuredResultsItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeaturedResultsItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeaturedResultsItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            RESULT_ITEMS_FIELD, FACET_RESULTS_FIELD, TOTAL_NUMBER_OF_RESULTS_FIELD, WARNINGS_FIELD,
            SPELL_CORRECTED_QUERIES_FIELD, FEATURED_RESULTS_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queryId;

    private final List<QueryResultItem> resultItems;

    private final List<FacetResult> facetResults;

    private final Integer totalNumberOfResults;

    private final List<Warning> warnings;

    private final List<SpellCorrectedQuery> spellCorrectedQueries;

    private final List<FeaturedResultsItem> featuredResultsItems;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.resultItems = builder.resultItems;
        this.facetResults = builder.facetResults;
        this.totalNumberOfResults = builder.totalNumberOfResults;
        this.warnings = builder.warnings;
        this.spellCorrectedQueries = builder.spellCorrectedQueries;
        this.featuredResultsItems = builder.featuredResultsItems;
    }

    /**
     * <p>
     * The identifier for the search. You also use <code>QueryId</code> to identify the search when using the <a
     * href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_SubmitFeedback.html">SubmitFeedback</a> API.
     * </p>
     * 
     * @return The identifier for the search. You also use <code>QueryId</code> to identify the search when using the <a
     *         href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_SubmitFeedback.html">SubmitFeedback</a>
     *         API.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultItems() {
        return resultItems != null && !(resultItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultItems} method.
     * </p>
     * 
     * @return The results of the search.
     */
    public final List<QueryResultItem> resultItems() {
        return resultItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the FacetResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFacetResults() {
        return facetResults != null && !(facetResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the facet results. A <code>FacetResult</code> contains the counts for each field/attribute key that was
     * specified in the <code>Facets</code> input parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFacetResults} method.
     * </p>
     * 
     * @return Contains the facet results. A <code>FacetResult</code> contains the counts for each field/attribute key
     *         that was specified in the <code>Facets</code> input parameter.
     */
    public final List<FacetResult> facetResults() {
        return facetResults;
    }

    /**
     * <p>
     * The total number of items found by the search. However, you can only retrieve up to 100 items. For example, if
     * the search found 192 items, you can only retrieve the first 100 of the items.
     * </p>
     * 
     * @return The total number of items found by the search. However, you can only retrieve up to 100 items. For
     *         example, if the search found 192 items, you can only retrieve the first 100 of the items.
     */
    public final Integer totalNumberOfResults() {
        return totalNumberOfResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warnings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of warning codes and their messages on problems with your query.
     * </p>
     * <p>
     * Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used in the
     * query. For examples of invalid query syntax, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax">Searching
     * with advanced query syntax</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarnings} method.
     * </p>
     * 
     * @return A list of warning codes and their messages on problems with your query.</p>
     *         <p>
     *         Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used in
     *         the query. For examples of invalid query syntax, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax"
     *         >Searching with advanced query syntax</a>.
     */
    public final List<Warning> warnings() {
        return warnings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SpellCorrectedQueries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSpellCorrectedQueries() {
        return spellCorrectedQueries != null && !(spellCorrectedQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information related to suggested spell corrections for a query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpellCorrectedQueries} method.
     * </p>
     * 
     * @return A list of information related to suggested spell corrections for a query.
     */
    public final List<SpellCorrectedQuery> spellCorrectedQueries() {
        return spellCorrectedQueries;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeaturedResultsItems property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeaturedResultsItems() {
        return featuredResultsItems != null && !(featuredResultsItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of featured result items. Featured results are displayed at the top of the search results page, placed
     * above all other results for certain queries. If there's an exact match of a query, then certain documents are
     * featured in the search results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeaturedResultsItems} method.
     * </p>
     * 
     * @return The list of featured result items. Featured results are displayed at the top of the search results page,
     *         placed above all other results for certain queries. If there's an exact match of a query, then certain
     *         documents are featured in the search results.
     */
    public final List<FeaturedResultsItem> featuredResultsItems() {
        return featuredResultsItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultItems() ? resultItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFacetResults() ? facetResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSpellCorrectedQueries() ? spellCorrectedQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFeaturedResultsItems() ? featuredResultsItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse) obj;
        return Objects.equals(queryId(), other.queryId()) && hasResultItems() == other.hasResultItems()
                && Objects.equals(resultItems(), other.resultItems()) && hasFacetResults() == other.hasFacetResults()
                && Objects.equals(facetResults(), other.facetResults())
                && Objects.equals(totalNumberOfResults(), other.totalNumberOfResults()) && hasWarnings() == other.hasWarnings()
                && Objects.equals(warnings(), other.warnings()) && hasSpellCorrectedQueries() == other.hasSpellCorrectedQueries()
                && Objects.equals(spellCorrectedQueries(), other.spellCorrectedQueries())
                && hasFeaturedResultsItems() == other.hasFeaturedResultsItems()
                && Objects.equals(featuredResultsItems(), other.featuredResultsItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryResponse").add("QueryId", queryId())
                .add("ResultItems", hasResultItems() ? resultItems() : null)
                .add("FacetResults", hasFacetResults() ? facetResults() : null)
                .add("TotalNumberOfResults", totalNumberOfResults()).add("Warnings", hasWarnings() ? warnings() : null)
                .add("SpellCorrectedQueries", hasSpellCorrectedQueries() ? spellCorrectedQueries() : null)
                .add("FeaturedResultsItems", hasFeaturedResultsItems() ? featuredResultsItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "ResultItems":
            return Optional.ofNullable(clazz.cast(resultItems()));
        case "FacetResults":
            return Optional.ofNullable(clazz.cast(facetResults()));
        case "TotalNumberOfResults":
            return Optional.ofNullable(clazz.cast(totalNumberOfResults()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "SpellCorrectedQueries":
            return Optional.ofNullable(clazz.cast(spellCorrectedQueries()));
        case "FeaturedResultsItems":
            return Optional.ofNullable(clazz.cast(featuredResultsItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("ResultItems", RESULT_ITEMS_FIELD);
        map.put("FacetResults", FACET_RESULTS_FIELD);
        map.put("TotalNumberOfResults", TOTAL_NUMBER_OF_RESULTS_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        map.put("SpellCorrectedQueries", SPELL_CORRECTED_QUERIES_FIELD);
        map.put("FeaturedResultsItems", FEATURED_RESULTS_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryResponse, T> g) {
        return obj -> g.apply((QueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, QueryResponse> {
        /**
         * <p>
         * The identifier for the search. You also use <code>QueryId</code> to identify the search when using the <a
         * href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_SubmitFeedback.html">SubmitFeedback</a> API.
         * </p>
         * 
         * @param queryId
         *        The identifier for the search. You also use <code>QueryId</code> to identify the search when using the
         *        <a
         *        href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_SubmitFeedback.html">SubmitFeedback
         *        </a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The results of the search.
         * </p>
         * 
         * @param resultItems
         *        The results of the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(Collection<QueryResultItem> resultItems);

        /**
         * <p>
         * The results of the search.
         * </p>
         * 
         * @param resultItems
         *        The results of the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(QueryResultItem... resultItems);

        /**
         * <p>
         * The results of the search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.QueryResultItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.QueryResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.QueryResultItem.Builder#build()} is called immediately
         * and its result is passed to {@link #resultItems(List<QueryResultItem>)}.
         * 
         * @param resultItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.QueryResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultItems(java.util.Collection<QueryResultItem>)
         */
        Builder resultItems(Consumer<QueryResultItem.Builder>... resultItems);

        /**
         * <p>
         * Contains the facet results. A <code>FacetResult</code> contains the counts for each field/attribute key that
         * was specified in the <code>Facets</code> input parameter.
         * </p>
         * 
         * @param facetResults
         *        Contains the facet results. A <code>FacetResult</code> contains the counts for each field/attribute
         *        key that was specified in the <code>Facets</code> input parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetResults(Collection<FacetResult> facetResults);

        /**
         * <p>
         * Contains the facet results. A <code>FacetResult</code> contains the counts for each field/attribute key that
         * was specified in the <code>Facets</code> input parameter.
         * </p>
         * 
         * @param facetResults
         *        Contains the facet results. A <code>FacetResult</code> contains the counts for each field/attribute
         *        key that was specified in the <code>Facets</code> input parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetResults(FacetResult... facetResults);

        /**
         * <p>
         * Contains the facet results. A <code>FacetResult</code> contains the counts for each field/attribute key that
         * was specified in the <code>Facets</code> input parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.FacetResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.FacetResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.FacetResult.Builder#build()} is called immediately and
         * its result is passed to {@link #facetResults(List<FacetResult>)}.
         * 
         * @param facetResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.FacetResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facetResults(java.util.Collection<FacetResult>)
         */
        Builder facetResults(Consumer<FacetResult.Builder>... facetResults);

        /**
         * <p>
         * The total number of items found by the search. However, you can only retrieve up to 100 items. For example,
         * if the search found 192 items, you can only retrieve the first 100 of the items.
         * </p>
         * 
         * @param totalNumberOfResults
         *        The total number of items found by the search. However, you can only retrieve up to 100 items. For
         *        example, if the search found 192 items, you can only retrieve the first 100 of the items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfResults(Integer totalNumberOfResults);

        /**
         * <p>
         * A list of warning codes and their messages on problems with your query.
         * </p>
         * <p>
         * Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used in the
         * query. For examples of invalid query syntax, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax"
         * >Searching with advanced query syntax</a>.
         * </p>
         * 
         * @param warnings
         *        A list of warning codes and their messages on problems with your query.</p>
         *        <p>
         *        Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used
         *        in the query. For examples of invalid query syntax, see <a href=
         *        "https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax"
         *        >Searching with advanced query syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<Warning> warnings);

        /**
         * <p>
         * A list of warning codes and their messages on problems with your query.
         * </p>
         * <p>
         * Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used in the
         * query. For examples of invalid query syntax, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax"
         * >Searching with advanced query syntax</a>.
         * </p>
         * 
         * @param warnings
         *        A list of warning codes and their messages on problems with your query.</p>
         *        <p>
         *        Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used
         *        in the query. For examples of invalid query syntax, see <a href=
         *        "https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax"
         *        >Searching with advanced query syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Warning... warnings);

        /**
         * <p>
         * A list of warning codes and their messages on problems with your query.
         * </p>
         * <p>
         * Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used in the
         * query. For examples of invalid query syntax, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax"
         * >Searching with advanced query syntax</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.Warning.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.kendra.model.Warning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.Warning.Builder#build()} is called immediately and its
         * result is passed to {@link #warnings(List<Warning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.Warning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(java.util.Collection<Warning>)
         */
        Builder warnings(Consumer<Warning.Builder>... warnings);

        /**
         * <p>
         * A list of information related to suggested spell corrections for a query.
         * </p>
         * 
         * @param spellCorrectedQueries
         *        A list of information related to suggested spell corrections for a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spellCorrectedQueries(Collection<SpellCorrectedQuery> spellCorrectedQueries);

        /**
         * <p>
         * A list of information related to suggested spell corrections for a query.
         * </p>
         * 
         * @param spellCorrectedQueries
         *        A list of information related to suggested spell corrections for a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spellCorrectedQueries(SpellCorrectedQuery... spellCorrectedQueries);

        /**
         * <p>
         * A list of information related to suggested spell corrections for a query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #spellCorrectedQueries(List<SpellCorrectedQuery>)}.
         * 
         * @param spellCorrectedQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spellCorrectedQueries(java.util.Collection<SpellCorrectedQuery>)
         */
        Builder spellCorrectedQueries(Consumer<SpellCorrectedQuery.Builder>... spellCorrectedQueries);

        /**
         * <p>
         * The list of featured result items. Featured results are displayed at the top of the search results page,
         * placed above all other results for certain queries. If there's an exact match of a query, then certain
         * documents are featured in the search results.
         * </p>
         * 
         * @param featuredResultsItems
         *        The list of featured result items. Featured results are displayed at the top of the search results
         *        page, placed above all other results for certain queries. If there's an exact match of a query, then
         *        certain documents are featured in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsItems(Collection<FeaturedResultsItem> featuredResultsItems);

        /**
         * <p>
         * The list of featured result items. Featured results are displayed at the top of the search results page,
         * placed above all other results for certain queries. If there's an exact match of a query, then certain
         * documents are featured in the search results.
         * </p>
         * 
         * @param featuredResultsItems
         *        The list of featured result items. Featured results are displayed at the top of the search results
         *        page, placed above all other results for certain queries. If there's an exact match of a query, then
         *        certain documents are featured in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsItems(FeaturedResultsItem... featuredResultsItems);

        /**
         * <p>
         * The list of featured result items. Featured results are displayed at the top of the search results page,
         * placed above all other results for certain queries. If there's an exact match of a query, then certain
         * documents are featured in the search results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedResultsItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.FeaturedResultsItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.FeaturedResultsItem.Builder#build()} is called
         * immediately and its result is passed to {@link #featuredResultsItems(List<FeaturedResultsItem>)}.
         * 
         * @param featuredResultsItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.FeaturedResultsItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featuredResultsItems(java.util.Collection<FeaturedResultsItem>)
         */
        Builder featuredResultsItems(Consumer<FeaturedResultsItem.Builder>... featuredResultsItems);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String queryId;

        private List<QueryResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private List<FacetResult> facetResults = DefaultSdkAutoConstructList.getInstance();

        private Integer totalNumberOfResults;

        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();

        private List<SpellCorrectedQuery> spellCorrectedQueries = DefaultSdkAutoConstructList.getInstance();

        private List<FeaturedResultsItem> featuredResultsItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            queryId(model.queryId);
            resultItems(model.resultItems);
            facetResults(model.facetResults);
            totalNumberOfResults(model.totalNumberOfResults);
            warnings(model.warnings);
            spellCorrectedQueries(model.spellCorrectedQueries);
            featuredResultsItems(model.featuredResultsItems);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final List<QueryResultItem.Builder> getResultItems() {
            List<QueryResultItem.Builder> result = QueryResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<QueryResultItem.BuilderImpl> resultItems) {
            this.resultItems = QueryResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<QueryResultItem> resultItems) {
            this.resultItems = QueryResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(QueryResultItem... resultItems) {
            resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<QueryResultItem.Builder>... resultItems) {
            resultItems(Stream.of(resultItems).map(c -> QueryResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FacetResult.Builder> getFacetResults() {
            List<FacetResult.Builder> result = FacetResultListCopier.copyToBuilder(this.facetResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFacetResults(Collection<FacetResult.BuilderImpl> facetResults) {
            this.facetResults = FacetResultListCopier.copyFromBuilder(facetResults);
        }

        @Override
        public final Builder facetResults(Collection<FacetResult> facetResults) {
            this.facetResults = FacetResultListCopier.copy(facetResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(FacetResult... facetResults) {
            facetResults(Arrays.asList(facetResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(Consumer<FacetResult.Builder>... facetResults) {
            facetResults(Stream.of(facetResults).map(c -> FacetResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalNumberOfResults() {
            return totalNumberOfResults;
        }

        public final void setTotalNumberOfResults(Integer totalNumberOfResults) {
            this.totalNumberOfResults = totalNumberOfResults;
        }

        @Override
        public final Builder totalNumberOfResults(Integer totalNumberOfResults) {
            this.totalNumberOfResults = totalNumberOfResults;
            return this;
        }

        public final List<Warning.Builder> getWarnings() {
            List<Warning.Builder> result = WarningListCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningListCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningListCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> Warning.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SpellCorrectedQuery.Builder> getSpellCorrectedQueries() {
            List<SpellCorrectedQuery.Builder> result = SpellCorrectedQueryListCopier.copyToBuilder(this.spellCorrectedQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpellCorrectedQueries(Collection<SpellCorrectedQuery.BuilderImpl> spellCorrectedQueries) {
            this.spellCorrectedQueries = SpellCorrectedQueryListCopier.copyFromBuilder(spellCorrectedQueries);
        }

        @Override
        public final Builder spellCorrectedQueries(Collection<SpellCorrectedQuery> spellCorrectedQueries) {
            this.spellCorrectedQueries = SpellCorrectedQueryListCopier.copy(spellCorrectedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spellCorrectedQueries(SpellCorrectedQuery... spellCorrectedQueries) {
            spellCorrectedQueries(Arrays.asList(spellCorrectedQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spellCorrectedQueries(Consumer<SpellCorrectedQuery.Builder>... spellCorrectedQueries) {
            spellCorrectedQueries(Stream.of(spellCorrectedQueries)
                    .map(c -> SpellCorrectedQuery.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FeaturedResultsItem.Builder> getFeaturedResultsItems() {
            List<FeaturedResultsItem.Builder> result = FeaturedResultsItemListCopier.copyToBuilder(this.featuredResultsItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedResultsItems(Collection<FeaturedResultsItem.BuilderImpl> featuredResultsItems) {
            this.featuredResultsItems = FeaturedResultsItemListCopier.copyFromBuilder(featuredResultsItems);
        }

        @Override
        public final Builder featuredResultsItems(Collection<FeaturedResultsItem> featuredResultsItems) {
            this.featuredResultsItems = FeaturedResultsItemListCopier.copy(featuredResultsItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsItems(FeaturedResultsItem... featuredResultsItems) {
            featuredResultsItems(Arrays.asList(featuredResultsItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsItems(Consumer<FeaturedResultsItem.Builder>... featuredResultsItems) {
            featuredResultsItems(Stream.of(featuredResultsItems).map(c -> FeaturedResultsItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
