/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single retrieved relevant passage result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrieveResultItem.Builder, RetrieveResultItem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RetrieveResultItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(RetrieveResultItem::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()).build();

    private static final SdkField<String> DOCUMENT_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentTitle").getter(getter(RetrieveResultItem::documentTitle)).setter(setter(Builder::documentTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(RetrieveResultItem::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentURI").getter(getter(RetrieveResultItem::documentURI)).setter(setter(Builder::documentURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()).build();

    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField
            .<List<DocumentAttribute>> builder(MarshallingType.LIST)
            .memberName("DocumentAttributes")
            .getter(getter(RetrieveResultItem::documentAttributes))
            .setter(setter(Builder::documentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ScoreAttributes> SCORE_ATTRIBUTES_FIELD = SdkField
            .<ScoreAttributes> builder(MarshallingType.SDK_POJO).memberName("ScoreAttributes")
            .getter(getter(RetrieveResultItem::scoreAttributes)).setter(setter(Builder::scoreAttributes))
            .constructor(ScoreAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DOCUMENT_ID_FIELD,
            DOCUMENT_TITLE_FIELD, CONTENT_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD, SCORE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String documentId;

    private final String documentTitle;

    private final String content;

    private final String documentURI;

    private final List<DocumentAttribute> documentAttributes;

    private final ScoreAttributes scoreAttributes;

    private RetrieveResultItem(BuilderImpl builder) {
        this.id = builder.id;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.content = builder.content;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
        this.scoreAttributes = builder.scoreAttributes;
    }

    /**
     * <p>
     * The identifier of the relevant passage result.
     * </p>
     * 
     * @return The identifier of the relevant passage result.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the document.
     * </p>
     * 
     * @return The identifier of the document.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The title of the document.
     * </p>
     * 
     * @return The title of the document.
     */
    public final String documentTitle() {
        return documentTitle;
    }

    /**
     * <p>
     * The contents of the relevant passage.
     * </p>
     * 
     * @return The contents of the relevant passage.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The URI of the original location of the document.
     * </p>
     * 
     * @return The URI of the original location of the document.
     */
    public final String documentURI() {
        return documentURI;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentAttributes() {
        return documentAttributes != null && !(documentAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of document fields/attributes assigned to a document in the search results. For example, the document
     * author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentAttributes} method.
     * </p>
     * 
     * @return An array of document fields/attributes assigned to a document in the search results. For example, the
     *         document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
     */
    public final List<DocumentAttribute> documentAttributes() {
        return documentAttributes;
    }

    /**
     * <p>
     * The confidence score bucket for a retrieved passage result. The confidence bucket provides a relative ranking
     * that indicates how confident Amazon Kendra is that the response is relevant to the query.
     * </p>
     * 
     * @return The confidence score bucket for a retrieved passage result. The confidence bucket provides a relative
     *         ranking that indicates how confident Amazon Kendra is that the response is relevant to the query.
     */
    public final ScoreAttributes scoreAttributes() {
        return scoreAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentAttributes() ? documentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scoreAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveResultItem)) {
            return false;
        }
        RetrieveResultItem other = (RetrieveResultItem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(documentId(), other.documentId())
                && Objects.equals(documentTitle(), other.documentTitle()) && Objects.equals(content(), other.content())
                && Objects.equals(documentURI(), other.documentURI()) && hasDocumentAttributes() == other.hasDocumentAttributes()
                && Objects.equals(documentAttributes(), other.documentAttributes())
                && Objects.equals(scoreAttributes(), other.scoreAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveResultItem").add("Id", id()).add("DocumentId", documentId())
                .add("DocumentTitle", documentTitle()).add("Content", content()).add("DocumentURI", documentURI())
                .add("DocumentAttributes", hasDocumentAttributes() ? documentAttributes() : null)
                .add("ScoreAttributes", scoreAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "DocumentTitle":
            return Optional.ofNullable(clazz.cast(documentTitle()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "DocumentURI":
            return Optional.ofNullable(clazz.cast(documentURI()));
        case "DocumentAttributes":
            return Optional.ofNullable(clazz.cast(documentAttributes()));
        case "ScoreAttributes":
            return Optional.ofNullable(clazz.cast(scoreAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("DocumentId", DOCUMENT_ID_FIELD);
        map.put("DocumentTitle", DOCUMENT_TITLE_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("DocumentURI", DOCUMENT_URI_FIELD);
        map.put("DocumentAttributes", DOCUMENT_ATTRIBUTES_FIELD);
        map.put("ScoreAttributes", SCORE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveResultItem, T> g) {
        return obj -> g.apply((RetrieveResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrieveResultItem> {
        /**
         * <p>
         * The identifier of the relevant passage result.
         * </p>
         * 
         * @param id
         *        The identifier of the relevant passage result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the document.
         * </p>
         * 
         * @param documentId
         *        The identifier of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The title of the document.
         * </p>
         * 
         * @param documentTitle
         *        The title of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitle(String documentTitle);

        /**
         * <p>
         * The contents of the relevant passage.
         * </p>
         * 
         * @param content
         *        The contents of the relevant passage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The URI of the original location of the document.
         * </p>
         * 
         * @param documentURI
         *        The URI of the original location of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentURI(String documentURI);

        /**
         * <p>
         * An array of document fields/attributes assigned to a document in the search results. For example, the
         * document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * </p>
         * 
         * @param documentAttributes
         *        An array of document fields/attributes assigned to a document in the search results. For example, the
         *        document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(Collection<DocumentAttribute> documentAttributes);

        /**
         * <p>
         * An array of document fields/attributes assigned to a document in the search results. For example, the
         * document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * </p>
         * 
         * @param documentAttributes
         *        An array of document fields/attributes assigned to a document in the search results. For example, the
         *        document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(DocumentAttribute... documentAttributes);

        /**
         * <p>
         * An array of document fields/attributes assigned to a document in the search results. For example, the
         * document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder#build()} is called immediately
         * and its result is passed to {@link #documentAttributes(List<DocumentAttribute>)}.
         * 
         * @param documentAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributes(java.util.Collection<DocumentAttribute>)
         */
        Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes);

        /**
         * <p>
         * The confidence score bucket for a retrieved passage result. The confidence bucket provides a relative ranking
         * that indicates how confident Amazon Kendra is that the response is relevant to the query.
         * </p>
         * 
         * @param scoreAttributes
         *        The confidence score bucket for a retrieved passage result. The confidence bucket provides a relative
         *        ranking that indicates how confident Amazon Kendra is that the response is relevant to the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreAttributes(ScoreAttributes scoreAttributes);

        /**
         * <p>
         * The confidence score bucket for a retrieved passage result. The confidence bucket provides a relative ranking
         * that indicates how confident Amazon Kendra is that the response is relevant to the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScoreAttributes.Builder} avoiding the
         * need to create one manually via {@link ScoreAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScoreAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #scoreAttributes(ScoreAttributes)}.
         * 
         * @param scoreAttributes
         *        a consumer that will call methods on {@link ScoreAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoreAttributes(ScoreAttributes)
         */
        default Builder scoreAttributes(Consumer<ScoreAttributes.Builder> scoreAttributes) {
            return scoreAttributes(ScoreAttributes.builder().applyMutation(scoreAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String documentId;

        private String documentTitle;

        private String content;

        private String documentURI;

        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();

        private ScoreAttributes scoreAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveResultItem model) {
            id(model.id);
            documentId(model.documentId);
            documentTitle(model.documentTitle);
            content(model.content);
            documentURI(model.documentURI);
            documentAttributes(model.documentAttributes);
            scoreAttributes(model.scoreAttributes);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getDocumentTitle() {
            return documentTitle;
        }

        public final void setDocumentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
        }

        @Override
        public final Builder documentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getDocumentURI() {
            return documentURI;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute... documentAttributes) {
            documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes) {
            documentAttributes(Stream.of(documentAttributes).map(c -> DocumentAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ScoreAttributes.Builder getScoreAttributes() {
            return scoreAttributes != null ? scoreAttributes.toBuilder() : null;
        }

        public final void setScoreAttributes(ScoreAttributes.BuilderImpl scoreAttributes) {
            this.scoreAttributes = scoreAttributes != null ? scoreAttributes.build() : null;
        }

        @Override
        public final Builder scoreAttributes(ScoreAttributes scoreAttributes) {
            this.scoreAttributes = scoreAttributes;
            return this;
        }

        @Override
        public RetrieveResultItem build() {
            return new RetrieveResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
