/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to GitHub Enterprise Cloud (SaaS).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SaaSConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SaaSConfiguration.Builder, SaaSConfiguration> {
    private static final SdkField<String> ORGANIZATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationName").getter(getter(SaaSConfiguration::organizationName))
            .setter(setter(Builder::organizationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationName").build()).build();

    private static final SdkField<String> HOST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostUrl").getter(getter(SaaSConfiguration::hostUrl)).setter(setter(Builder::hostUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_NAME_FIELD,
            HOST_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String organizationName;

    private final String hostUrl;

    private SaaSConfiguration(BuilderImpl builder) {
        this.organizationName = builder.organizationName;
        this.hostUrl = builder.hostUrl;
    }

    /**
     * <p>
     * The name of the organization of the GitHub Enterprise Cloud (SaaS) account you want to connect to. You can find
     * your organization name by logging into GitHub desktop and selecting <b>Your organizations</b> under your profile
     * picture dropdown.
     * </p>
     * 
     * @return The name of the organization of the GitHub Enterprise Cloud (SaaS) account you want to connect to. You
     *         can find your organization name by logging into GitHub desktop and selecting <b>Your organizations</b>
     *         under your profile picture dropdown.
     */
    public final String organizationName() {
        return organizationName;
    }

    /**
     * <p>
     * The GitHub host URL or API endpoint URL. For example, <i>https://api.github.com</i>.
     * </p>
     * 
     * @return The GitHub host URL or API endpoint URL. For example, <i>https://api.github.com</i>.
     */
    public final String hostUrl() {
        return hostUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationName());
        hashCode = 31 * hashCode + Objects.hashCode(hostUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SaaSConfiguration)) {
            return false;
        }
        SaaSConfiguration other = (SaaSConfiguration) obj;
        return Objects.equals(organizationName(), other.organizationName()) && Objects.equals(hostUrl(), other.hostUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SaaSConfiguration").add("OrganizationName", organizationName()).add("HostUrl", hostUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationName":
            return Optional.ofNullable(clazz.cast(organizationName()));
        case "HostUrl":
            return Optional.ofNullable(clazz.cast(hostUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationName", ORGANIZATION_NAME_FIELD);
        map.put("HostUrl", HOST_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SaaSConfiguration, T> g) {
        return obj -> g.apply((SaaSConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SaaSConfiguration> {
        /**
         * <p>
         * The name of the organization of the GitHub Enterprise Cloud (SaaS) account you want to connect to. You can
         * find your organization name by logging into GitHub desktop and selecting <b>Your organizations</b> under your
         * profile picture dropdown.
         * </p>
         * 
         * @param organizationName
         *        The name of the organization of the GitHub Enterprise Cloud (SaaS) account you want to connect to. You
         *        can find your organization name by logging into GitHub desktop and selecting <b>Your organizations</b>
         *        under your profile picture dropdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationName(String organizationName);

        /**
         * <p>
         * The GitHub host URL or API endpoint URL. For example, <i>https://api.github.com</i>.
         * </p>
         * 
         * @param hostUrl
         *        The GitHub host URL or API endpoint URL. For example, <i>https://api.github.com</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostUrl(String hostUrl);
    }

    static final class BuilderImpl implements Builder {
        private String organizationName;

        private String hostUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SaaSConfiguration model) {
            organizationName(model.organizationName);
            hostUrl(model.hostUrl);
        }

        public final String getOrganizationName() {
            return organizationName;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final String getHostUrl() {
            return hostUrl;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        @Override
        public SaaSConfiguration build() {
            return new SaaSConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
