/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to connect to Microsoft SharePoint as your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SharePointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SharePointConfiguration.Builder, SharePointConfiguration> {
    private static final SdkField<String> SHARE_POINT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharePointVersion").getter(getter(SharePointConfiguration::sharePointVersionAsString))
            .setter(setter(Builder::sharePointVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharePointVersion").build()).build();

    private static final SdkField<List<String>> URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Urls")
            .getter(getter(SharePointConfiguration::urls))
            .setter(setter(Builder::urls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(SharePointConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlAttachments").getter(getter(SharePointConfiguration::crawlAttachments))
            .setter(setter(Builder::crawlAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()).build();

    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseChangeLog").getter(getter(SharePointConfiguration::useChangeLog))
            .setter(setter(Builder::useChangeLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()).build();

    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InclusionPatterns")
            .getter(getter(SharePointConfiguration::inclusionPatterns))
            .setter(setter(Builder::inclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExclusionPatterns")
            .getter(getter(SharePointConfiguration::exclusionPatterns))
            .setter(setter(Builder::exclusionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(SharePointConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("FieldMappings")
            .getter(getter(SharePointConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentTitleFieldName").getter(getter(SharePointConfiguration::documentTitleFieldName))
            .setter(setter(Builder::documentTitleFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build())
            .build();

    private static final SdkField<Boolean> DISABLE_LOCAL_GROUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableLocalGroups").getter(getter(SharePointConfiguration::disableLocalGroups))
            .setter(setter(Builder::disableLocalGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableLocalGroups").build())
            .build();

    private static final SdkField<S3Path> SSL_CERTIFICATE_S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("SslCertificateS3Path").getter(getter(SharePointConfiguration::sslCertificateS3Path))
            .setter(setter(Builder::sslCertificateS3Path)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCertificateS3Path").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(SharePointConfiguration::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<ProxyConfiguration> PROXY_CONFIGURATION_FIELD = SdkField
            .<ProxyConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProxyConfiguration")
            .getter(getter(SharePointConfiguration::proxyConfiguration)).setter(setter(Builder::proxyConfiguration))
            .constructor(ProxyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_POINT_VERSION_FIELD,
            URLS_FIELD, SECRET_ARN_FIELD, CRAWL_ATTACHMENTS_FIELD, USE_CHANGE_LOG_FIELD, INCLUSION_PATTERNS_FIELD,
            EXCLUSION_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD, FIELD_MAPPINGS_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD,
            DISABLE_LOCAL_GROUPS_FIELD, SSL_CERTIFICATE_S3_PATH_FIELD, AUTHENTICATION_TYPE_FIELD, PROXY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sharePointVersion;

    private final List<String> urls;

    private final String secretArn;

    private final Boolean crawlAttachments;

    private final Boolean useChangeLog;

    private final List<String> inclusionPatterns;

    private final List<String> exclusionPatterns;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private final String documentTitleFieldName;

    private final Boolean disableLocalGroups;

    private final S3Path sslCertificateS3Path;

    private final String authenticationType;

    private final ProxyConfiguration proxyConfiguration;

    private SharePointConfiguration(BuilderImpl builder) {
        this.sharePointVersion = builder.sharePointVersion;
        this.urls = builder.urls;
        this.secretArn = builder.secretArn;
        this.crawlAttachments = builder.crawlAttachments;
        this.useChangeLog = builder.useChangeLog;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.fieldMappings = builder.fieldMappings;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.disableLocalGroups = builder.disableLocalGroups;
        this.sslCertificateS3Path = builder.sslCertificateS3Path;
        this.authenticationType = builder.authenticationType;
        this.proxyConfiguration = builder.proxyConfiguration;
    }

    /**
     * <p>
     * The version of Microsoft SharePoint that you use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sharePointVersion}
     * will return {@link SharePointVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sharePointVersionAsString}.
     * </p>
     * 
     * @return The version of Microsoft SharePoint that you use.
     * @see SharePointVersion
     */
    public final SharePointVersion sharePointVersion() {
        return SharePointVersion.fromValue(sharePointVersion);
    }

    /**
     * <p>
     * The version of Microsoft SharePoint that you use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sharePointVersion}
     * will return {@link SharePointVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sharePointVersionAsString}.
     * </p>
     * 
     * @return The version of Microsoft SharePoint that you use.
     * @see SharePointVersion
     */
    public final String sharePointVersionAsString() {
        return sharePointVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Urls property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUrls() {
        return urls != null && !(urls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Microsoft SharePoint site URLs for the documents you want to index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUrls} method.
     * </p>
     * 
     * @return The Microsoft SharePoint site URLs for the documents you want to index.
     */
    public final List<String> urls() {
        return urls;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password required to
     * connect to the SharePoint instance. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Microsoft SharePoint</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password
     *         required to connect to the SharePoint instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Microsoft SharePoint</a>.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * <code>TRUE</code> to index document attachments.
     * </p>
     * 
     * @return <code>TRUE</code> to index document attachments.
     */
    public final Boolean crawlAttachments() {
        return crawlAttachments;
    }

    /**
     * <p>
     * <code>TRUE</code> to use the SharePoint change log to determine which documents require updating in the index.
     * Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all
     * of your documents in SharePoint.
     * </p>
     * 
     * @return <code>TRUE</code> to use the SharePoint change log to determine which documents require updating in the
     *         index. Depending on the change log's size, it may take longer for Amazon Kendra to use the change log
     *         than to scan all of your documents in SharePoint.
     */
    public final Boolean useChangeLog() {
        return useChangeLog;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionPatterns() {
        return inclusionPatterns != null && !(inclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to include certain documents in your SharePoint. Documents that match the
     * patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a
     * document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document
     * isn't included in the index.
     * </p>
     * <p>
     * The regex applies to the display URL of the SharePoint document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to include certain documents in your SharePoint. Documents that
     *         match the patterns are included in the index. Documents that don't match the patterns are excluded from
     *         the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes
     *         precedence and the document isn't included in the index.</p>
     *         <p>
     *         The regex applies to the display URL of the SharePoint document.
     */
    public final List<String> inclusionPatterns() {
        return inclusionPatterns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionPatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionPatterns() {
        return exclusionPatterns != null && !(exclusionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that match the
     * patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a
     * document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document
     * isn't included in the index.
     * </p>
     * <p>
     * The regex applies to the display URL of the SharePoint document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionPatterns} method.
     * </p>
     * 
     * @return A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that
     *         match the patterns are excluded from the index. Documents that don't match the patterns are included in
     *         the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes
     *         precedence and the document isn't included in the index.</p>
     *         <p>
     *         The regex applies to the display URL of the SharePoint document.
     */
    public final List<String> exclusionPatterns() {
        return exclusionPatterns;
    }

    /**
     * <p>
     * Configuration information for an Amazon Virtual Private Cloud to connect to your Microsoft SharePoint. For more
     * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a
     * VPC</a>.
     * </p>
     * 
     * @return Configuration information for an Amazon Virtual Private Cloud to connect to your Microsoft SharePoint.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataSourceToIndexFieldMapping</code> objects that map SharePoint data source attributes or field
     * names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before
     * you map to SharePoint fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
     * SharePoint data source field names must exist in your SharePoint custom metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldMappings} method.
     * </p>
     * 
     * @return A list of <code>DataSourceToIndexFieldMapping</code> objects that map SharePoint data source attributes
     *         or field names to Amazon Kendra index field names. To create custom fields, use the
     *         <code>UpdateIndex</code> API before you map to SharePoint fields. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
     *         The SharePoint data source field names must exist in your SharePoint custom metadata.
     */
    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    /**
     * <p>
     * The Microsoft SharePoint attribute field that contains the title of the document.
     * </p>
     * 
     * @return The Microsoft SharePoint attribute field that contains the title of the document.
     */
    public final String documentTitleFieldName() {
        return documentTitleFieldName;
    }

    /**
     * <p>
     * <code>TRUE</code> to disable local groups information.
     * </p>
     * 
     * @return <code>TRUE</code> to disable local groups information.
     */
    public final Boolean disableLocalGroups() {
        return disableLocalGroups;
    }

    /**
     * <p>
     * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to SharePoint Server if
     * you require a secure SSL connection.
     * </p>
     * <p>
     * You can generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using OpenSSL to
     * create an X509 certificate, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an X509
     * certificate</a>.
     * </p>
     * 
     * @return The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to SharePoint
     *         Server if you require a secure SSL connection.</p>
     *         <p>
     *         You can generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using
     *         OpenSSL to create an X509 certificate, see <a
     *         href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign
     *         an X509 certificate</a>.
     */
    public final S3Path sslCertificateS3Path() {
        return sslCertificateS3Path;
    }

    /**
     * <p>
     * Whether you want to connect to SharePoint Online using basic authentication of user name and password, or OAuth
     * authentication of user name, password, client ID, and client secret, or AD App-only authentication of client
     * secret.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link SharePointOnlineAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return Whether you want to connect to SharePoint Online using basic authentication of user name and password, or
     *         OAuth authentication of user name, password, client ID, and client secret, or AD App-only authentication
     *         of client secret.
     * @see SharePointOnlineAuthenticationType
     */
    public final SharePointOnlineAuthenticationType authenticationType() {
        return SharePointOnlineAuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * Whether you want to connect to SharePoint Online using basic authentication of user name and password, or OAuth
     * authentication of user name, password, client ID, and client secret, or AD App-only authentication of client
     * secret.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link SharePointOnlineAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return Whether you want to connect to SharePoint Online using basic authentication of user name and password, or
     *         OAuth authentication of user name, password, client ID, and client secret, or AD App-only authentication
     *         of client secret.
     * @see SharePointOnlineAuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * Configuration information to connect to your Microsoft SharePoint site URLs via instance via a web proxy. You can
     * use this option for SharePoint Server.
     * </p>
     * <p>
     * You must provide the website host name and port number. For example, the host name of
     * <i>https://a.example.com/page1.html</i> is "a.example.com" and the port is 443, the standard port for HTTPS.
     * </p>
     * <p>
     * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic
     * authentication of user name and password. To store web proxy credentials, you use a secret in Secrets Manager.
     * </p>
     * <p>
     * It is recommended that you follow best security practices when configuring your web proxy. This includes setting
     * up throttling, setting up logging and monitoring, and applying security patches on a regular basis. If you use
     * your web proxy with multiple data sources, sync jobs that occur at the same time could strain the load on your
     * proxy. It is recommended you prepare your proxy beforehand for any security and load requirements.
     * </p>
     * 
     * @return Configuration information to connect to your Microsoft SharePoint site URLs via instance via a web proxy.
     *         You can use this option for SharePoint Server.</p>
     *         <p>
     *         You must provide the website host name and port number. For example, the host name of
     *         <i>https://a.example.com/page1.html</i> is "a.example.com" and the port is 443, the standard port for
     *         HTTPS.
     *         </p>
     *         <p>
     *         Web proxy credentials are optional and you can use them to connect to a web proxy server that requires
     *         basic authentication of user name and password. To store web proxy credentials, you use a secret in
     *         Secrets Manager.
     *         </p>
     *         <p>
     *         It is recommended that you follow best security practices when configuring your web proxy. This includes
     *         setting up throttling, setting up logging and monitoring, and applying security patches on a regular
     *         basis. If you use your web proxy with multiple data sources, sync jobs that occur at the same time could
     *         strain the load on your proxy. It is recommended you prepare your proxy beforehand for any security and
     *         load requirements.
     */
    public final ProxyConfiguration proxyConfiguration() {
        return proxyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharePointVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUrls() ? urls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionPatterns() ? inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionPatterns() ? exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMappings() ? fieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(disableLocalGroups());
        hashCode = 31 * hashCode + Objects.hashCode(sslCertificateS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointConfiguration)) {
            return false;
        }
        SharePointConfiguration other = (SharePointConfiguration) obj;
        return Objects.equals(sharePointVersionAsString(), other.sharePointVersionAsString()) && hasUrls() == other.hasUrls()
                && Objects.equals(urls(), other.urls()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(crawlAttachments(), other.crawlAttachments())
                && Objects.equals(useChangeLog(), other.useChangeLog()) && hasInclusionPatterns() == other.hasInclusionPatterns()
                && Objects.equals(inclusionPatterns(), other.inclusionPatterns())
                && hasExclusionPatterns() == other.hasExclusionPatterns()
                && Objects.equals(exclusionPatterns(), other.exclusionPatterns())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration()) && hasFieldMappings() == other.hasFieldMappings()
                && Objects.equals(fieldMappings(), other.fieldMappings())
                && Objects.equals(documentTitleFieldName(), other.documentTitleFieldName())
                && Objects.equals(disableLocalGroups(), other.disableLocalGroups())
                && Objects.equals(sslCertificateS3Path(), other.sslCertificateS3Path())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(proxyConfiguration(), other.proxyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SharePointConfiguration").add("SharePointVersion", sharePointVersionAsString())
                .add("Urls", hasUrls() ? urls() : null).add("SecretArn", secretArn()).add("CrawlAttachments", crawlAttachments())
                .add("UseChangeLog", useChangeLog())
                .add("InclusionPatterns", hasInclusionPatterns() ? inclusionPatterns() : null)
                .add("ExclusionPatterns", hasExclusionPatterns() ? exclusionPatterns() : null)
                .add("VpcConfiguration", vpcConfiguration()).add("FieldMappings", hasFieldMappings() ? fieldMappings() : null)
                .add("DocumentTitleFieldName", documentTitleFieldName()).add("DisableLocalGroups", disableLocalGroups())
                .add("SslCertificateS3Path", sslCertificateS3Path()).add("AuthenticationType", authenticationTypeAsString())
                .add("ProxyConfiguration", proxyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SharePointVersion":
            return Optional.ofNullable(clazz.cast(sharePointVersionAsString()));
        case "Urls":
            return Optional.ofNullable(clazz.cast(urls()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "CrawlAttachments":
            return Optional.ofNullable(clazz.cast(crawlAttachments()));
        case "UseChangeLog":
            return Optional.ofNullable(clazz.cast(useChangeLog()));
        case "InclusionPatterns":
            return Optional.ofNullable(clazz.cast(inclusionPatterns()));
        case "ExclusionPatterns":
            return Optional.ofNullable(clazz.cast(exclusionPatterns()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        case "DocumentTitleFieldName":
            return Optional.ofNullable(clazz.cast(documentTitleFieldName()));
        case "DisableLocalGroups":
            return Optional.ofNullable(clazz.cast(disableLocalGroups()));
        case "SslCertificateS3Path":
            return Optional.ofNullable(clazz.cast(sslCertificateS3Path()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "ProxyConfiguration":
            return Optional.ofNullable(clazz.cast(proxyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SharePointVersion", SHARE_POINT_VERSION_FIELD);
        map.put("Urls", URLS_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("CrawlAttachments", CRAWL_ATTACHMENTS_FIELD);
        map.put("UseChangeLog", USE_CHANGE_LOG_FIELD);
        map.put("InclusionPatterns", INCLUSION_PATTERNS_FIELD);
        map.put("ExclusionPatterns", EXCLUSION_PATTERNS_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("FieldMappings", FIELD_MAPPINGS_FIELD);
        map.put("DocumentTitleFieldName", DOCUMENT_TITLE_FIELD_NAME_FIELD);
        map.put("DisableLocalGroups", DISABLE_LOCAL_GROUPS_FIELD);
        map.put("SslCertificateS3Path", SSL_CERTIFICATE_S3_PATH_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("ProxyConfiguration", PROXY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SharePointConfiguration, T> g) {
        return obj -> g.apply((SharePointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SharePointConfiguration> {
        /**
         * <p>
         * The version of Microsoft SharePoint that you use.
         * </p>
         * 
         * @param sharePointVersion
         *        The version of Microsoft SharePoint that you use.
         * @see SharePointVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharePointVersion
         */
        Builder sharePointVersion(String sharePointVersion);

        /**
         * <p>
         * The version of Microsoft SharePoint that you use.
         * </p>
         * 
         * @param sharePointVersion
         *        The version of Microsoft SharePoint that you use.
         * @see SharePointVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharePointVersion
         */
        Builder sharePointVersion(SharePointVersion sharePointVersion);

        /**
         * <p>
         * The Microsoft SharePoint site URLs for the documents you want to index.
         * </p>
         * 
         * @param urls
         *        The Microsoft SharePoint site URLs for the documents you want to index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(Collection<String> urls);

        /**
         * <p>
         * The Microsoft SharePoint site URLs for the documents you want to index.
         * </p>
         * 
         * @param urls
         *        The Microsoft SharePoint site URLs for the documents you want to index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(String... urls);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password required
         * to connect to the SharePoint instance. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Microsoft SharePoint</a>.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password
         *        required to connect to the SharePoint instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Microsoft
         *        SharePoint</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * <code>TRUE</code> to index document attachments.
         * </p>
         * 
         * @param crawlAttachments
         *        <code>TRUE</code> to index document attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlAttachments(Boolean crawlAttachments);

        /**
         * <p>
         * <code>TRUE</code> to use the SharePoint change log to determine which documents require updating in the
         * index. Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to
         * scan all of your documents in SharePoint.
         * </p>
         * 
         * @param useChangeLog
         *        <code>TRUE</code> to use the SharePoint change log to determine which documents require updating in
         *        the index. Depending on the change log's size, it may take longer for Amazon Kendra to use the change
         *        log than to scan all of your documents in SharePoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useChangeLog(Boolean useChangeLog);

        /**
         * <p>
         * A list of regular expression patterns to include certain documents in your SharePoint. Documents that match
         * the patterns are included in the index. Documents that don't match the patterns are excluded from the index.
         * If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * </p>
         * <p>
         * The regex applies to the display URL of the SharePoint document.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain documents in your SharePoint. Documents that
         *        match the patterns are included in the index. Documents that don't match the patterns are excluded
         *        from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern
         *        takes precedence and the document isn't included in the index.</p>
         *        <p>
         *        The regex applies to the display URL of the SharePoint document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(Collection<String> inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to include certain documents in your SharePoint. Documents that match
         * the patterns are included in the index. Documents that don't match the patterns are excluded from the index.
         * If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * </p>
         * <p>
         * The regex applies to the display URL of the SharePoint document.
         * </p>
         * 
         * @param inclusionPatterns
         *        A list of regular expression patterns to include certain documents in your SharePoint. Documents that
         *        match the patterns are included in the index. Documents that don't match the patterns are excluded
         *        from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern
         *        takes precedence and the document isn't included in the index.</p>
         *        <p>
         *        The regex applies to the display URL of the SharePoint document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionPatterns(String... inclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that match
         * the patterns are excluded from the index. Documents that don't match the patterns are included in the index.
         * If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * </p>
         * <p>
         * The regex applies to the display URL of the SharePoint document.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that
         *        match the patterns are excluded from the index. Documents that don't match the patterns are included
         *        in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern
         *        takes precedence and the document isn't included in the index.</p>
         *        <p>
         *        The regex applies to the display URL of the SharePoint document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(Collection<String> exclusionPatterns);

        /**
         * <p>
         * A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that match
         * the patterns are excluded from the index. Documents that don't match the patterns are included in the index.
         * If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * </p>
         * <p>
         * The regex applies to the display URL of the SharePoint document.
         * </p>
         * 
         * @param exclusionPatterns
         *        A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that
         *        match the patterns are excluded from the index. Documents that don't match the patterns are included
         *        in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern
         *        takes precedence and the document isn't included in the index.</p>
         *        <p>
         *        The regex applies to the display URL of the SharePoint document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPatterns(String... exclusionPatterns);

        /**
         * <p>
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Microsoft SharePoint. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information for an Amazon Virtual Private Cloud to connect to your Microsoft SharePoint.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Microsoft SharePoint. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map SharePoint data source attributes or
         * field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to SharePoint fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * SharePoint data source field names must exist in your SharePoint custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map SharePoint data source
         *        attributes or field names to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to SharePoint fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The SharePoint data source field names must exist in your SharePoint custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map SharePoint data source attributes or
         * field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to SharePoint fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * SharePoint data source field names must exist in your SharePoint custom metadata.
         * </p>
         * 
         * @param fieldMappings
         *        A list of <code>DataSourceToIndexFieldMapping</code> objects that map SharePoint data source
         *        attributes or field names to Amazon Kendra index field names. To create custom fields, use the
         *        <code>UpdateIndex</code> API before you map to SharePoint fields. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.
         *        The SharePoint data source field names must exist in your SharePoint custom metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * A list of <code>DataSourceToIndexFieldMapping</code> objects that map SharePoint data source attributes or
         * field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API
         * before you map to SharePoint fields. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
         * SharePoint data source field names must exist in your SharePoint custom metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(java.util.Collection<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);

        /**
         * <p>
         * The Microsoft SharePoint attribute field that contains the title of the document.
         * </p>
         * 
         * @param documentTitleFieldName
         *        The Microsoft SharePoint attribute field that contains the title of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitleFieldName(String documentTitleFieldName);

        /**
         * <p>
         * <code>TRUE</code> to disable local groups information.
         * </p>
         * 
         * @param disableLocalGroups
         *        <code>TRUE</code> to disable local groups information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableLocalGroups(Boolean disableLocalGroups);

        /**
         * <p>
         * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to SharePoint Server
         * if you require a secure SSL connection.
         * </p>
         * <p>
         * You can generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using
         * OpenSSL to create an X509 certificate, see <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an
         * X509 certificate</a>.
         * </p>
         * 
         * @param sslCertificateS3Path
         *        The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to SharePoint
         *        Server if you require a secure SSL connection.</p>
         *        <p>
         *        You can generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using
         *        OpenSSL to create an X509 certificate, see <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and
         *        sign an X509 certificate</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslCertificateS3Path(S3Path sslCertificateS3Path);

        /**
         * <p>
         * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to SharePoint Server
         * if you require a secure SSL connection.
         * </p>
         * <p>
         * You can generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using
         * OpenSSL to create an X509 certificate, see <a
         * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an
         * X509 certificate</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Path.Builder} avoiding the need to
         * create one manually via {@link S3Path#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #sslCertificateS3Path(S3Path)}.
         * 
         * @param sslCertificateS3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sslCertificateS3Path(S3Path)
         */
        default Builder sslCertificateS3Path(Consumer<S3Path.Builder> sslCertificateS3Path) {
            return sslCertificateS3Path(S3Path.builder().applyMutation(sslCertificateS3Path).build());
        }

        /**
         * <p>
         * Whether you want to connect to SharePoint Online using basic authentication of user name and password, or
         * OAuth authentication of user name, password, client ID, and client secret, or AD App-only authentication of
         * client secret.
         * </p>
         * 
         * @param authenticationType
         *        Whether you want to connect to SharePoint Online using basic authentication of user name and password,
         *        or OAuth authentication of user name, password, client ID, and client secret, or AD App-only
         *        authentication of client secret.
         * @see SharePointOnlineAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharePointOnlineAuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * Whether you want to connect to SharePoint Online using basic authentication of user name and password, or
         * OAuth authentication of user name, password, client ID, and client secret, or AD App-only authentication of
         * client secret.
         * </p>
         * 
         * @param authenticationType
         *        Whether you want to connect to SharePoint Online using basic authentication of user name and password,
         *        or OAuth authentication of user name, password, client ID, and client secret, or AD App-only
         *        authentication of client secret.
         * @see SharePointOnlineAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharePointOnlineAuthenticationType
         */
        Builder authenticationType(SharePointOnlineAuthenticationType authenticationType);

        /**
         * <p>
         * Configuration information to connect to your Microsoft SharePoint site URLs via instance via a web proxy. You
         * can use this option for SharePoint Server.
         * </p>
         * <p>
         * You must provide the website host name and port number. For example, the host name of
         * <i>https://a.example.com/page1.html</i> is "a.example.com" and the port is 443, the standard port for HTTPS.
         * </p>
         * <p>
         * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic
         * authentication of user name and password. To store web proxy credentials, you use a secret in Secrets
         * Manager.
         * </p>
         * <p>
         * It is recommended that you follow best security practices when configuring your web proxy. This includes
         * setting up throttling, setting up logging and monitoring, and applying security patches on a regular basis.
         * If you use your web proxy with multiple data sources, sync jobs that occur at the same time could strain the
         * load on your proxy. It is recommended you prepare your proxy beforehand for any security and load
         * requirements.
         * </p>
         * 
         * @param proxyConfiguration
         *        Configuration information to connect to your Microsoft SharePoint site URLs via instance via a web
         *        proxy. You can use this option for SharePoint Server.</p>
         *        <p>
         *        You must provide the website host name and port number. For example, the host name of
         *        <i>https://a.example.com/page1.html</i> is "a.example.com" and the port is 443, the standard port for
         *        HTTPS.
         *        </p>
         *        <p>
         *        Web proxy credentials are optional and you can use them to connect to a web proxy server that requires
         *        basic authentication of user name and password. To store web proxy credentials, you use a secret in
         *        Secrets Manager.
         *        </p>
         *        <p>
         *        It is recommended that you follow best security practices when configuring your web proxy. This
         *        includes setting up throttling, setting up logging and monitoring, and applying security patches on a
         *        regular basis. If you use your web proxy with multiple data sources, sync jobs that occur at the same
         *        time could strain the load on your proxy. It is recommended you prepare your proxy beforehand for any
         *        security and load requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfiguration(ProxyConfiguration proxyConfiguration);

        /**
         * <p>
         * Configuration information to connect to your Microsoft SharePoint site URLs via instance via a web proxy. You
         * can use this option for SharePoint Server.
         * </p>
         * <p>
         * You must provide the website host name and port number. For example, the host name of
         * <i>https://a.example.com/page1.html</i> is "a.example.com" and the port is 443, the standard port for HTTPS.
         * </p>
         * <p>
         * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic
         * authentication of user name and password. To store web proxy credentials, you use a secret in Secrets
         * Manager.
         * </p>
         * <p>
         * It is recommended that you follow best security practices when configuring your web proxy. This includes
         * setting up throttling, setting up logging and monitoring, and applying security patches on a regular basis.
         * If you use your web proxy with multiple data sources, sync jobs that occur at the same time could strain the
         * load on your proxy. It is recommended you prepare your proxy beforehand for any security and load
         * requirements.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProxyConfiguration.Builder} avoiding the
         * need to create one manually via {@link ProxyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProxyConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #proxyConfiguration(ProxyConfiguration)}.
         * 
         * @param proxyConfiguration
         *        a consumer that will call methods on {@link ProxyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxyConfiguration(ProxyConfiguration)
         */
        default Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfiguration) {
            return proxyConfiguration(ProxyConfiguration.builder().applyMutation(proxyConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sharePointVersion;

        private List<String> urls = DefaultSdkAutoConstructList.getInstance();

        private String secretArn;

        private Boolean crawlAttachments;

        private Boolean useChangeLog;

        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();

        private DataSourceVpcConfiguration vpcConfiguration;

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private String documentTitleFieldName;

        private Boolean disableLocalGroups;

        private S3Path sslCertificateS3Path;

        private String authenticationType;

        private ProxyConfiguration proxyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SharePointConfiguration model) {
            sharePointVersion(model.sharePointVersion);
            urls(model.urls);
            secretArn(model.secretArn);
            crawlAttachments(model.crawlAttachments);
            useChangeLog(model.useChangeLog);
            inclusionPatterns(model.inclusionPatterns);
            exclusionPatterns(model.exclusionPatterns);
            vpcConfiguration(model.vpcConfiguration);
            fieldMappings(model.fieldMappings);
            documentTitleFieldName(model.documentTitleFieldName);
            disableLocalGroups(model.disableLocalGroups);
            sslCertificateS3Path(model.sslCertificateS3Path);
            authenticationType(model.authenticationType);
            proxyConfiguration(model.proxyConfiguration);
        }

        public final String getSharePointVersion() {
            return sharePointVersion;
        }

        public final void setSharePointVersion(String sharePointVersion) {
            this.sharePointVersion = sharePointVersion;
        }

        @Override
        public final Builder sharePointVersion(String sharePointVersion) {
            this.sharePointVersion = sharePointVersion;
            return this;
        }

        @Override
        public final Builder sharePointVersion(SharePointVersion sharePointVersion) {
            this.sharePointVersion(sharePointVersion == null ? null : sharePointVersion.toString());
            return this;
        }

        public final Collection<String> getUrls() {
            if (urls instanceof SdkAutoConstructList) {
                return null;
            }
            return urls;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = SharePointUrlListCopier.copy(urls);
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = SharePointUrlListCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String... urls) {
            urls(Arrays.asList(urls));
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Boolean getCrawlAttachments() {
            return crawlAttachments;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final Boolean getUseChangeLog() {
            return useChangeLog;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String... inclusionPatterns) {
            inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String... exclusionPatterns) {
            exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier
                    .copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDocumentTitleFieldName() {
            return documentTitleFieldName;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        @Override
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final Boolean getDisableLocalGroups() {
            return disableLocalGroups;
        }

        public final void setDisableLocalGroups(Boolean disableLocalGroups) {
            this.disableLocalGroups = disableLocalGroups;
        }

        @Override
        public final Builder disableLocalGroups(Boolean disableLocalGroups) {
            this.disableLocalGroups = disableLocalGroups;
            return this;
        }

        public final S3Path.Builder getSslCertificateS3Path() {
            return sslCertificateS3Path != null ? sslCertificateS3Path.toBuilder() : null;
        }

        public final void setSslCertificateS3Path(S3Path.BuilderImpl sslCertificateS3Path) {
            this.sslCertificateS3Path = sslCertificateS3Path != null ? sslCertificateS3Path.build() : null;
        }

        @Override
        public final Builder sslCertificateS3Path(S3Path sslCertificateS3Path) {
            this.sslCertificateS3Path = sslCertificateS3Path;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(SharePointOnlineAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final ProxyConfiguration.Builder getProxyConfiguration() {
            return proxyConfiguration != null ? proxyConfiguration.toBuilder() : null;
        }

        public final void setProxyConfiguration(ProxyConfiguration.BuilderImpl proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration != null ? proxyConfiguration.build() : null;
        }

        @Override
        public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        @Override
        public SharePointConfiguration build() {
            return new SharePointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
