/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The document ID and its fields/attributes that are used for a query suggestion, if document fields set to use for
 * query suggestions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDocument implements SdkPojo, Serializable, ToCopyableBuilder<SourceDocument.Builder, SourceDocument> {
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(SourceDocument::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()).build();

    private static final SdkField<List<String>> SUGGESTION_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SuggestionAttributes")
            .getter(getter(SourceDocument::suggestionAttributes))
            .setter(setter(Builder::suggestionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DocumentAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<List<DocumentAttribute>> builder(MarshallingType.LIST)
            .memberName("AdditionalAttributes")
            .getter(getter(SourceDocument::additionalAttributes))
            .setter(setter(Builder::additionalAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ID_FIELD,
            SUGGESTION_ATTRIBUTES_FIELD, ADDITIONAL_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String documentId;

    private final List<String> suggestionAttributes;

    private final List<DocumentAttribute> additionalAttributes;

    private SourceDocument(BuilderImpl builder) {
        this.documentId = builder.documentId;
        this.suggestionAttributes = builder.suggestionAttributes;
        this.additionalAttributes = builder.additionalAttributes;
    }

    /**
     * <p>
     * The identifier of the document used for a query suggestion.
     * </p>
     * 
     * @return The identifier of the document used for a query suggestion.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestionAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestionAttributes() {
        return suggestionAttributes != null && !(suggestionAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The document fields/attributes used for a query suggestion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestionAttributes} method.
     * </p>
     * 
     * @return The document fields/attributes used for a query suggestion.
     */
    public final List<String> suggestionAttributes() {
        return suggestionAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalAttributes() {
        return additionalAttributes != null && !(additionalAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additional fields/attributes to include in the response. You can use additional fields to provide extra
     * information in the response. Additional fields are not used to based suggestions on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributes} method.
     * </p>
     * 
     * @return The additional fields/attributes to include in the response. You can use additional fields to provide
     *         extra information in the response. Additional fields are not used to based suggestions on.
     */
    public final List<DocumentAttribute> additionalAttributes() {
        return additionalAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestionAttributes() ? suggestionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAttributes() ? additionalAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDocument)) {
            return false;
        }
        SourceDocument other = (SourceDocument) obj;
        return Objects.equals(documentId(), other.documentId()) && hasSuggestionAttributes() == other.hasSuggestionAttributes()
                && Objects.equals(suggestionAttributes(), other.suggestionAttributes())
                && hasAdditionalAttributes() == other.hasAdditionalAttributes()
                && Objects.equals(additionalAttributes(), other.additionalAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDocument").add("DocumentId", documentId())
                .add("SuggestionAttributes", hasSuggestionAttributes() ? suggestionAttributes() : null)
                .add("AdditionalAttributes", hasAdditionalAttributes() ? additionalAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "SuggestionAttributes":
            return Optional.ofNullable(clazz.cast(suggestionAttributes()));
        case "AdditionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentId", DOCUMENT_ID_FIELD);
        map.put("SuggestionAttributes", SUGGESTION_ATTRIBUTES_FIELD);
        map.put("AdditionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDocument, T> g) {
        return obj -> g.apply((SourceDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDocument> {
        /**
         * <p>
         * The identifier of the document used for a query suggestion.
         * </p>
         * 
         * @param documentId
         *        The identifier of the document used for a query suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The document fields/attributes used for a query suggestion.
         * </p>
         * 
         * @param suggestionAttributes
         *        The document fields/attributes used for a query suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionAttributes(Collection<String> suggestionAttributes);

        /**
         * <p>
         * The document fields/attributes used for a query suggestion.
         * </p>
         * 
         * @param suggestionAttributes
         *        The document fields/attributes used for a query suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionAttributes(String... suggestionAttributes);

        /**
         * <p>
         * The additional fields/attributes to include in the response. You can use additional fields to provide extra
         * information in the response. Additional fields are not used to based suggestions on.
         * </p>
         * 
         * @param additionalAttributes
         *        The additional fields/attributes to include in the response. You can use additional fields to provide
         *        extra information in the response. Additional fields are not used to based suggestions on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(Collection<DocumentAttribute> additionalAttributes);

        /**
         * <p>
         * The additional fields/attributes to include in the response. You can use additional fields to provide extra
         * information in the response. Additional fields are not used to based suggestions on.
         * </p>
         * 
         * @param additionalAttributes
         *        The additional fields/attributes to include in the response. You can use additional fields to provide
         *        extra information in the response. Additional fields are not used to based suggestions on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(DocumentAttribute... additionalAttributes);

        /**
         * <p>
         * The additional fields/attributes to include in the response. You can use additional fields to provide extra
         * information in the response. Additional fields are not used to based suggestions on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder#build()} is called immediately
         * and its result is passed to {@link #additionalAttributes(List<DocumentAttribute>)}.
         * 
         * @param additionalAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAttributes(java.util.Collection<DocumentAttribute>)
         */
        Builder additionalAttributes(Consumer<DocumentAttribute.Builder>... additionalAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String documentId;

        private List<String> suggestionAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<DocumentAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDocument model) {
            documentId(model.documentId);
            suggestionAttributes(model.suggestionAttributes);
            additionalAttributes(model.additionalAttributes);
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final Collection<String> getSuggestionAttributes() {
            if (suggestionAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return suggestionAttributes;
        }

        public final void setSuggestionAttributes(Collection<String> suggestionAttributes) {
            this.suggestionAttributes = DocumentAttributeKeyListCopier.copy(suggestionAttributes);
        }

        @Override
        public final Builder suggestionAttributes(Collection<String> suggestionAttributes) {
            this.suggestionAttributes = DocumentAttributeKeyListCopier.copy(suggestionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionAttributes(String... suggestionAttributes) {
            suggestionAttributes(Arrays.asList(suggestionAttributes));
            return this;
        }

        public final List<DocumentAttribute.Builder> getAdditionalAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.additionalAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAttributes(Collection<DocumentAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = DocumentAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Collection<DocumentAttribute> additionalAttributes) {
            this.additionalAttributes = DocumentAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(DocumentAttribute... additionalAttributes) {
            additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<DocumentAttribute.Builder>... additionalAttributes) {
            additionalAttributes(Stream.of(additionalAttributes).map(c -> DocumentAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SourceDocument build() {
            return new SourceDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
