/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a table cell in a table excerpt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableCell implements SdkPojo, Serializable, ToCopyableBuilder<TableCell.Builder, TableCell> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(TableCell::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Boolean> TOP_ANSWER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TopAnswer").getter(getter(TableCell::topAnswer)).setter(setter(Builder::topAnswer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopAnswer").build()).build();

    private static final SdkField<Boolean> HIGHLIGHTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Highlighted").getter(getter(TableCell::highlighted)).setter(setter(Builder::highlighted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlighted").build()).build();

    private static final SdkField<Boolean> HEADER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Header").getter(getter(TableCell::header)).setter(setter(Builder::header))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TOP_ANSWER_FIELD,
            HIGHLIGHTED_FIELD, HEADER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final Boolean topAnswer;

    private final Boolean highlighted;

    private final Boolean header;

    private TableCell(BuilderImpl builder) {
        this.value = builder.value;
        this.topAnswer = builder.topAnswer;
        this.highlighted = builder.highlighted;
        this.header = builder.header;
    }

    /**
     * <p>
     * The actual value or content within a table cell. A table cell could contain a date value of a year, or a string
     * value of text, for example.
     * </p>
     * 
     * @return The actual value or content within a table cell. A table cell could contain a date value of a year, or a
     *         string value of text, for example.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * <code>TRUE</code> if the response of the table cell is the top answer. This is the cell value or content with the
     * highest confidence score or is the most relevant to the query.
     * </p>
     * 
     * @return <code>TRUE</code> if the response of the table cell is the top answer. This is the cell value or content
     *         with the highest confidence score or is the most relevant to the query.
     */
    public final Boolean topAnswer() {
        return topAnswer;
    }

    /**
     * <p>
     * <code>TRUE</code> means that the table cell has a high enough confidence and is relevant to the query, so the
     * value or content should be highlighted.
     * </p>
     * 
     * @return <code>TRUE</code> means that the table cell has a high enough confidence and is relevant to the query, so
     *         the value or content should be highlighted.
     */
    public final Boolean highlighted() {
        return highlighted;
    }

    /**
     * <p>
     * <code>TRUE</code> means that the table cell should be treated as a header.
     * </p>
     * 
     * @return <code>TRUE</code> means that the table cell should be treated as a header.
     */
    public final Boolean header() {
        return header;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(topAnswer());
        hashCode = 31 * hashCode + Objects.hashCode(highlighted());
        hashCode = 31 * hashCode + Objects.hashCode(header());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableCell)) {
            return false;
        }
        TableCell other = (TableCell) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(topAnswer(), other.topAnswer())
                && Objects.equals(highlighted(), other.highlighted()) && Objects.equals(header(), other.header());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableCell").add("Value", value()).add("TopAnswer", topAnswer())
                .add("Highlighted", highlighted()).add("Header", header()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "TopAnswer":
            return Optional.ofNullable(clazz.cast(topAnswer()));
        case "Highlighted":
            return Optional.ofNullable(clazz.cast(highlighted()));
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("TopAnswer", TOP_ANSWER_FIELD);
        map.put("Highlighted", HIGHLIGHTED_FIELD);
        map.put("Header", HEADER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableCell, T> g) {
        return obj -> g.apply((TableCell) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableCell> {
        /**
         * <p>
         * The actual value or content within a table cell. A table cell could contain a date value of a year, or a
         * string value of text, for example.
         * </p>
         * 
         * @param value
         *        The actual value or content within a table cell. A table cell could contain a date value of a year, or
         *        a string value of text, for example.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * <code>TRUE</code> if the response of the table cell is the top answer. This is the cell value or content with
         * the highest confidence score or is the most relevant to the query.
         * </p>
         * 
         * @param topAnswer
         *        <code>TRUE</code> if the response of the table cell is the top answer. This is the cell value or
         *        content with the highest confidence score or is the most relevant to the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topAnswer(Boolean topAnswer);

        /**
         * <p>
         * <code>TRUE</code> means that the table cell has a high enough confidence and is relevant to the query, so the
         * value or content should be highlighted.
         * </p>
         * 
         * @param highlighted
         *        <code>TRUE</code> means that the table cell has a high enough confidence and is relevant to the query,
         *        so the value or content should be highlighted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlighted(Boolean highlighted);

        /**
         * <p>
         * <code>TRUE</code> means that the table cell should be treated as a header.
         * </p>
         * 
         * @param header
         *        <code>TRUE</code> means that the table cell should be treated as a header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(Boolean header);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private Boolean topAnswer;

        private Boolean highlighted;

        private Boolean header;

        private BuilderImpl() {
        }

        private BuilderImpl(TableCell model) {
            value(model.value);
            topAnswer(model.topAnswer);
            highlighted(model.highlighted);
            header(model.header);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getTopAnswer() {
            return topAnswer;
        }

        public final void setTopAnswer(Boolean topAnswer) {
            this.topAnswer = topAnswer;
        }

        @Override
        public final Builder topAnswer(Boolean topAnswer) {
            this.topAnswer = topAnswer;
            return this;
        }

        public final Boolean getHighlighted() {
            return highlighted;
        }

        public final void setHighlighted(Boolean highlighted) {
            this.highlighted = highlighted;
        }

        @Override
        public final Builder highlighted(Boolean highlighted) {
            this.highlighted = highlighted;
            return this;
        }

        public final Boolean getHeader() {
            return header;
        }

        public final void setHeader(Boolean header) {
            this.header = header;
        }

        @Override
        public final Builder header(Boolean header) {
            this.header = header;
            return this;
        }

        @Override
        public TableCell build() {
            return new TableCell(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
