/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a template for the configuration information to connect to your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateConfiguration.Builder, TemplateConfiguration> {
    private static final SdkField<Document> TEMPLATE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("Template").getter(getter(TemplateConfiguration::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Template").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Document template;

    private TemplateConfiguration(BuilderImpl builder) {
        this.template = builder.template;
    }

    /**
     * <p>
     * The template schema used for the data source, where templates schemas are supported.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/kendra/latest/dg/ds-schemas.html">Data source template schemas</a>.
     * </p>
     * 
     * @return The template schema used for the data source, where templates schemas are supported.</p>
     *         <p>
     *         See <a href="https://docs.aws.amazon.com/kendra/latest/dg/ds-schemas.html">Data source template
     *         schemas</a>.
     */
    public final Document template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateConfiguration)) {
            return false;
        }
        TemplateConfiguration other = (TemplateConfiguration) obj;
        return Objects.equals(template(), other.template());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateConfiguration").add("Template", template()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Template":
            return Optional.ofNullable(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Template", TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateConfiguration, T> g) {
        return obj -> g.apply((TemplateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateConfiguration> {
        /**
         * <p>
         * The template schema used for the data source, where templates schemas are supported.
         * </p>
         * <p>
         * See <a href="https://docs.aws.amazon.com/kendra/latest/dg/ds-schemas.html">Data source template schemas</a>.
         * </p>
         * 
         * @param template
         *        The template schema used for the data source, where templates schemas are supported.</p>
         *        <p>
         *        See <a href="https://docs.aws.amazon.com/kendra/latest/dg/ds-schemas.html">Data source template
         *        schemas</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(Document template);
    }

    static final class BuilderImpl implements Builder {
        private Document template;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateConfiguration model) {
            template(model.template);
        }

        public final Document getTemplate() {
            return template;
        }

        public final void setTemplate(Document template) {
            this.template = template;
        }

        @Override
        public final Builder template(Document template) {
            this.template = template;
            return this;
        }

        @Override
        public TemplateConfiguration build() {
            return new TemplateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
