/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccessControlConfigurationRequest extends KendraRequest implements
        ToCopyableBuilder<UpdateAccessControlConfigurationRequest.Builder, UpdateAccessControlConfigurationRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(UpdateAccessControlConfigurationRequest::indexId))
            .setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateAccessControlConfigurationRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAccessControlConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAccessControlConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Principal>> ACCESS_CONTROL_LIST_FIELD = SdkField
            .<List<Principal>> builder(MarshallingType.LIST)
            .memberName("AccessControlList")
            .getter(getter(UpdateAccessControlConfigurationRequest::accessControlList))
            .setter(setter(Builder::accessControlList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Principal> builder(MarshallingType.SDK_POJO)
                                            .constructor(Principal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HierarchicalPrincipal>> HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD = SdkField
            .<List<HierarchicalPrincipal>> builder(MarshallingType.LIST)
            .memberName("HierarchicalAccessControlList")
            .getter(getter(UpdateAccessControlConfigurationRequest::hierarchicalAccessControlList))
            .setter(setter(Builder::hierarchicalAccessControlList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchicalAccessControlList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HierarchicalPrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(HierarchicalPrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ACCESS_CONTROL_LIST_FIELD, HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexId;

    private final String id;

    private final String name;

    private final String description;

    private final List<Principal> accessControlList;

    private final List<HierarchicalPrincipal> hierarchicalAccessControlList;

    private UpdateAccessControlConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.accessControlList = builder.accessControlList;
        this.hierarchicalAccessControlList = builder.hierarchicalAccessControlList;
    }

    /**
     * <p>
     * The identifier of the index for an access control configuration.
     * </p>
     * 
     * @return The identifier of the index for an access control configuration.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the access control configuration you want to update.
     * </p>
     * 
     * @return The identifier of the access control configuration you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A new name for the access control configuration.
     * </p>
     * 
     * @return A new name for the access control configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A new description for the access control configuration.
     * </p>
     * 
     * @return A new description for the access control configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessControlList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessControlList() {
        return accessControlList != null && !(accessControlList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information you want to update on principals (users and/or groups) and which documents they should have access
     * to. This is useful for user context filtering, where search results are filtered based on the user or their group
     * access to documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessControlList} method.
     * </p>
     * 
     * @return Information you want to update on principals (users and/or groups) and which documents they should have
     *         access to. This is useful for user context filtering, where search results are filtered based on the user
     *         or their group access to documents.
     */
    public final List<Principal> accessControlList() {
        return accessControlList;
    }

    /**
     * For responses, this returns true if the service returned a value for the HierarchicalAccessControlList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHierarchicalAccessControlList() {
        return hierarchicalAccessControlList != null && !(hierarchicalAccessControlList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
     * that define the hierarchy for which documents users should have access to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHierarchicalAccessControlList} method.
     * </p>
     * 
     * @return The updated list of <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define
     *         the hierarchy for which documents users should have access to.
     */
    public final List<HierarchicalPrincipal> hierarchicalAccessControlList() {
        return hierarchicalAccessControlList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessControlList() ? accessControlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHierarchicalAccessControlList() ? hierarchicalAccessControlList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessControlConfigurationRequest)) {
            return false;
        }
        UpdateAccessControlConfigurationRequest other = (UpdateAccessControlConfigurationRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasAccessControlList() == other.hasAccessControlList()
                && Objects.equals(accessControlList(), other.accessControlList())
                && hasHierarchicalAccessControlList() == other.hasHierarchicalAccessControlList()
                && Objects.equals(hierarchicalAccessControlList(), other.hierarchicalAccessControlList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateAccessControlConfigurationRequest")
                .add("IndexId", indexId())
                .add("Id", id())
                .add("Name", name())
                .add("Description", description())
                .add("AccessControlList", hasAccessControlList() ? accessControlList() : null)
                .add("HierarchicalAccessControlList", hasHierarchicalAccessControlList() ? hierarchicalAccessControlList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AccessControlList":
            return Optional.ofNullable(clazz.cast(accessControlList()));
        case "HierarchicalAccessControlList":
            return Optional.ofNullable(clazz.cast(hierarchicalAccessControlList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AccessControlList", ACCESS_CONTROL_LIST_FIELD);
        map.put("HierarchicalAccessControlList", HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessControlConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateAccessControlConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccessControlConfigurationRequest> {
        /**
         * <p>
         * The identifier of the index for an access control configuration.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for an access control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the access control configuration you want to update.
         * </p>
         * 
         * @param id
         *        The identifier of the access control configuration you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A new name for the access control configuration.
         * </p>
         * 
         * @param name
         *        A new name for the access control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A new description for the access control configuration.
         * </p>
         * 
         * @param description
         *        A new description for the access control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information you want to update on principals (users and/or groups) and which documents they should have
         * access to. This is useful for user context filtering, where search results are filtered based on the user or
         * their group access to documents.
         * </p>
         * 
         * @param accessControlList
         *        Information you want to update on principals (users and/or groups) and which documents they should
         *        have access to. This is useful for user context filtering, where search results are filtered based on
         *        the user or their group access to documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlList(Collection<Principal> accessControlList);

        /**
         * <p>
         * Information you want to update on principals (users and/or groups) and which documents they should have
         * access to. This is useful for user context filtering, where search results are filtered based on the user or
         * their group access to documents.
         * </p>
         * 
         * @param accessControlList
         *        Information you want to update on principals (users and/or groups) and which documents they should
         *        have access to. This is useful for user context filtering, where search results are filtered based on
         *        the user or their group access to documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlList(Principal... accessControlList);

        /**
         * <p>
         * Information you want to update on principals (users and/or groups) and which documents they should have
         * access to. This is useful for user context filtering, where search results are filtered based on the user or
         * their group access to documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.Principal.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.Principal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.Principal.Builder#build()} is called immediately and its
         * result is passed to {@link #accessControlList(List<Principal>)}.
         * 
         * @param accessControlList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.Principal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlList(java.util.Collection<Principal>)
         */
        Builder accessControlList(Consumer<Principal.Builder>... accessControlList);

        /**
         * <p>
         * The updated list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a>
         * lists that define the hierarchy for which documents users should have access to.
         * </p>
         * 
         * @param hierarchicalAccessControlList
         *        The updated list of <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define
         *        the hierarchy for which documents users should have access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList);

        /**
         * <p>
         * The updated list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a>
         * lists that define the hierarchy for which documents users should have access to.
         * </p>
         * 
         * @param hierarchicalAccessControlList
         *        The updated list of <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define
         *        the hierarchy for which documents users should have access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchicalAccessControlList(HierarchicalPrincipal... hierarchicalAccessControlList);

        /**
         * <p>
         * The updated list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a>
         * lists that define the hierarchy for which documents users should have access to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #hierarchicalAccessControlList(List<HierarchicalPrincipal>)}.
         * 
         * @param hierarchicalAccessControlList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchicalAccessControlList(java.util.Collection<HierarchicalPrincipal>)
         */
        Builder hierarchicalAccessControlList(Consumer<HierarchicalPrincipal.Builder>... hierarchicalAccessControlList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String id;

        private String name;

        private String description;

        private List<Principal> accessControlList = DefaultSdkAutoConstructList.getInstance();

        private List<HierarchicalPrincipal> hierarchicalAccessControlList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessControlConfigurationRequest model) {
            super(model);
            indexId(model.indexId);
            id(model.id);
            name(model.name);
            description(model.description);
            accessControlList(model.accessControlList);
            hierarchicalAccessControlList(model.hierarchicalAccessControlList);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Principal.Builder> getAccessControlList() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.accessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlList(Collection<Principal.BuilderImpl> accessControlList) {
            this.accessControlList = PrincipalListCopier.copyFromBuilder(accessControlList);
        }

        @Override
        public final Builder accessControlList(Collection<Principal> accessControlList) {
            this.accessControlList = PrincipalListCopier.copy(accessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Principal... accessControlList) {
            accessControlList(Arrays.asList(accessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Consumer<Principal.Builder>... accessControlList) {
            accessControlList(Stream.of(accessControlList).map(c -> Principal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<HierarchicalPrincipal.Builder> getHierarchicalAccessControlList() {
            List<HierarchicalPrincipal.Builder> result = HierarchicalPrincipalListCopier
                    .copyToBuilder(this.hierarchicalAccessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchicalAccessControlList(
                Collection<HierarchicalPrincipal.BuilderImpl> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copyFromBuilder(hierarchicalAccessControlList);
        }

        @Override
        public final Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copy(hierarchicalAccessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(HierarchicalPrincipal... hierarchicalAccessControlList) {
            hierarchicalAccessControlList(Arrays.asList(hierarchicalAccessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(
                Consumer<HierarchicalPrincipal.Builder>... hierarchicalAccessControlList) {
            hierarchicalAccessControlList(Stream.of(hierarchicalAccessControlList)
                    .map(c -> HierarchicalPrincipal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessControlConfigurationRequest build() {
            return new UpdateAccessControlConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
