/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExperienceRequest extends KendraRequest implements
        ToCopyableBuilder<UpdateExperienceRequest.Builder, UpdateExperienceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateExperienceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateExperienceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(UpdateExperienceRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateExperienceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<ExperienceConfiguration> CONFIGURATION_FIELD = SdkField
            .<ExperienceConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(UpdateExperienceRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ExperienceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateExperienceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            INDEX_ID_FIELD, ROLE_ARN_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String indexId;

    private final String roleArn;

    private final ExperienceConfiguration configuration;

    private final String description;

    private UpdateExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
        this.configuration = builder.configuration;
        this.description = builder.description;
    }

    /**
     * <p>
     * The identifier of your Amazon Kendra experience you want to update.
     * </p>
     * 
     * @return The identifier of your Amazon Kendra experience you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A new name for your Amazon Kendra experience.
     * </p>
     * 
     * @return A new name for your Amazon Kendra experience.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the index for your Amazon Kendra experience.
     * </p>
     * 
     * @return The identifier of the index for your Amazon Kendra experience.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the <code>Query</code> API,
     * <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that stores your
     * users and groups information. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to access the <code>Query</code> API,
     *         <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that stores
     *         your users and groups information. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Configuration information you want to update for your Amazon Kendra experience.
     * </p>
     * 
     * @return Configuration information you want to update for your Amazon Kendra experience.
     */
    public final ExperienceConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * A new description for your Amazon Kendra experience.
     * </p>
     * 
     * @return A new description for your Amazon Kendra experience.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperienceRequest)) {
            return false;
        }
        UpdateExperienceRequest other = (UpdateExperienceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(indexId(), other.indexId()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExperienceRequest").add("Id", id()).add("Name", name()).add("IndexId", indexId())
                .add("RoleArn", roleArn()).add("Configuration", configuration()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExperienceRequest, T> g) {
        return obj -> g.apply((UpdateExperienceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateExperienceRequest> {
        /**
         * <p>
         * The identifier of your Amazon Kendra experience you want to update.
         * </p>
         * 
         * @param id
         *        The identifier of your Amazon Kendra experience you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A new name for your Amazon Kendra experience.
         * </p>
         * 
         * @param name
         *        A new name for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the index for your Amazon Kendra experience.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the <code>Query</code> API,
         * <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that stores your
         * users and groups information. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to access the <code>Query</code> API,
         *        <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that
         *        stores your users and groups information. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Configuration information you want to update for your Amazon Kendra experience.
         * </p>
         * 
         * @param configuration
         *        Configuration information you want to update for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ExperienceConfiguration configuration);

        /**
         * <p>
         * Configuration information you want to update for your Amazon Kendra experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperienceConfiguration.Builder} avoiding
         * the need to create one manually via {@link ExperienceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperienceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(ExperienceConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ExperienceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ExperienceConfiguration)
         */
        default Builder configuration(Consumer<ExperienceConfiguration.Builder> configuration) {
            return configuration(ExperienceConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * A new description for your Amazon Kendra experience.
         * </p>
         * 
         * @param description
         *        A new description for your Amazon Kendra experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String indexId;

        private String roleArn;

        private ExperienceConfiguration configuration;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExperienceRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            indexId(model.indexId);
            roleArn(model.roleArn);
            configuration(model.configuration);
            description(model.description);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ExperienceConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ExperienceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ExperienceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExperienceRequest build() {
            return new UpdateExperienceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
