/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for the identifiers of your users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserIdentityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UserIdentityConfiguration.Builder, UserIdentityConfiguration> {
    private static final SdkField<String> IDENTITY_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityAttributeName").getter(getter(UserIdentityConfiguration::identityAttributeName))
            .setter(setter(Builder::identityAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IDENTITY_ATTRIBUTE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identityAttributeName;

    private UserIdentityConfiguration(BuilderImpl builder) {
        this.identityAttributeName = builder.identityAttributeName;
    }

    /**
     * <p>
     * The IAM Identity Center field name that contains the identifiers of your users, such as their emails. This is
     * used for <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">user context
     * filtering</a> and for granting access to your Amazon Kendra experience. You must set up IAM Identity Center with
     * Amazon Kendra. You must include your users and groups in your Access Control List when you ingest documents into
     * your index. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started with an IAM
     * Identity Center identity source</a>.
     * </p>
     * 
     * @return The IAM Identity Center field name that contains the identifiers of your users, such as their emails.
     *         This is used for <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">user
     *         context filtering</a> and for granting access to your Amazon Kendra experience. You must set up IAM
     *         Identity Center with Amazon Kendra. You must include your users and groups in your Access Control List
     *         when you ingest documents into your index. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started with an
     *         IAM Identity Center identity source</a>.
     */
    public final String identityAttributeName() {
        return identityAttributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityAttributeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentityConfiguration)) {
            return false;
        }
        UserIdentityConfiguration other = (UserIdentityConfiguration) obj;
        return Objects.equals(identityAttributeName(), other.identityAttributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserIdentityConfiguration").add("IdentityAttributeName", identityAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityAttributeName":
            return Optional.ofNullable(clazz.cast(identityAttributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityAttributeName", IDENTITY_ATTRIBUTE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserIdentityConfiguration, T> g) {
        return obj -> g.apply((UserIdentityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserIdentityConfiguration> {
        /**
         * <p>
         * The IAM Identity Center field name that contains the identifiers of your users, such as their emails. This is
         * used for <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">user context
         * filtering</a> and for granting access to your Amazon Kendra experience. You must set up IAM Identity Center
         * with Amazon Kendra. You must include your users and groups in your Access Control List when you ingest
         * documents into your index. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started with an IAM
         * Identity Center identity source</a>.
         * </p>
         * 
         * @param identityAttributeName
         *        The IAM Identity Center field name that contains the identifiers of your users, such as their emails.
         *        This is used for <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">user
         *        context filtering</a> and for granting access to your Amazon Kendra experience. You must set up IAM
         *        Identity Center with Amazon Kendra. You must include your users and groups in your Access Control List
         *        when you ingest documents into your index. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started with
         *        an IAM Identity Center identity source</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeName(String identityAttributeName);
    }

    static final class BuilderImpl implements Builder {
        private String identityAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentityConfiguration model) {
            identityAttributeName(model.identityAttributeName);
        }

        public final String getIdentityAttributeName() {
            return identityAttributeName;
        }

        public final void setIdentityAttributeName(String identityAttributeName) {
            this.identityAttributeName = identityAttributeName;
        }

        @Override
        public final Builder identityAttributeName(String identityAttributeName) {
            this.identityAttributeName = identityAttributeName;
            return this;
        }

        @Override
        public UserIdentityConfiguration build() {
            return new UserIdentityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
