/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.FaqFileFormat;
import software.amazon.awssdk.services.kendra.model.FaqStatus;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.S3Path;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFaqResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, DescribeFaqResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeFaqResponse.getter(DescribeFaqResponse::id)).setter(DescribeFaqResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(DescribeFaqResponse.getter(DescribeFaqResponse::indexId)).setter(DescribeFaqResponse.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeFaqResponse.getter(DescribeFaqResponse::name)).setter(DescribeFaqResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeFaqResponse.getter(DescribeFaqResponse::description)).setter(DescribeFaqResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeFaqResponse.getter(DescribeFaqResponse::createdAt)).setter(DescribeFaqResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DescribeFaqResponse.getter(DescribeFaqResponse::updatedAt)).setter(DescribeFaqResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<S3Path> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Path").getter(DescribeFaqResponse.getter(DescribeFaqResponse::s3Path)).setter(DescribeFaqResponse.setter(Builder::s3Path)).constructor(S3Path::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeFaqResponse.getter(DescribeFaqResponse::statusAsString)).setter(DescribeFaqResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeFaqResponse.getter(DescribeFaqResponse::roleArn)).setter(DescribeFaqResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(DescribeFaqResponse.getter(DescribeFaqResponse::errorMessage)).setter(DescribeFaqResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileFormat").getter(DescribeFaqResponse.getter(DescribeFaqResponse::fileFormatAsString)).setter(DescribeFaqResponse.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormat").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(DescribeFaqResponse.getter(DescribeFaqResponse::languageCode)).setter(DescribeFaqResponse.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, S3_PATH_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, ERROR_MESSAGE_FIELD, FILE_FORMAT_FIELD, LANGUAGE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFaqResponse.memberNameToFieldInitializer();
    private final String id;
    private final String indexId;
    private final String name;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final S3Path s3Path;
    private final String status;
    private final String roleArn;
    private final String errorMessage;
    private final String fileFormat;
    private final String languageCode;

    private DescribeFaqResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.s3Path = builder.s3Path;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.errorMessage = builder.errorMessage;
        this.fileFormat = builder.fileFormat;
        this.languageCode = builder.languageCode;
    }

    public final String id() {
        return this.id;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final S3Path s3Path() {
        return this.s3Path;
    }

    public final FaqStatus status() {
        return FaqStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final FaqFileFormat fileFormat() {
        return FaqFileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final String languageCode() {
        return this.languageCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFaqResponse)) {
            return false;
        }
        DescribeFaqResponse other = (DescribeFaqResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.s3Path(), other.s3Path()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.languageCode(), other.languageCode());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFaqResponse").add("Id", (Object)this.id()).add("IndexId", (Object)this.indexId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("S3Path", (Object)this.s3Path()).add("Status", (Object)this.statusAsString()).add("RoleArn", (Object)this.roleArn()).add("ErrorMessage", (Object)this.errorMessage()).add("FileFormat", (Object)this.fileFormatAsString()).add("LanguageCode", (Object)this.languageCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "S3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "FileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("S3Path", S3_PATH_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("FileFormat", FILE_FORMAT_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFaqResponse, T> g) {
        return obj -> g.apply((DescribeFaqResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String id;
        private String indexId;
        private String name;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private S3Path s3Path;
        private String status;
        private String roleArn;
        private String errorMessage;
        private String fileFormat;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFaqResponse model) {
            super(model);
            this.id(model.id);
            this.indexId(model.indexId);
            this.name(model.name);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.s3Path(model.s3Path);
            this.status(model.status);
            this.roleArn(model.roleArn);
            this.errorMessage(model.errorMessage);
            this.fileFormat(model.fileFormat);
            this.languageCode(model.languageCode);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final S3Path.Builder getS3Path() {
            return this.s3Path != null ? this.s3Path.toBuilder() : null;
        }

        public final void setS3Path(S3Path.BuilderImpl s3Path) {
            this.s3Path = s3Path != null ? s3Path.build() : null;
        }

        @Override
        public final Builder s3Path(S3Path s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FaqStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FaqFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public DescribeFaqResponse build() {
            return new DescribeFaqResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFaqResponse> {
        public Builder id(String var1);

        public Builder indexId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder s3Path(S3Path var1);

        default public Builder s3Path(Consumer<S3Path.Builder> s3Path) {
            return this.s3Path((S3Path)((S3Path.Builder)S3Path.builder().applyMutation(s3Path)).build());
        }

        public Builder status(String var1);

        public Builder status(FaqStatus var1);

        public Builder roleArn(String var1);

        public Builder errorMessage(String var1);

        public Builder fileFormat(String var1);

        public Builder fileFormat(FaqFileFormat var1);

        public Builder languageCode(String var1);
    }
}

