/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AttributeFilter;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeKeyListCopier;
import software.amazon.awssdk.services.kendra.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeSuggestionsGetConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeSuggestionsGetConfig> {
    private static final SdkField<List<String>> SUGGESTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuggestionAttributes").getter(AttributeSuggestionsGetConfig.getter(AttributeSuggestionsGetConfig::suggestionAttributes)).setter(AttributeSuggestionsGetConfig.setter(Builder::suggestionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_RESPONSE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalResponseAttributes").getter(AttributeSuggestionsGetConfig.getter(AttributeSuggestionsGetConfig::additionalResponseAttributes)).setter(AttributeSuggestionsGetConfig.setter(Builder::additionalResponseAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalResponseAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeFilter").getter(AttributeSuggestionsGetConfig.getter(AttributeSuggestionsGetConfig::attributeFilter)).setter(AttributeSuggestionsGetConfig.setter(Builder::attributeFilter)).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilter").build()}).build();
    private static final SdkField<UserContext> USER_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserContext").getter(AttributeSuggestionsGetConfig.getter(AttributeSuggestionsGetConfig::userContext)).setter(AttributeSuggestionsGetConfig.setter(Builder::userContext)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTION_ATTRIBUTES_FIELD, ADDITIONAL_RESPONSE_ATTRIBUTES_FIELD, ATTRIBUTE_FILTER_FIELD, USER_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeSuggestionsGetConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> suggestionAttributes;
    private final List<String> additionalResponseAttributes;
    private final AttributeFilter attributeFilter;
    private final UserContext userContext;

    private AttributeSuggestionsGetConfig(BuilderImpl builder) {
        this.suggestionAttributes = builder.suggestionAttributes;
        this.additionalResponseAttributes = builder.additionalResponseAttributes;
        this.attributeFilter = builder.attributeFilter;
        this.userContext = builder.userContext;
    }

    public final boolean hasSuggestionAttributes() {
        return this.suggestionAttributes != null && !(this.suggestionAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> suggestionAttributes() {
        return this.suggestionAttributes;
    }

    public final boolean hasAdditionalResponseAttributes() {
        return this.additionalResponseAttributes != null && !(this.additionalResponseAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> additionalResponseAttributes() {
        return this.additionalResponseAttributes;
    }

    public final AttributeFilter attributeFilter() {
        return this.attributeFilter;
    }

    public final UserContext userContext() {
        return this.userContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestionAttributes() ? this.suggestionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalResponseAttributes() ? this.additionalResponseAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.userContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeSuggestionsGetConfig)) {
            return false;
        }
        AttributeSuggestionsGetConfig other = (AttributeSuggestionsGetConfig)obj;
        return this.hasSuggestionAttributes() == other.hasSuggestionAttributes() && Objects.equals(this.suggestionAttributes(), other.suggestionAttributes()) && this.hasAdditionalResponseAttributes() == other.hasAdditionalResponseAttributes() && Objects.equals(this.additionalResponseAttributes(), other.additionalResponseAttributes()) && Objects.equals(this.attributeFilter(), other.attributeFilter()) && Objects.equals(this.userContext(), other.userContext());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeSuggestionsGetConfig").add("SuggestionAttributes", this.hasSuggestionAttributes() ? this.suggestionAttributes() : null).add("AdditionalResponseAttributes", this.hasAdditionalResponseAttributes() ? this.additionalResponseAttributes() : null).add("AttributeFilter", (Object)this.attributeFilter()).add("UserContext", (Object)this.userContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuggestionAttributes": {
                return Optional.ofNullable(clazz.cast(this.suggestionAttributes()));
            }
            case "AdditionalResponseAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalResponseAttributes()));
            }
            case "AttributeFilter": {
                return Optional.ofNullable(clazz.cast(this.attributeFilter()));
            }
            case "UserContext": {
                return Optional.ofNullable(clazz.cast(this.userContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SuggestionAttributes", SUGGESTION_ATTRIBUTES_FIELD);
        map.put("AdditionalResponseAttributes", ADDITIONAL_RESPONSE_ATTRIBUTES_FIELD);
        map.put("AttributeFilter", ATTRIBUTE_FILTER_FIELD);
        map.put("UserContext", USER_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeSuggestionsGetConfig, T> g) {
        return obj -> g.apply((AttributeSuggestionsGetConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> suggestionAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> additionalResponseAttributes = DefaultSdkAutoConstructList.getInstance();
        private AttributeFilter attributeFilter;
        private UserContext userContext;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeSuggestionsGetConfig model) {
            this.suggestionAttributes(model.suggestionAttributes);
            this.additionalResponseAttributes(model.additionalResponseAttributes);
            this.attributeFilter(model.attributeFilter);
            this.userContext(model.userContext);
        }

        public final Collection<String> getSuggestionAttributes() {
            if (this.suggestionAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suggestionAttributes;
        }

        public final void setSuggestionAttributes(Collection<String> suggestionAttributes) {
            this.suggestionAttributes = DocumentAttributeKeyListCopier.copy(suggestionAttributes);
        }

        @Override
        public final Builder suggestionAttributes(Collection<String> suggestionAttributes) {
            this.suggestionAttributes = DocumentAttributeKeyListCopier.copy(suggestionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionAttributes(String ... suggestionAttributes) {
            this.suggestionAttributes(Arrays.asList(suggestionAttributes));
            return this;
        }

        public final Collection<String> getAdditionalResponseAttributes() {
            if (this.additionalResponseAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalResponseAttributes;
        }

        public final void setAdditionalResponseAttributes(Collection<String> additionalResponseAttributes) {
            this.additionalResponseAttributes = DocumentAttributeKeyListCopier.copy(additionalResponseAttributes);
        }

        @Override
        public final Builder additionalResponseAttributes(Collection<String> additionalResponseAttributes) {
            this.additionalResponseAttributes = DocumentAttributeKeyListCopier.copy(additionalResponseAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResponseAttributes(String ... additionalResponseAttributes) {
            this.additionalResponseAttributes(Arrays.asList(additionalResponseAttributes));
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return this.attributeFilter != null ? this.attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final UserContext.Builder getUserContext() {
            return this.userContext != null ? this.userContext.toBuilder() : null;
        }

        public final void setUserContext(UserContext.BuilderImpl userContext) {
            this.userContext = userContext != null ? userContext.build() : null;
        }

        @Override
        public final Builder userContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        public AttributeSuggestionsGetConfig build() {
            return new AttributeSuggestionsGetConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeSuggestionsGetConfig> {
        public Builder suggestionAttributes(Collection<String> var1);

        public Builder suggestionAttributes(String ... var1);

        public Builder additionalResponseAttributes(Collection<String> var1);

        public Builder additionalResponseAttributes(String ... var1);

        public Builder attributeFilter(AttributeFilter var1);

        default public Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return this.attributeFilter((AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation(attributeFilter)).build());
        }

        public Builder userContext(UserContext var1);

        default public Builder userContext(Consumer<UserContext.Builder> userContext) {
            return this.userContext((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(userContext)).build());
        }
    }
}

