/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;

@SdkPublicApi
public final class KendraRankingEndpointParams {
    private final Region region;
    private final Boolean useFIPS;
    private final String endpoint;

    private KendraRankingEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return this.region;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    private static class BuilderImpl
    implements Builder {
        private Region region;
        private Boolean useFIPS = false;
        private String endpoint;

        private BuilderImpl() {
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public KendraRankingEndpointParams build() {
            return new KendraRankingEndpointParams(this);
        }
    }

    public static interface Builder {
        public Builder region(Region var1);

        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public KendraRankingEndpointParams build();
    }
}

