/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendraranking.KendraRankingClient;
import software.amazon.awssdk.services.kendraranking.internal.UserAgentUtils;
import software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest;
import software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansResponse;

public class ListRescoreExecutionPlansIterable
implements SdkIterable<ListRescoreExecutionPlansResponse> {
    private final KendraRankingClient client;
    private final ListRescoreExecutionPlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRescoreExecutionPlansIterable(KendraRankingClient client, ListRescoreExecutionPlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRescoreExecutionPlansResponseFetcher();
    }

    public Iterator<ListRescoreExecutionPlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRescoreExecutionPlansResponseFetcher
    implements SyncPageFetcher<ListRescoreExecutionPlansResponse> {
        private ListRescoreExecutionPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListRescoreExecutionPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRescoreExecutionPlansResponse nextPage(ListRescoreExecutionPlansResponse previousPage) {
            if (previousPage == null) {
                return ListRescoreExecutionPlansIterable.this.client.listRescoreExecutionPlans(ListRescoreExecutionPlansIterable.this.firstRequest);
            }
            return ListRescoreExecutionPlansIterable.this.client.listRescoreExecutionPlans((ListRescoreExecutionPlansRequest)((Object)ListRescoreExecutionPlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

