/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sets additional capacity units configured for your rescore execution plan. A rescore execution plan is an Amazon
 * Kendra Intelligent Ranking resource used for provisioning the <code>Rescore</code> API. You can add and remove
 * capacity units to fit your usage requirements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityUnitsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityUnitsConfiguration.Builder, CapacityUnitsConfiguration> {
    private static final SdkField<Integer> RESCORE_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RescoreCapacityUnits").getter(getter(CapacityUnitsConfiguration::rescoreCapacityUnits))
            .setter(setter(Builder::rescoreCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RescoreCapacityUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESCORE_CAPACITY_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer rescoreCapacityUnits;

    private CapacityUnitsConfiguration(BuilderImpl builder) {
        this.rescoreCapacityUnits = builder.rescoreCapacityUnits;
    }

    /**
     * <p>
     * The amount of extra capacity for your rescore execution plan.
     * </p>
     * <p>
     * A single extra capacity unit for a rescore execution plan provides 0.01 rescore requests per second. You can add
     * up to 1000 extra capacity units.
     * </p>
     * 
     * @return The amount of extra capacity for your rescore execution plan.</p>
     *         <p>
     *         A single extra capacity unit for a rescore execution plan provides 0.01 rescore requests per second. You
     *         can add up to 1000 extra capacity units.
     */
    public final Integer rescoreCapacityUnits() {
        return rescoreCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rescoreCapacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityUnitsConfiguration)) {
            return false;
        }
        CapacityUnitsConfiguration other = (CapacityUnitsConfiguration) obj;
        return Objects.equals(rescoreCapacityUnits(), other.rescoreCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityUnitsConfiguration").add("RescoreCapacityUnits", rescoreCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RescoreCapacityUnits":
            return Optional.ofNullable(clazz.cast(rescoreCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RescoreCapacityUnits", RESCORE_CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityUnitsConfiguration, T> g) {
        return obj -> g.apply((CapacityUnitsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityUnitsConfiguration> {
        /**
         * <p>
         * The amount of extra capacity for your rescore execution plan.
         * </p>
         * <p>
         * A single extra capacity unit for a rescore execution plan provides 0.01 rescore requests per second. You can
         * add up to 1000 extra capacity units.
         * </p>
         * 
         * @param rescoreCapacityUnits
         *        The amount of extra capacity for your rescore execution plan.</p>
         *        <p>
         *        A single extra capacity unit for a rescore execution plan provides 0.01 rescore requests per second.
         *        You can add up to 1000 extra capacity units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rescoreCapacityUnits(Integer rescoreCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private Integer rescoreCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityUnitsConfiguration model) {
            rescoreCapacityUnits(model.rescoreCapacityUnits);
        }

        public final Integer getRescoreCapacityUnits() {
            return rescoreCapacityUnits;
        }

        public final void setRescoreCapacityUnits(Integer rescoreCapacityUnits) {
            this.rescoreCapacityUnits = rescoreCapacityUnits;
        }

        @Override
        public final Builder rescoreCapacityUnits(Integer rescoreCapacityUnits) {
            this.rescoreCapacityUnits = rescoreCapacityUnits;
            return this;
        }

        @Override
        public CapacityUnitsConfiguration build() {
            return new CapacityUnitsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
