/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRescoreExecutionPlanRequest extends KendraRankingRequest implements
        ToCopyableBuilder<CreateRescoreExecutionPlanRequest.Builder, CreateRescoreExecutionPlanRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateRescoreExecutionPlanRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateRescoreExecutionPlanRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<CapacityUnitsConfiguration> CAPACITY_UNITS_FIELD = SdkField
            .<CapacityUnitsConfiguration> builder(MarshallingType.SDK_POJO).memberName("CapacityUnits")
            .getter(getter(CreateRescoreExecutionPlanRequest::capacityUnits)).setter(setter(Builder::capacityUnits))
            .constructor(CapacityUnitsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateRescoreExecutionPlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateRescoreExecutionPlanRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CAPACITY_UNITS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final CapacityUnitsConfiguration capacityUnits;

    private final List<Tag> tags;

    private final String clientToken;

    private CreateRescoreExecutionPlanRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.capacityUnits = builder.capacityUnits;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A name for the rescore execution plan.
     * </p>
     * 
     * @return A name for the rescore execution plan.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the rescore execution plan.
     * </p>
     * 
     * @return A description for the rescore execution plan.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * You can set additional capacity units to meet the needs of your rescore execution plan. You are given a single
     * capacity unit by default. If you want to use the default capacity, you don't set additional capacity units. For
     * more information on the default capacity and additional capacity units, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     * </p>
     * 
     * @return You can set additional capacity units to meet the needs of your rescore execution plan. You are given a
     *         single capacity unit by default. If you want to use the default capacity, you don't set additional
     *         capacity units. For more information on the default capacity and additional capacity units, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     */
    public final CapacityUnitsConfiguration capacityUnits() {
        return capacityUnits;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize your rescore execution plan. You can also use tags to help
     * control access to the rescore execution plan. Tag keys and values can consist of Unicode letters, digits, white
     * space, and any of the following symbols: _ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize your rescore execution plan. You can also use tags
     *         to help control access to the rescore execution plan. Tag keys and values can consist of Unicode letters,
     *         digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create a rescore execution plan. Multiple calls to the
     * <code>CreateRescoreExecutionPlanRequest</code> API with the same client token will create only one rescore
     * execution plan.
     * </p>
     * 
     * @return A token that you provide to identify the request to create a rescore execution plan. Multiple calls to
     *         the <code>CreateRescoreExecutionPlanRequest</code> API with the same client token will create only one
     *         rescore execution plan.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(capacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRescoreExecutionPlanRequest)) {
            return false;
        }
        CreateRescoreExecutionPlanRequest other = (CreateRescoreExecutionPlanRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(capacityUnits(), other.capacityUnits()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRescoreExecutionPlanRequest").add("Name", name()).add("Description", description())
                .add("CapacityUnits", capacityUnits()).add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CapacityUnits":
            return Optional.ofNullable(clazz.cast(capacityUnits()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CapacityUnits", CAPACITY_UNITS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRescoreExecutionPlanRequest, T> g) {
        return obj -> g.apply((CreateRescoreExecutionPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRankingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRescoreExecutionPlanRequest> {
        /**
         * <p>
         * A name for the rescore execution plan.
         * </p>
         * 
         * @param name
         *        A name for the rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the rescore execution plan.
         * </p>
         * 
         * @param description
         *        A description for the rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * You can set additional capacity units to meet the needs of your rescore execution plan. You are given a
         * single capacity unit by default. If you want to use the default capacity, you don't set additional capacity
         * units. For more information on the default capacity and additional capacity units, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * </p>
         * 
         * @param capacityUnits
         *        You can set additional capacity units to meet the needs of your rescore execution plan. You are given
         *        a single capacity unit by default. If you want to use the default capacity, you don't set additional
         *        capacity units. For more information on the default capacity and additional capacity units, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnits(CapacityUnitsConfiguration capacityUnits);

        /**
         * <p>
         * You can set additional capacity units to meet the needs of your rescore execution plan. You are given a
         * single capacity unit by default. If you want to use the default capacity, you don't set additional capacity
         * units. For more information on the default capacity and additional capacity units, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityUnitsConfiguration.Builder}
         * avoiding the need to create one manually via {@link CapacityUnitsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityUnitsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityUnits(CapacityUnitsConfiguration)}.
         * 
         * @param capacityUnits
         *        a consumer that will call methods on {@link CapacityUnitsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityUnits(CapacityUnitsConfiguration)
         */
        default Builder capacityUnits(Consumer<CapacityUnitsConfiguration.Builder> capacityUnits) {
            return capacityUnits(CapacityUnitsConfiguration.builder().applyMutation(capacityUnits).build());
        }

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your rescore execution plan. You can also use tags to
         * help control access to the rescore execution plan. Tag keys and values can consist of Unicode letters,
         * digits, white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize your rescore execution plan. You can also use
         *        tags to help control access to the rescore execution plan. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your rescore execution plan. You can also use tags to
         * help control access to the rescore execution plan. Tag keys and values can consist of Unicode letters,
         * digits, white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize your rescore execution plan. You can also use
         *        tags to help control access to the rescore execution plan. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your rescore execution plan. You can also use tags to
         * help control access to the rescore execution plan. Tag keys and values can consist of Unicode letters,
         * digits, white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendraranking.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendraranking.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendraranking.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendraranking.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A token that you provide to identify the request to create a rescore execution plan. Multiple calls to the
         * <code>CreateRescoreExecutionPlanRequest</code> API with the same client token will create only one rescore
         * execution plan.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create a rescore execution plan. Multiple calls to
         *        the <code>CreateRescoreExecutionPlanRequest</code> API with the same client token will create only one
         *        rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRankingRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private CapacityUnitsConfiguration capacityUnits;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRescoreExecutionPlanRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            capacityUnits(model.capacityUnits);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CapacityUnitsConfiguration.Builder getCapacityUnits() {
            return capacityUnits != null ? capacityUnits.toBuilder() : null;
        }

        public final void setCapacityUnits(CapacityUnitsConfiguration.BuilderImpl capacityUnits) {
            this.capacityUnits = capacityUnits != null ? capacityUnits.build() : null;
        }

        @Override
        public final Builder capacityUnits(CapacityUnitsConfiguration capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRescoreExecutionPlanRequest build() {
            return new CreateRescoreExecutionPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
