/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRescoreExecutionPlanResponse extends KendraRankingResponse implements
        ToCopyableBuilder<DescribeRescoreExecutionPlanResponse.Builder, DescribeRescoreExecutionPlanResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeRescoreExecutionPlanResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeRescoreExecutionPlanResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeRescoreExecutionPlanResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeRescoreExecutionPlanResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<CapacityUnitsConfiguration> CAPACITY_UNITS_FIELD = SdkField
            .<CapacityUnitsConfiguration> builder(MarshallingType.SDK_POJO).memberName("CapacityUnits")
            .getter(getter(DescribeRescoreExecutionPlanResponse::capacityUnits)).setter(setter(Builder::capacityUnits))
            .constructor(CapacityUnitsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeRescoreExecutionPlanResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeRescoreExecutionPlanResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeRescoreExecutionPlanResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeRescoreExecutionPlanResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, CAPACITY_UNITS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final CapacityUnitsConfiguration capacityUnits;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private final String errorMessage;

    private DescribeRescoreExecutionPlanResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.capacityUnits = builder.capacityUnits;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The identifier of the rescore execution plan.
     * </p>
     * 
     * @return The identifier of the rescore execution plan.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rescore execution plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rescore execution plan.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name for the rescore execution plan.
     * </p>
     * 
     * @return The name for the rescore execution plan.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the rescore execution plan.
     * </p>
     * 
     * @return The description for the rescore execution plan.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The capacity units set for the rescore execution plan. A capacity of zero indicates that the rescore execution
     * plan is using the default capacity. For more information on the default capacity and additional capacity units,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     * </p>
     * 
     * @return The capacity units set for the rescore execution plan. A capacity of zero indicates that the rescore
     *         execution plan is using the default capacity. For more information on the default capacity and additional
     *         capacity units, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     */
    public final CapacityUnitsConfiguration capacityUnits() {
        return capacityUnits;
    }

    /**
     * <p>
     * The Unix timestamp of when the rescore execution plan was created.
     * </p>
     * 
     * @return The Unix timestamp of when the rescore execution plan was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp of when the rescore execution plan was last updated.
     * </p>
     * 
     * @return The Unix timestamp of when the rescore execution plan was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current status of the rescore execution plan. When the value is <code>ACTIVE</code>, the rescore execution
     * plan is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the
     * <code>ErrorMessage</code> field contains a message that explains why.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RescoreExecutionPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the rescore execution plan. When the value is <code>ACTIVE</code>, the rescore
     *         execution plan is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the
     *         <code>ErrorMessage</code> field contains a message that explains why.
     * @see RescoreExecutionPlanStatus
     */
    public final RescoreExecutionPlanStatus status() {
        return RescoreExecutionPlanStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the rescore execution plan. When the value is <code>ACTIVE</code>, the rescore execution
     * plan is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the
     * <code>ErrorMessage</code> field contains a message that explains why.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RescoreExecutionPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the rescore execution plan. When the value is <code>ACTIVE</code>, the rescore
     *         execution plan is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the
     *         <code>ErrorMessage</code> field contains a message that explains why.
     * @see RescoreExecutionPlanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
     * message that explains why.
     * </p>
     * 
     * @return When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         contains a message that explains why.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(capacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRescoreExecutionPlanResponse)) {
            return false;
        }
        DescribeRescoreExecutionPlanResponse other = (DescribeRescoreExecutionPlanResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(capacityUnits(), other.capacityUnits())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRescoreExecutionPlanResponse").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("CapacityUnits", capacityUnits()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Status", statusAsString()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CapacityUnits":
            return Optional.ofNullable(clazz.cast(capacityUnits()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CapacityUnits", CAPACITY_UNITS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRescoreExecutionPlanResponse, T> g) {
        return obj -> g.apply((DescribeRescoreExecutionPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRankingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRescoreExecutionPlanResponse> {
        /**
         * <p>
         * The identifier of the rescore execution plan.
         * </p>
         * 
         * @param id
         *        The identifier of the rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rescore execution plan.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name for the rescore execution plan.
         * </p>
         * 
         * @param name
         *        The name for the rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the rescore execution plan.
         * </p>
         * 
         * @param description
         *        The description for the rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The capacity units set for the rescore execution plan. A capacity of zero indicates that the rescore
         * execution plan is using the default capacity. For more information on the default capacity and additional
         * capacity units, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting
         * capacity</a>.
         * </p>
         * 
         * @param capacityUnits
         *        The capacity units set for the rescore execution plan. A capacity of zero indicates that the rescore
         *        execution plan is using the default capacity. For more information on the default capacity and
         *        additional capacity units, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnits(CapacityUnitsConfiguration capacityUnits);

        /**
         * <p>
         * The capacity units set for the rescore execution plan. A capacity of zero indicates that the rescore
         * execution plan is using the default capacity. For more information on the default capacity and additional
         * capacity units, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting
         * capacity</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityUnitsConfiguration.Builder}
         * avoiding the need to create one manually via {@link CapacityUnitsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityUnitsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityUnits(CapacityUnitsConfiguration)}.
         * 
         * @param capacityUnits
         *        a consumer that will call methods on {@link CapacityUnitsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityUnits(CapacityUnitsConfiguration)
         */
        default Builder capacityUnits(Consumer<CapacityUnitsConfiguration.Builder> capacityUnits) {
            return capacityUnits(CapacityUnitsConfiguration.builder().applyMutation(capacityUnits).build());
        }

        /**
         * <p>
         * The Unix timestamp of when the rescore execution plan was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp of when the rescore execution plan was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp of when the rescore execution plan was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp of when the rescore execution plan was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current status of the rescore execution plan. When the value is <code>ACTIVE</code>, the rescore
         * execution plan is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the
         * <code>ErrorMessage</code> field contains a message that explains why.
         * </p>
         * 
         * @param status
         *        The current status of the rescore execution plan. When the value is <code>ACTIVE</code>, the rescore
         *        execution plan is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the
         *        <code>ErrorMessage</code> field contains a message that explains why.
         * @see RescoreExecutionPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RescoreExecutionPlanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the rescore execution plan. When the value is <code>ACTIVE</code>, the rescore
         * execution plan is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the
         * <code>ErrorMessage</code> field contains a message that explains why.
         * </p>
         * 
         * @param status
         *        The current status of the rescore execution plan. When the value is <code>ACTIVE</code>, the rescore
         *        execution plan is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the
         *        <code>ErrorMessage</code> field contains a message that explains why.
         * @see RescoreExecutionPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RescoreExecutionPlanStatus
         */
        Builder status(RescoreExecutionPlanStatus status);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a message that explains why.
         * </p>
         * 
         * @param errorMessage
         *        When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends KendraRankingResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private CapacityUnitsConfiguration capacityUnits;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRescoreExecutionPlanResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            capacityUnits(model.capacityUnits);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
            errorMessage(model.errorMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CapacityUnitsConfiguration.Builder getCapacityUnits() {
            return capacityUnits != null ? capacityUnits.toBuilder() : null;
        }

        public final void setCapacityUnits(CapacityUnitsConfiguration.BuilderImpl capacityUnits) {
            this.capacityUnits = capacityUnits != null ? capacityUnits.build() : null;
        }

        @Override
        public final Builder capacityUnits(CapacityUnitsConfiguration capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RescoreExecutionPlanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public DescribeRescoreExecutionPlanResponse build() {
            return new DescribeRescoreExecutionPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
