/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RescoreRequest extends KendraRankingRequest implements
        ToCopyableBuilder<RescoreRequest.Builder, RescoreRequest> {
    private static final SdkField<String> RESCORE_EXECUTION_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RescoreExecutionPlanId").getter(getter(RescoreRequest::rescoreExecutionPlanId))
            .setter(setter(Builder::rescoreExecutionPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RescoreExecutionPlanId").build())
            .build();

    private static final SdkField<String> SEARCH_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchQuery").getter(getter(RescoreRequest::searchQuery)).setter(setter(Builder::searchQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchQuery").build()).build();

    private static final SdkField<List<Document>> DOCUMENTS_FIELD = SdkField
            .<List<Document>> builder(MarshallingType.LIST)
            .memberName("Documents")
            .getter(getter(RescoreRequest::documents))
            .setter(setter(Builder::documents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.SDK_POJO)
                                            .constructor(Document::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESCORE_EXECUTION_PLAN_ID_FIELD, SEARCH_QUERY_FIELD, DOCUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String rescoreExecutionPlanId;

    private final String searchQuery;

    private final List<Document> documents;

    private RescoreRequest(BuilderImpl builder) {
        super(builder);
        this.rescoreExecutionPlanId = builder.rescoreExecutionPlanId;
        this.searchQuery = builder.searchQuery;
        this.documents = builder.documents;
    }

    /**
     * <p>
     * The identifier of the rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking
     * resource used for provisioning the <code>Rescore</code> API.
     * </p>
     * 
     * @return The identifier of the rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent
     *         Ranking resource used for provisioning the <code>Rescore</code> API.
     */
    public final String rescoreExecutionPlanId() {
        return rescoreExecutionPlanId;
    }

    /**
     * <p>
     * The input query from the search service.
     * </p>
     * 
     * @return The input query from the search service.
     */
    public final String searchQuery() {
        return searchQuery;
    }

    /**
     * For responses, this returns true if the service returned a value for the Documents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDocuments() {
        return documents != null && !(documents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of documents for Amazon Kendra Intelligent Ranking to rescore or rank on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocuments} method.
     * </p>
     * 
     * @return The list of documents for Amazon Kendra Intelligent Ranking to rescore or rank on.
     */
    public final List<Document> documents() {
        return documents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rescoreExecutionPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(searchQuery());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocuments() ? documents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RescoreRequest)) {
            return false;
        }
        RescoreRequest other = (RescoreRequest) obj;
        return Objects.equals(rescoreExecutionPlanId(), other.rescoreExecutionPlanId())
                && Objects.equals(searchQuery(), other.searchQuery()) && hasDocuments() == other.hasDocuments()
                && Objects.equals(documents(), other.documents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RescoreRequest").add("RescoreExecutionPlanId", rescoreExecutionPlanId())
                .add("SearchQuery", searchQuery()).add("Documents", hasDocuments() ? documents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RescoreExecutionPlanId":
            return Optional.ofNullable(clazz.cast(rescoreExecutionPlanId()));
        case "SearchQuery":
            return Optional.ofNullable(clazz.cast(searchQuery()));
        case "Documents":
            return Optional.ofNullable(clazz.cast(documents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RescoreExecutionPlanId", RESCORE_EXECUTION_PLAN_ID_FIELD);
        map.put("SearchQuery", SEARCH_QUERY_FIELD);
        map.put("Documents", DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RescoreRequest, T> g) {
        return obj -> g.apply((RescoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRankingRequest.Builder, SdkPojo, CopyableBuilder<Builder, RescoreRequest> {
        /**
         * <p>
         * The identifier of the rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent
         * Ranking resource used for provisioning the <code>Rescore</code> API.
         * </p>
         * 
         * @param rescoreExecutionPlanId
         *        The identifier of the rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent
         *        Ranking resource used for provisioning the <code>Rescore</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rescoreExecutionPlanId(String rescoreExecutionPlanId);

        /**
         * <p>
         * The input query from the search service.
         * </p>
         * 
         * @param searchQuery
         *        The input query from the search service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchQuery(String searchQuery);

        /**
         * <p>
         * The list of documents for Amazon Kendra Intelligent Ranking to rescore or rank on.
         * </p>
         * 
         * @param documents
         *        The list of documents for Amazon Kendra Intelligent Ranking to rescore or rank on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Collection<Document> documents);

        /**
         * <p>
         * The list of documents for Amazon Kendra Intelligent Ranking to rescore or rank on.
         * </p>
         * 
         * @param documents
         *        The list of documents for Amazon Kendra Intelligent Ranking to rescore or rank on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Document... documents);

        /**
         * <p>
         * The list of documents for Amazon Kendra Intelligent Ranking to rescore or rank on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendraranking.model.Document.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendraranking.model.Document#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendraranking.model.Document.Builder#build()} is called immediately
         * and its result is passed to {@link #documents(List<Document>)}.
         * 
         * @param documents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendraranking.model.Document.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(java.util.Collection<Document>)
         */
        Builder documents(Consumer<Document.Builder>... documents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRankingRequest.BuilderImpl implements Builder {
        private String rescoreExecutionPlanId;

        private String searchQuery;

        private List<Document> documents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RescoreRequest model) {
            super(model);
            rescoreExecutionPlanId(model.rescoreExecutionPlanId);
            searchQuery(model.searchQuery);
            documents(model.documents);
        }

        public final String getRescoreExecutionPlanId() {
            return rescoreExecutionPlanId;
        }

        public final void setRescoreExecutionPlanId(String rescoreExecutionPlanId) {
            this.rescoreExecutionPlanId = rescoreExecutionPlanId;
        }

        @Override
        public final Builder rescoreExecutionPlanId(String rescoreExecutionPlanId) {
            this.rescoreExecutionPlanId = rescoreExecutionPlanId;
            return this;
        }

        public final String getSearchQuery() {
            return searchQuery;
        }

        public final void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        @Override
        public final Builder searchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public final List<Document.Builder> getDocuments() {
            List<Document.Builder> result = DocumentListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<Document.BuilderImpl> documents) {
            this.documents = DocumentListCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<Document> documents) {
            this.documents = DocumentListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Document... documents) {
            documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<Document.Builder>... documents) {
            documents(Stream.of(documents).map(c -> Document.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RescoreRequest build() {
            return new RescoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
