/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RescoreResponse extends KendraRankingResponse implements
        ToCopyableBuilder<RescoreResponse.Builder, RescoreResponse> {
    private static final SdkField<String> RESCORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RescoreId").getter(getter(RescoreResponse::rescoreId)).setter(setter(Builder::rescoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RescoreId").build()).build();

    private static final SdkField<List<RescoreResultItem>> RESULT_ITEMS_FIELD = SdkField
            .<List<RescoreResultItem>> builder(MarshallingType.LIST)
            .memberName("ResultItems")
            .getter(getter(RescoreResponse::resultItems))
            .setter(setter(Builder::resultItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RescoreResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RescoreResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESCORE_ID_FIELD,
            RESULT_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String rescoreId;

    private final List<RescoreResultItem> resultItems;

    private RescoreResponse(BuilderImpl builder) {
        super(builder);
        this.rescoreId = builder.rescoreId;
        this.resultItems = builder.resultItems;
    }

    /**
     * <p>
     * The identifier associated with the scores that Amazon Kendra Intelligent Ranking gives to the results. Amazon
     * Kendra Intelligent Ranking rescores or re-ranks the results for the search service.
     * </p>
     * 
     * @return The identifier associated with the scores that Amazon Kendra Intelligent Ranking gives to the results.
     *         Amazon Kendra Intelligent Ranking rescores or re-ranks the results for the search service.
     */
    public final String rescoreId() {
        return rescoreId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultItems() {
        return resultItems != null && !(resultItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of result items for documents with new relevancy scores. The results are in descending order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultItems} method.
     * </p>
     * 
     * @return A list of result items for documents with new relevancy scores. The results are in descending order.
     */
    public final List<RescoreResultItem> resultItems() {
        return resultItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rescoreId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultItems() ? resultItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RescoreResponse)) {
            return false;
        }
        RescoreResponse other = (RescoreResponse) obj;
        return Objects.equals(rescoreId(), other.rescoreId()) && hasResultItems() == other.hasResultItems()
                && Objects.equals(resultItems(), other.resultItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RescoreResponse").add("RescoreId", rescoreId())
                .add("ResultItems", hasResultItems() ? resultItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RescoreId":
            return Optional.ofNullable(clazz.cast(rescoreId()));
        case "ResultItems":
            return Optional.ofNullable(clazz.cast(resultItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RescoreId", RESCORE_ID_FIELD);
        map.put("ResultItems", RESULT_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RescoreResponse, T> g) {
        return obj -> g.apply((RescoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRankingResponse.Builder, SdkPojo, CopyableBuilder<Builder, RescoreResponse> {
        /**
         * <p>
         * The identifier associated with the scores that Amazon Kendra Intelligent Ranking gives to the results. Amazon
         * Kendra Intelligent Ranking rescores or re-ranks the results for the search service.
         * </p>
         * 
         * @param rescoreId
         *        The identifier associated with the scores that Amazon Kendra Intelligent Ranking gives to the results.
         *        Amazon Kendra Intelligent Ranking rescores or re-ranks the results for the search service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rescoreId(String rescoreId);

        /**
         * <p>
         * A list of result items for documents with new relevancy scores. The results are in descending order.
         * </p>
         * 
         * @param resultItems
         *        A list of result items for documents with new relevancy scores. The results are in descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(Collection<RescoreResultItem> resultItems);

        /**
         * <p>
         * A list of result items for documents with new relevancy scores. The results are in descending order.
         * </p>
         * 
         * @param resultItems
         *        A list of result items for documents with new relevancy scores. The results are in descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(RescoreResultItem... resultItems);

        /**
         * <p>
         * A list of result items for documents with new relevancy scores. The results are in descending order.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendraranking.model.RescoreResultItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kendraranking.model.RescoreResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendraranking.model.RescoreResultItem.Builder#build()} is called
         * immediately and its result is passed to {@link #resultItems(List<RescoreResultItem>)}.
         * 
         * @param resultItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendraranking.model.RescoreResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultItems(java.util.Collection<RescoreResultItem>)
         */
        Builder resultItems(Consumer<RescoreResultItem.Builder>... resultItems);
    }

    static final class BuilderImpl extends KendraRankingResponse.BuilderImpl implements Builder {
        private String rescoreId;

        private List<RescoreResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RescoreResponse model) {
            super(model);
            rescoreId(model.rescoreId);
            resultItems(model.resultItems);
        }

        public final String getRescoreId() {
            return rescoreId;
        }

        public final void setRescoreId(String rescoreId) {
            this.rescoreId = rescoreId;
        }

        @Override
        public final Builder rescoreId(String rescoreId) {
            this.rescoreId = rescoreId;
            return this;
        }

        public final List<RescoreResultItem.Builder> getResultItems() {
            List<RescoreResultItem.Builder> result = RescoreResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<RescoreResultItem.BuilderImpl> resultItems) {
            this.resultItems = RescoreResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<RescoreResultItem> resultItems) {
            this.resultItems = RescoreResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(RescoreResultItem... resultItems) {
            resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<RescoreResultItem.Builder>... resultItems) {
            resultItems(Stream.of(resultItems).map(c -> RescoreResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RescoreResponse build() {
            return new RescoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
