/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRescoreExecutionPlanRequest extends KendraRankingRequest implements
        ToCopyableBuilder<UpdateRescoreExecutionPlanRequest.Builder, UpdateRescoreExecutionPlanRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateRescoreExecutionPlanRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateRescoreExecutionPlanRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateRescoreExecutionPlanRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<CapacityUnitsConfiguration> CAPACITY_UNITS_FIELD = SdkField
            .<CapacityUnitsConfiguration> builder(MarshallingType.SDK_POJO).memberName("CapacityUnits")
            .getter(getter(UpdateRescoreExecutionPlanRequest::capacityUnits)).setter(setter(Builder::capacityUnits))
            .constructor(CapacityUnitsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CAPACITY_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String description;

    private final CapacityUnitsConfiguration capacityUnits;

    private UpdateRescoreExecutionPlanRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.capacityUnits = builder.capacityUnits;
    }

    /**
     * <p>
     * The identifier of the rescore execution plan that you want to update.
     * </p>
     * 
     * @return The identifier of the rescore execution plan that you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A new name for the rescore execution plan.
     * </p>
     * 
     * @return A new name for the rescore execution plan.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A new description for the rescore execution plan.
     * </p>
     * 
     * @return A new description for the rescore execution plan.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * You can set additional capacity units to meet the needs of your rescore execution plan. You are given a single
     * capacity unit by default. If you want to use the default capacity, you don't set additional capacity units. For
     * more information on the default capacity and additional capacity units, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     * </p>
     * 
     * @return You can set additional capacity units to meet the needs of your rescore execution plan. You are given a
     *         single capacity unit by default. If you want to use the default capacity, you don't set additional
     *         capacity units. For more information on the default capacity and additional capacity units, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
     */
    public final CapacityUnitsConfiguration capacityUnits() {
        return capacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(capacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRescoreExecutionPlanRequest)) {
            return false;
        }
        UpdateRescoreExecutionPlanRequest other = (UpdateRescoreExecutionPlanRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(capacityUnits(), other.capacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRescoreExecutionPlanRequest").add("Id", id()).add("Name", name())
                .add("Description", description()).add("CapacityUnits", capacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CapacityUnits":
            return Optional.ofNullable(clazz.cast(capacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CapacityUnits", CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRescoreExecutionPlanRequest, T> g) {
        return obj -> g.apply((UpdateRescoreExecutionPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRankingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRescoreExecutionPlanRequest> {
        /**
         * <p>
         * The identifier of the rescore execution plan that you want to update.
         * </p>
         * 
         * @param id
         *        The identifier of the rescore execution plan that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A new name for the rescore execution plan.
         * </p>
         * 
         * @param name
         *        A new name for the rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A new description for the rescore execution plan.
         * </p>
         * 
         * @param description
         *        A new description for the rescore execution plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * You can set additional capacity units to meet the needs of your rescore execution plan. You are given a
         * single capacity unit by default. If you want to use the default capacity, you don't set additional capacity
         * units. For more information on the default capacity and additional capacity units, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * </p>
         * 
         * @param capacityUnits
         *        You can set additional capacity units to meet the needs of your rescore execution plan. You are given
         *        a single capacity unit by default. If you want to use the default capacity, you don't set additional
         *        capacity units. For more information on the default capacity and additional capacity units, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnits(CapacityUnitsConfiguration capacityUnits);

        /**
         * <p>
         * You can set additional capacity units to meet the needs of your rescore execution plan. You are given a
         * single capacity unit by default. If you want to use the default capacity, you don't set additional capacity
         * units. For more information on the default capacity and additional capacity units, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityUnitsConfiguration.Builder}
         * avoiding the need to create one manually via {@link CapacityUnitsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityUnitsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityUnits(CapacityUnitsConfiguration)}.
         * 
         * @param capacityUnits
         *        a consumer that will call methods on {@link CapacityUnitsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityUnits(CapacityUnitsConfiguration)
         */
        default Builder capacityUnits(Consumer<CapacityUnitsConfiguration.Builder> capacityUnits) {
            return capacityUnits(CapacityUnitsConfiguration.builder().applyMutation(capacityUnits).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRankingRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private CapacityUnitsConfiguration capacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRescoreExecutionPlanRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            capacityUnits(model.capacityUnits);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CapacityUnitsConfiguration.Builder getCapacityUnits() {
            return capacityUnits != null ? capacityUnits.toBuilder() : null;
        }

        public final void setCapacityUnits(CapacityUnitsConfiguration.BuilderImpl capacityUnits) {
            this.capacityUnits = capacityUnits != null ? capacityUnits.build() : null;
        }

        @Override
        public final Builder capacityUnits(CapacityUnitsConfiguration capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRescoreExecutionPlanRequest build() {
            return new UpdateRescoreExecutionPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
