/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointParams;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointProvider;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultKendraRankingEndpointProvider
implements KendraRankingEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(KendraRankingEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultKendraRankingEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(KendraRankingEndpointParams params, String region) {
        RuleResult result = DefaultKendraRankingEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKendraRankingEndpointProvider.endpointRule4(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(KendraRankingEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(KendraRankingEndpointParams params, String region) {
        if (region != null) {
            return DefaultKendraRankingEndpointProvider.endpointRule5(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(KendraRankingEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultKendraRankingEndpointProvider.endpointRule6(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKendraRankingEndpointProvider.endpointRule12(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kendra-ranking." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(KendraRankingEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            RuleResult result = DefaultKendraRankingEndpointProvider.endpointRule7(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kendra-ranking." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(KendraRankingEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKendraRankingEndpointProvider.endpointRule8(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(KendraRankingEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kendra-ranking-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(KendraRankingEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKendraRankingEndpointProvider.endpointRule13(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(KendraRankingEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kendra-ranking-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

