/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableResponse extends KeyspacesResponse implements
        ToCopyableBuilder<GetTableResponse.Builder, GetTableResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(GetTableResponse::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(GetTableResponse::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetTableResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(GetTableResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTableResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<SchemaDefinition> SCHEMA_DEFINITION_FIELD = SdkField
            .<SchemaDefinition> builder(MarshallingType.SDK_POJO).memberName("schemaDefinition")
            .getter(getter(GetTableResponse::schemaDefinition)).setter(setter(Builder::schemaDefinition))
            .constructor(SchemaDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()).build();

    private static final SdkField<CapacitySpecificationSummary> CAPACITY_SPECIFICATION_FIELD = SdkField
            .<CapacitySpecificationSummary> builder(MarshallingType.SDK_POJO).memberName("capacitySpecification")
            .getter(getter(GetTableResponse::capacitySpecification)).setter(setter(Builder::capacitySpecification))
            .constructor(CapacitySpecificationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecification").build())
            .build();

    private static final SdkField<EncryptionSpecification> ENCRYPTION_SPECIFICATION_FIELD = SdkField
            .<EncryptionSpecification> builder(MarshallingType.SDK_POJO).memberName("encryptionSpecification")
            .getter(getter(GetTableResponse::encryptionSpecification)).setter(setter(Builder::encryptionSpecification))
            .constructor(EncryptionSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSpecification").build())
            .build();

    private static final SdkField<PointInTimeRecoverySummary> POINT_IN_TIME_RECOVERY_FIELD = SdkField
            .<PointInTimeRecoverySummary> builder(MarshallingType.SDK_POJO).memberName("pointInTimeRecovery")
            .getter(getter(GetTableResponse::pointInTimeRecovery)).setter(setter(Builder::pointInTimeRecovery))
            .constructor(PointInTimeRecoverySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeRecovery").build())
            .build();

    private static final SdkField<TimeToLive> TTL_FIELD = SdkField.<TimeToLive> builder(MarshallingType.SDK_POJO)
            .memberName("ttl").getter(getter(GetTableResponse::ttl)).setter(setter(Builder::ttl))
            .constructor(TimeToLive::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<Integer> DEFAULT_TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("defaultTimeToLive").getter(getter(GetTableResponse::defaultTimeToLive))
            .setter(setter(Builder::defaultTimeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTimeToLive").build()).build();

    private static final SdkField<Comment> COMMENT_FIELD = SdkField.<Comment> builder(MarshallingType.SDK_POJO)
            .memberName("comment").getter(getter(GetTableResponse::comment)).setter(setter(Builder::comment))
            .constructor(Comment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            TABLE_NAME_FIELD, RESOURCE_ARN_FIELD, CREATION_TIMESTAMP_FIELD, STATUS_FIELD, SCHEMA_DEFINITION_FIELD,
            CAPACITY_SPECIFICATION_FIELD, ENCRYPTION_SPECIFICATION_FIELD, POINT_IN_TIME_RECOVERY_FIELD, TTL_FIELD,
            DEFAULT_TIME_TO_LIVE_FIELD, COMMENT_FIELD));

    private final String keyspaceName;

    private final String tableName;

    private final String resourceArn;

    private final Instant creationTimestamp;

    private final String status;

    private final SchemaDefinition schemaDefinition;

    private final CapacitySpecificationSummary capacitySpecification;

    private final EncryptionSpecification encryptionSpecification;

    private final PointInTimeRecoverySummary pointInTimeRecovery;

    private final TimeToLive ttl;

    private final Integer defaultTimeToLive;

    private final Comment comment;

    private GetTableResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.resourceArn = builder.resourceArn;
        this.creationTimestamp = builder.creationTimestamp;
        this.status = builder.status;
        this.schemaDefinition = builder.schemaDefinition;
        this.capacitySpecification = builder.capacitySpecification;
        this.encryptionSpecification = builder.encryptionSpecification;
        this.pointInTimeRecovery = builder.pointInTimeRecovery;
        this.ttl = builder.ttl;
        this.defaultTimeToLive = builder.defaultTimeToLive;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The name of the keyspace that the specified table is stored in.
     * </p>
     * 
     * @return The name of the keyspace that the specified table is stored in.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The name of the specified table.
     * </p>
     * 
     * @return The name of the specified table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified table.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The creation timestamp of the specified table.
     * </p>
     * 
     * @return The creation timestamp of the specified table.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The current status of the specified table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the specified table.
     * @see TableStatus
     */
    public final TableStatus status() {
        return TableStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the specified table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the specified table.
     * @see TableStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The schema definition of the specified table.
     * </p>
     * 
     * @return The schema definition of the specified table.
     */
    public final SchemaDefinition schemaDefinition() {
        return schemaDefinition;
    }

    /**
     * <p>
     * The read/write throughput capacity mode for a table. The options are:
     * </p>
     * <p>
     * • <code>throughputMode:PAY_PER_REQUEST</code>
     * </p>
     * <p>
     * • <code>throughputMode:PROVISIONED</code>
     * </p>
     * 
     * @return The read/write throughput capacity mode for a table. The options are:</p>
     *         <p>
     *         • <code>throughputMode:PAY_PER_REQUEST</code>
     *         </p>
     *         <p>
     *         • <code>throughputMode:PROVISIONED</code>
     */
    public final CapacitySpecificationSummary capacitySpecification() {
        return capacitySpecification;
    }

    /**
     * <p>
     * The encryption settings of the specified table.
     * </p>
     * 
     * @return The encryption settings of the specified table.
     */
    public final EncryptionSpecification encryptionSpecification() {
        return encryptionSpecification;
    }

    /**
     * <p>
     * The point-in-time recovery status of the specified table.
     * </p>
     * 
     * @return The point-in-time recovery status of the specified table.
     */
    public final PointInTimeRecoverySummary pointInTimeRecovery() {
        return pointInTimeRecovery;
    }

    /**
     * <p>
     * The custom Time to Live settings of the specified table.
     * </p>
     * 
     * @return The custom Time to Live settings of the specified table.
     */
    public final TimeToLive ttl() {
        return ttl;
    }

    /**
     * <p>
     * The default Time to Live settings of the specified table.
     * </p>
     * 
     * @return The default Time to Live settings of the specified table.
     */
    public final Integer defaultTimeToLive() {
        return defaultTimeToLive;
    }

    /**
     * <p>
     * The the description of the specified table.
     * </p>
     * 
     * @return The the description of the specified table.
     */
    public final Comment comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(capacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecovery());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTimeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableResponse)) {
            return false;
        }
        GetTableResponse other = (GetTableResponse) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(schemaDefinition(), other.schemaDefinition())
                && Objects.equals(capacitySpecification(), other.capacitySpecification())
                && Objects.equals(encryptionSpecification(), other.encryptionSpecification())
                && Objects.equals(pointInTimeRecovery(), other.pointInTimeRecovery()) && Objects.equals(ttl(), other.ttl())
                && Objects.equals(defaultTimeToLive(), other.defaultTimeToLive()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableResponse").add("KeyspaceName", keyspaceName()).add("TableName", tableName())
                .add("ResourceArn", resourceArn()).add("CreationTimestamp", creationTimestamp()).add("Status", statusAsString())
                .add("SchemaDefinition", schemaDefinition()).add("CapacitySpecification", capacitySpecification())
                .add("EncryptionSpecification", encryptionSpecification()).add("PointInTimeRecovery", pointInTimeRecovery())
                .add("Ttl", ttl()).add("DefaultTimeToLive", defaultTimeToLive()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "schemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        case "capacitySpecification":
            return Optional.ofNullable(clazz.cast(capacitySpecification()));
        case "encryptionSpecification":
            return Optional.ofNullable(clazz.cast(encryptionSpecification()));
        case "pointInTimeRecovery":
            return Optional.ofNullable(clazz.cast(pointInTimeRecovery()));
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "defaultTimeToLive":
            return Optional.ofNullable(clazz.cast(defaultTimeToLive()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTableResponse, T> g) {
        return obj -> g.apply((GetTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTableResponse> {
        /**
         * <p>
         * The name of the keyspace that the specified table is stored in.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace that the specified table is stored in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The name of the specified table.
         * </p>
         * 
         * @param tableName
         *        The name of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified table.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The creation timestamp of the specified table.
         * </p>
         * 
         * @param creationTimestamp
         *        The creation timestamp of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The current status of the specified table.
         * </p>
         * 
         * @param status
         *        The current status of the specified table.
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the specified table.
         * </p>
         * 
         * @param status
         *        The current status of the specified table.
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder status(TableStatus status);

        /**
         * <p>
         * The schema definition of the specified table.
         * </p>
         * 
         * @param schemaDefinition
         *        The schema definition of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(SchemaDefinition schemaDefinition);

        /**
         * <p>
         * The schema definition of the specified table.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaDefinition.Builder} avoiding the
         * need to create one manually via {@link SchemaDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #schemaDefinition(SchemaDefinition)}.
         * 
         * @param schemaDefinition
         *        a consumer that will call methods on {@link SchemaDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaDefinition(SchemaDefinition)
         */
        default Builder schemaDefinition(Consumer<SchemaDefinition.Builder> schemaDefinition) {
            return schemaDefinition(SchemaDefinition.builder().applyMutation(schemaDefinition).build());
        }

        /**
         * <p>
         * The read/write throughput capacity mode for a table. The options are:
         * </p>
         * <p>
         * • <code>throughputMode:PAY_PER_REQUEST</code>
         * </p>
         * <p>
         * • <code>throughputMode:PROVISIONED</code>
         * </p>
         * 
         * @param capacitySpecification
         *        The read/write throughput capacity mode for a table. The options are:</p>
         *        <p>
         *        • <code>throughputMode:PAY_PER_REQUEST</code>
         *        </p>
         *        <p>
         *        • <code>throughputMode:PROVISIONED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacitySpecification(CapacitySpecificationSummary capacitySpecification);

        /**
         * <p>
         * The read/write throughput capacity mode for a table. The options are:
         * </p>
         * <p>
         * • <code>throughputMode:PAY_PER_REQUEST</code>
         * </p>
         * <p>
         * • <code>throughputMode:PROVISIONED</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacitySpecificationSummary.Builder}
         * avoiding the need to create one manually via {@link CapacitySpecificationSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacitySpecificationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #capacitySpecification(CapacitySpecificationSummary)}.
         * 
         * @param capacitySpecification
         *        a consumer that will call methods on {@link CapacitySpecificationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacitySpecification(CapacitySpecificationSummary)
         */
        default Builder capacitySpecification(Consumer<CapacitySpecificationSummary.Builder> capacitySpecification) {
            return capacitySpecification(CapacitySpecificationSummary.builder().applyMutation(capacitySpecification).build());
        }

        /**
         * <p>
         * The encryption settings of the specified table.
         * </p>
         * 
         * @param encryptionSpecification
         *        The encryption settings of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionSpecification(EncryptionSpecification encryptionSpecification);

        /**
         * <p>
         * The encryption settings of the specified table.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionSpecification.Builder} avoiding
         * the need to create one manually via {@link EncryptionSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionSpecification(EncryptionSpecification)}.
         * 
         * @param encryptionSpecification
         *        a consumer that will call methods on {@link EncryptionSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionSpecification(EncryptionSpecification)
         */
        default Builder encryptionSpecification(Consumer<EncryptionSpecification.Builder> encryptionSpecification) {
            return encryptionSpecification(EncryptionSpecification.builder().applyMutation(encryptionSpecification).build());
        }

        /**
         * <p>
         * The point-in-time recovery status of the specified table.
         * </p>
         * 
         * @param pointInTimeRecovery
         *        The point-in-time recovery status of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeRecovery(PointInTimeRecoverySummary pointInTimeRecovery);

        /**
         * <p>
         * The point-in-time recovery status of the specified table.
         * </p>
         * This is a convenience method that creates an instance of the {@link PointInTimeRecoverySummary.Builder}
         * avoiding the need to create one manually via {@link PointInTimeRecoverySummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link PointInTimeRecoverySummary.Builder#build()} is called immediately
         * and its result is passed to {@link #pointInTimeRecovery(PointInTimeRecoverySummary)}.
         * 
         * @param pointInTimeRecovery
         *        a consumer that will call methods on {@link PointInTimeRecoverySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointInTimeRecovery(PointInTimeRecoverySummary)
         */
        default Builder pointInTimeRecovery(Consumer<PointInTimeRecoverySummary.Builder> pointInTimeRecovery) {
            return pointInTimeRecovery(PointInTimeRecoverySummary.builder().applyMutation(pointInTimeRecovery).build());
        }

        /**
         * <p>
         * The custom Time to Live settings of the specified table.
         * </p>
         * 
         * @param ttl
         *        The custom Time to Live settings of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(TimeToLive ttl);

        /**
         * <p>
         * The custom Time to Live settings of the specified table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeToLive.Builder} avoiding the need to
         * create one manually via {@link TimeToLive#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeToLive.Builder#build()} is called immediately and its result
         * is passed to {@link #ttl(TimeToLive)}.
         * 
         * @param ttl
         *        a consumer that will call methods on {@link TimeToLive.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttl(TimeToLive)
         */
        default Builder ttl(Consumer<TimeToLive.Builder> ttl) {
            return ttl(TimeToLive.builder().applyMutation(ttl).build());
        }

        /**
         * <p>
         * The default Time to Live settings of the specified table.
         * </p>
         * 
         * @param defaultTimeToLive
         *        The default Time to Live settings of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTimeToLive(Integer defaultTimeToLive);

        /**
         * <p>
         * The the description of the specified table.
         * </p>
         * 
         * @param comment
         *        The the description of the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(Comment comment);

        /**
         * <p>
         * The the description of the specified table.
         * </p>
         * This is a convenience method that creates an instance of the {@link Comment.Builder} avoiding the need to
         * create one manually via {@link Comment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Comment.Builder#build()} is called immediately and its result is
         * passed to {@link #comment(Comment)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link Comment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(Comment)
         */
        default Builder comment(Consumer<Comment.Builder> comment) {
            return comment(Comment.builder().applyMutation(comment).build());
        }
    }

    static final class BuilderImpl extends KeyspacesResponse.BuilderImpl implements Builder {
        private String keyspaceName;

        private String tableName;

        private String resourceArn;

        private Instant creationTimestamp;

        private String status;

        private SchemaDefinition schemaDefinition;

        private CapacitySpecificationSummary capacitySpecification;

        private EncryptionSpecification encryptionSpecification;

        private PointInTimeRecoverySummary pointInTimeRecovery;

        private TimeToLive ttl;

        private Integer defaultTimeToLive;

        private Comment comment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableResponse model) {
            super(model);
            keyspaceName(model.keyspaceName);
            tableName(model.tableName);
            resourceArn(model.resourceArn);
            creationTimestamp(model.creationTimestamp);
            status(model.status);
            schemaDefinition(model.schemaDefinition);
            capacitySpecification(model.capacitySpecification);
            encryptionSpecification(model.encryptionSpecification);
            pointInTimeRecovery(model.pointInTimeRecovery);
            ttl(model.ttl);
            defaultTimeToLive(model.defaultTimeToLive);
            comment(model.comment);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SchemaDefinition.Builder getSchemaDefinition() {
            return schemaDefinition != null ? schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaDefinition.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaDefinition schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final CapacitySpecificationSummary.Builder getCapacitySpecification() {
            return capacitySpecification != null ? capacitySpecification.toBuilder() : null;
        }

        public final void setCapacitySpecification(CapacitySpecificationSummary.BuilderImpl capacitySpecification) {
            this.capacitySpecification = capacitySpecification != null ? capacitySpecification.build() : null;
        }

        @Override
        public final Builder capacitySpecification(CapacitySpecificationSummary capacitySpecification) {
            this.capacitySpecification = capacitySpecification;
            return this;
        }

        public final EncryptionSpecification.Builder getEncryptionSpecification() {
            return encryptionSpecification != null ? encryptionSpecification.toBuilder() : null;
        }

        public final void setEncryptionSpecification(EncryptionSpecification.BuilderImpl encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification != null ? encryptionSpecification.build() : null;
        }

        @Override
        public final Builder encryptionSpecification(EncryptionSpecification encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification;
            return this;
        }

        public final PointInTimeRecoverySummary.Builder getPointInTimeRecovery() {
            return pointInTimeRecovery != null ? pointInTimeRecovery.toBuilder() : null;
        }

        public final void setPointInTimeRecovery(PointInTimeRecoverySummary.BuilderImpl pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery != null ? pointInTimeRecovery.build() : null;
        }

        @Override
        public final Builder pointInTimeRecovery(PointInTimeRecoverySummary pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public final TimeToLive.Builder getTtl() {
            return ttl != null ? ttl.toBuilder() : null;
        }

        public final void setTtl(TimeToLive.BuilderImpl ttl) {
            this.ttl = ttl != null ? ttl.build() : null;
        }

        @Override
        public final Builder ttl(TimeToLive ttl) {
            this.ttl = ttl;
            return this;
        }

        public final Integer getDefaultTimeToLive() {
            return defaultTimeToLive;
        }

        public final void setDefaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
        }

        @Override
        public final Builder defaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
            return this;
        }

        public final Comment.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        public final void setComment(Comment.BuilderImpl comment) {
            this.comment = comment != null ? comment.build() : null;
        }

        @Override
        public final Builder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public GetTableResponse build() {
            return new GetTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
