/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKeyspacesResponse extends KeyspacesResponse implements
        ToCopyableBuilder<ListKeyspacesResponse.Builder, ListKeyspacesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListKeyspacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<KeyspaceSummary>> KEYSPACES_FIELD = SdkField
            .<List<KeyspaceSummary>> builder(MarshallingType.LIST)
            .memberName("keyspaces")
            .getter(getter(ListKeyspacesResponse::keyspaces))
            .setter(setter(Builder::keyspaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyspaceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyspaceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            KEYSPACES_FIELD));

    private final String nextToken;

    private final List<KeyspaceSummary> keyspaces;

    private ListKeyspacesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.keyspaces = builder.keyspaces;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated
     * response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the <code>NextToken</code> from a previously
     *         truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keyspaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeyspaces() {
        return keyspaces != null && !(keyspaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of keyspaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyspaces} method.
     * </p>
     * 
     * @return A list of keyspaces.
     */
    public final List<KeyspaceSummary> keyspaces() {
        return keyspaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyspaces() ? keyspaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyspacesResponse)) {
            return false;
        }
        ListKeyspacesResponse other = (ListKeyspacesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasKeyspaces() == other.hasKeyspaces()
                && Objects.equals(keyspaces(), other.keyspaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKeyspacesResponse").add("NextToken", nextToken())
                .add("Keyspaces", hasKeyspaces() ? keyspaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "keyspaces":
            return Optional.ofNullable(clazz.cast(keyspaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKeyspacesResponse, T> g) {
        return obj -> g.apply((ListKeyspacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListKeyspacesResponse> {
        /**
         * <p>
         * A token to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated
         * response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the <code>NextToken</code> from a previously
         *        truncated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of keyspaces.
         * </p>
         * 
         * @param keyspaces
         *        A list of keyspaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaces(Collection<KeyspaceSummary> keyspaces);

        /**
         * <p>
         * A list of keyspaces.
         * </p>
         * 
         * @param keyspaces
         *        A list of keyspaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaces(KeyspaceSummary... keyspaces);

        /**
         * <p>
         * A list of keyspaces.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<KeyspaceSummary>.Builder} avoiding
         * the need to create one manually via {@link List<KeyspaceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyspaceSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #keyspaces(List<KeyspaceSummary>)}.
         * 
         * @param keyspaces
         *        a consumer that will call methods on {@link List<KeyspaceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyspaces(List<KeyspaceSummary>)
         */
        Builder keyspaces(Consumer<KeyspaceSummary.Builder>... keyspaces);
    }

    static final class BuilderImpl extends KeyspacesResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<KeyspaceSummary> keyspaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyspacesResponse model) {
            super(model);
            nextToken(model.nextToken);
            keyspaces(model.keyspaces);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<KeyspaceSummary.Builder> getKeyspaces() {
            List<KeyspaceSummary.Builder> result = KeyspaceSummaryListCopier.copyToBuilder(this.keyspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyspaces(Collection<KeyspaceSummary.BuilderImpl> keyspaces) {
            this.keyspaces = KeyspaceSummaryListCopier.copyFromBuilder(keyspaces);
        }

        @Override
        public final Builder keyspaces(Collection<KeyspaceSummary> keyspaces) {
            this.keyspaces = KeyspaceSummaryListCopier.copy(keyspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyspaces(KeyspaceSummary... keyspaces) {
            keyspaces(Arrays.asList(keyspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyspaces(Consumer<KeyspaceSummary.Builder>... keyspaces) {
            keyspaces(Stream.of(keyspaces).map(c -> KeyspaceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListKeyspacesResponse build() {
            return new ListKeyspacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
