/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTableRequest extends KeyspacesRequest implements
        ToCopyableBuilder<CreateTableRequest.Builder, CreateTableRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(CreateTableRequest::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(CreateTableRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<SchemaDefinition> SCHEMA_DEFINITION_FIELD = SdkField
            .<SchemaDefinition> builder(MarshallingType.SDK_POJO).memberName("schemaDefinition")
            .getter(getter(CreateTableRequest::schemaDefinition)).setter(setter(Builder::schemaDefinition))
            .constructor(SchemaDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()).build();

    private static final SdkField<Comment> COMMENT_FIELD = SdkField.<Comment> builder(MarshallingType.SDK_POJO)
            .memberName("comment").getter(getter(CreateTableRequest::comment)).setter(setter(Builder::comment))
            .constructor(Comment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<CapacitySpecification> CAPACITY_SPECIFICATION_FIELD = SdkField
            .<CapacitySpecification> builder(MarshallingType.SDK_POJO).memberName("capacitySpecification")
            .getter(getter(CreateTableRequest::capacitySpecification)).setter(setter(Builder::capacitySpecification))
            .constructor(CapacitySpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecification").build())
            .build();

    private static final SdkField<EncryptionSpecification> ENCRYPTION_SPECIFICATION_FIELD = SdkField
            .<EncryptionSpecification> builder(MarshallingType.SDK_POJO).memberName("encryptionSpecification")
            .getter(getter(CreateTableRequest::encryptionSpecification)).setter(setter(Builder::encryptionSpecification))
            .constructor(EncryptionSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSpecification").build())
            .build();

    private static final SdkField<PointInTimeRecovery> POINT_IN_TIME_RECOVERY_FIELD = SdkField
            .<PointInTimeRecovery> builder(MarshallingType.SDK_POJO).memberName("pointInTimeRecovery")
            .getter(getter(CreateTableRequest::pointInTimeRecovery)).setter(setter(Builder::pointInTimeRecovery))
            .constructor(PointInTimeRecovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeRecovery").build())
            .build();

    private static final SdkField<TimeToLive> TTL_FIELD = SdkField.<TimeToLive> builder(MarshallingType.SDK_POJO)
            .memberName("ttl").getter(getter(CreateTableRequest::ttl)).setter(setter(Builder::ttl))
            .constructor(TimeToLive::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<Integer> DEFAULT_TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("defaultTimeToLive").getter(getter(CreateTableRequest::defaultTimeToLive))
            .setter(setter(Builder::defaultTimeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTimeToLive").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateTableRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ClientSideTimestamps> CLIENT_SIDE_TIMESTAMPS_FIELD = SdkField
            .<ClientSideTimestamps> builder(MarshallingType.SDK_POJO).memberName("clientSideTimestamps")
            .getter(getter(CreateTableRequest::clientSideTimestamps)).setter(setter(Builder::clientSideTimestamps))
            .constructor(ClientSideTimestamps::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSideTimestamps").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            TABLE_NAME_FIELD, SCHEMA_DEFINITION_FIELD, COMMENT_FIELD, CAPACITY_SPECIFICATION_FIELD,
            ENCRYPTION_SPECIFICATION_FIELD, POINT_IN_TIME_RECOVERY_FIELD, TTL_FIELD, DEFAULT_TIME_TO_LIVE_FIELD, TAGS_FIELD,
            CLIENT_SIDE_TIMESTAMPS_FIELD));

    private final String keyspaceName;

    private final String tableName;

    private final SchemaDefinition schemaDefinition;

    private final Comment comment;

    private final CapacitySpecification capacitySpecification;

    private final EncryptionSpecification encryptionSpecification;

    private final PointInTimeRecovery pointInTimeRecovery;

    private final TimeToLive ttl;

    private final Integer defaultTimeToLive;

    private final List<Tag> tags;

    private final ClientSideTimestamps clientSideTimestamps;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.schemaDefinition = builder.schemaDefinition;
        this.comment = builder.comment;
        this.capacitySpecification = builder.capacitySpecification;
        this.encryptionSpecification = builder.encryptionSpecification;
        this.pointInTimeRecovery = builder.pointInTimeRecovery;
        this.ttl = builder.ttl;
        this.defaultTimeToLive = builder.defaultTimeToLive;
        this.tags = builder.tags;
        this.clientSideTimestamps = builder.clientSideTimestamps;
    }

    /**
     * <p>
     * The name of the keyspace that the table is going to be created in.
     * </p>
     * 
     * @return The name of the keyspace that the table is going to be created in.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The <code>schemaDefinition</code> consists of the following parameters.
     * </p>
     * <p>
     * For each column to be created:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>name</code> - The name of the column.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in
     * the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The primary key of the table consists of the following columns:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed of
     * two or more columns. The partition key portion of the primary key is required and determines how Amazon Keyspaces
     * stores your data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code> - The name of each partition key column.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the data
     * is clustered and sorted within each partition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code> - The name of the clustering column.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
     * </p>
     * <p>
     * To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by all
     * rows in the same partition:
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code> - The name of the column.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - An Amazon Keyspaces data type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The <code>schemaDefinition</code> consists of the following parameters.</p>
     *         <p>
     *         For each column to be created:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>name</code> - The name of the column.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data
     *         types</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The primary key of the table consists of the following columns:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value
     *         composed of two or more columns. The partition key portion of the primary key is required and determines
     *         how Amazon Keyspaces stores your data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code> - The name of each partition key column.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how
     *         the data is clustered and sorted within each partition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code> - The name of the clustering column.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order
     *         modifier.
     *         </p>
     *         <p>
     *         To define a column as static use <code>staticColumns</code> - Static columns store values that are shared
     *         by all rows in the same partition:
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code> - The name of the column.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - An Amazon Keyspaces data type.
     *         </p>
     *         </li>
     */
    public final SchemaDefinition schemaDefinition() {
        return schemaDefinition;
    }

    /**
     * <p>
     * This parameter allows to enter a description of the table.
     * </p>
     * 
     * @return This parameter allows to enter a description of the table.
     */
    public final Comment comment() {
        return comment;
    }

    /**
     * <p>
     * Specifies the read/write throughput capacity mode for the table. The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>throughputMode:PAY_PER_REQUEST</code> and
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and
     * <code>writeCapacityUnits</code> as input.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
     * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Specifies the read/write throughput capacity mode for the table. The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>throughputMode:PAY_PER_REQUEST</code> and
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
     *         <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
     *         capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final CapacitySpecification capacitySpecification() {
        return capacitySpecification;
    }

    /**
     * <p>
     * Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the
     * following KMS key (KMS key):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
     * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name
     * (ARN) format as input.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>type:AWS_OWNED_KMS_KEY</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the
     * <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of
     *         the following KMS key (KMS key):</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned,
     *         and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon
     *         Resource Name (ARN) format as input.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>type:AWS_OWNED_KMS_KEY</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a>
     *         in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final EncryptionSpecification encryptionSpecification() {
        return encryptionSpecification;
    }

    /**
     * <p>
     * Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>status=ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status=DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If it's not specified, the default is <code>status=DISABLED</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a>
     * in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>status=ENABLED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status=DISABLED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If it's not specified, the default is <code>status=DISABLED</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
     *         recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final PointInTimeRecovery pointInTimeRecovery() {
        return pointInTimeRecovery;
    }

    /**
     * <p>
     * Enables Time to Live custom settings for the table. The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>status:enabled</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status:disabled</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the
     * table.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data
     * by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Enables Time to Live custom settings for the table. The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>status:enabled</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status:disabled</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for
     *         the table.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon
     *         Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final TimeToLive ttl() {
        return ttl;
    }

    /**
     * <p>
     * The default Time to Live setting in seconds for the table.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl"
     * >Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return The default Time to Live setting in seconds for the table.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl"
     *         >Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final Integer defaultTimeToLive() {
        return defaultTimeToLive;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pair tags to be attached to the resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to
     * Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pair tags to be attached to the resource. </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and
     *         labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Enables client-side timestamps for the table. By default, the setting is disabled. You can enable client-side
     * timestamps with the following option:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>status: "enabled"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Once client-side timestamps are enabled for a table, this setting cannot be disabled.
     * </p>
     * 
     * @return Enables client-side timestamps for the table. By default, the setting is disabled. You can enable
     *         client-side timestamps with the following option:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>status: "enabled"</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Once client-side timestamps are enabled for a table, this setting cannot be disabled.
     */
    public final ClientSideTimestamps clientSideTimestamps() {
        return clientSideTimestamps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(capacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecovery());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTimeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientSideTimestamps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(schemaDefinition(), other.schemaDefinition()) && Objects.equals(comment(), other.comment())
                && Objects.equals(capacitySpecification(), other.capacitySpecification())
                && Objects.equals(encryptionSpecification(), other.encryptionSpecification())
                && Objects.equals(pointInTimeRecovery(), other.pointInTimeRecovery()) && Objects.equals(ttl(), other.ttl())
                && Objects.equals(defaultTimeToLive(), other.defaultTimeToLive()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientSideTimestamps(), other.clientSideTimestamps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTableRequest").add("KeyspaceName", keyspaceName()).add("TableName", tableName())
                .add("SchemaDefinition", schemaDefinition()).add("Comment", comment())
                .add("CapacitySpecification", capacitySpecification()).add("EncryptionSpecification", encryptionSpecification())
                .add("PointInTimeRecovery", pointInTimeRecovery()).add("Ttl", ttl())
                .add("DefaultTimeToLive", defaultTimeToLive()).add("Tags", hasTags() ? tags() : null)
                .add("ClientSideTimestamps", clientSideTimestamps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "schemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "capacitySpecification":
            return Optional.ofNullable(clazz.cast(capacitySpecification()));
        case "encryptionSpecification":
            return Optional.ofNullable(clazz.cast(encryptionSpecification()));
        case "pointInTimeRecovery":
            return Optional.ofNullable(clazz.cast(pointInTimeRecovery()));
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "defaultTimeToLive":
            return Optional.ofNullable(clazz.cast(defaultTimeToLive()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientSideTimestamps":
            return Optional.ofNullable(clazz.cast(clientSideTimestamps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTableRequest> {
        /**
         * <p>
         * The name of the keyspace that the table is going to be created in.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace that the table is going to be created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The <code>schemaDefinition</code> consists of the following parameters.
         * </p>
         * <p>
         * For each column to be created:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>name</code> - The name of the column.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a>
         * in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The primary key of the table consists of the following columns:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed
         * of two or more columns. The partition key portion of the primary key is required and determines how Amazon
         * Keyspaces stores your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of each partition key column.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the
         * data is clustered and sorted within each partition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the clustering column.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order
         * modifier.
         * </p>
         * <p>
         * To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by
         * all rows in the same partition:
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the column.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - An Amazon Keyspaces data type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param schemaDefinition
         *        The <code>schemaDefinition</code> consists of the following parameters.</p>
         *        <p>
         *        For each column to be created:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the column.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data
         *        types</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The primary key of the table consists of the following columns:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value
         *        composed of two or more columns. The partition key portion of the primary key is required and
         *        determines how Amazon Keyspaces stores your data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of each partition key column.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines
         *        how the data is clustered and sorted within each partition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the clustering column.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order
         *        modifier.
         *        </p>
         *        <p>
         *        To define a column as static use <code>staticColumns</code> - Static columns store values that are
         *        shared by all rows in the same partition:
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the column.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - An Amazon Keyspaces data type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(SchemaDefinition schemaDefinition);

        /**
         * <p>
         * The <code>schemaDefinition</code> consists of the following parameters.
         * </p>
         * <p>
         * For each column to be created:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>name</code> - The name of the column.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a>
         * in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The primary key of the table consists of the following columns:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>partitionKeys</code> - The partition key can be a single column, or it can be a compound value composed
         * of two or more columns. The partition key portion of the primary key is required and determines how Amazon
         * Keyspaces stores your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of each partition key column.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>clusteringKeys</code> - The optional clustering column portion of your primary key determines how the
         * data is clustered and sorted within each partition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the clustering column.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>orderBy</code> - Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order
         * modifier.
         * </p>
         * <p>
         * To define a column as static use <code>staticColumns</code> - Static columns store values that are shared by
         * all rows in the same partition:
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the column.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - An Amazon Keyspaces data type.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link SchemaDefinition.Builder} avoiding the
         * need to create one manually via {@link SchemaDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #schemaDefinition(SchemaDefinition)}.
         * 
         * @param schemaDefinition
         *        a consumer that will call methods on {@link SchemaDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaDefinition(SchemaDefinition)
         */
        default Builder schemaDefinition(Consumer<SchemaDefinition.Builder> schemaDefinition) {
            return schemaDefinition(SchemaDefinition.builder().applyMutation(schemaDefinition).build());
        }

        /**
         * <p>
         * This parameter allows to enter a description of the table.
         * </p>
         * 
         * @param comment
         *        This parameter allows to enter a description of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(Comment comment);

        /**
         * <p>
         * This parameter allows to enter a description of the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link Comment.Builder} avoiding the need to
         * create one manually via {@link Comment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Comment.Builder#build()} is called immediately and its result is
         * passed to {@link #comment(Comment)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link Comment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(Comment)
         */
        default Builder comment(Consumer<Comment.Builder> comment) {
            return comment(Comment.builder().applyMutation(comment).build());
        }

        /**
         * <p>
         * Specifies the read/write throughput capacity mode for the table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>throughputMode:PAY_PER_REQUEST</code> and
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code>
         * and <code>writeCapacityUnits</code> as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
         * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param capacitySpecification
         *        Specifies the read/write throughput capacity mode for the table. The options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>throughputMode:PAY_PER_REQUEST</code> and
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
         *        <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
         *        capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacitySpecification(CapacitySpecification capacitySpecification);

        /**
         * <p>
         * Specifies the read/write throughput capacity mode for the table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>throughputMode:PAY_PER_REQUEST</code> and
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code>
         * and <code>writeCapacityUnits</code> as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
         * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacitySpecification.Builder} avoiding
         * the need to create one manually via {@link CapacitySpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacitySpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #capacitySpecification(CapacitySpecification)}.
         * 
         * @param capacitySpecification
         *        a consumer that will call methods on {@link CapacitySpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacitySpecification(CapacitySpecification)
         */
        default Builder capacitySpecification(Consumer<CapacitySpecification.Builder> capacitySpecification) {
            return capacitySpecification(CapacitySpecification.builder().applyMutation(capacitySpecification).build());
        }

        /**
         * <p>
         * Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the
         * following KMS key (KMS key):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
         * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource
         * Name (ARN) format as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>type:AWS_OWNED_KMS_KEY</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in
         * the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param encryptionSpecification
         *        Specifies how the encryption key for encryption at rest is managed for the table. You can choose one
         *        of the following KMS key (KMS key):</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned,
         *        and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon
         *        Resource Name (ARN) format as input.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>type:AWS_OWNED_KMS_KEY</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at
         *        rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionSpecification(EncryptionSpecification encryptionSpecification);

        /**
         * <p>
         * Specifies how the encryption key for encryption at rest is managed for the table. You can choose one of the
         * following KMS key (KMS key):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
         * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource
         * Name (ARN) format as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>type:AWS_OWNED_KMS_KEY</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in
         * the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionSpecification.Builder} avoiding
         * the need to create one manually via {@link EncryptionSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionSpecification(EncryptionSpecification)}.
         * 
         * @param encryptionSpecification
         *        a consumer that will call methods on {@link EncryptionSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionSpecification(EncryptionSpecification)
         */
        default Builder encryptionSpecification(Consumer<EncryptionSpecification.Builder> encryptionSpecification) {
            return encryptionSpecification(EncryptionSpecification.builder().applyMutation(encryptionSpecification).build());
        }

        /**
         * <p>
         * Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status=ENABLED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status=DISABLED</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If it's not specified, the default is <code>status=DISABLED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         * recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param pointInTimeRecovery
         *        Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status=ENABLED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status=DISABLED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If it's not specified, the default is <code>status=DISABLED</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         *        recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeRecovery(PointInTimeRecovery pointInTimeRecovery);

        /**
         * <p>
         * Specifies if <code>pointInTimeRecovery</code> is enabled or disabled for the table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status=ENABLED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status=DISABLED</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If it's not specified, the default is <code>status=DISABLED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         * recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PointInTimeRecovery.Builder} avoiding the
         * need to create one manually via {@link PointInTimeRecovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PointInTimeRecovery.Builder#build()} is called immediately and
         * its result is passed to {@link #pointInTimeRecovery(PointInTimeRecovery)}.
         * 
         * @param pointInTimeRecovery
         *        a consumer that will call methods on {@link PointInTimeRecovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointInTimeRecovery(PointInTimeRecovery)
         */
        default Builder pointInTimeRecovery(Consumer<PointInTimeRecovery.Builder> pointInTimeRecovery) {
            return pointInTimeRecovery(PointInTimeRecovery.builder().applyMutation(pointInTimeRecovery).build());
        }

        /**
         * <p>
         * Enables Time to Live custom settings for the table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status:enabled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status:disabled</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the
         * table.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring
         * data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param ttl
         *        Enables Time to Live custom settings for the table. The options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status:enabled</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status:disabled</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it
         *        for the table.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon
         *        Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(TimeToLive ttl);

        /**
         * <p>
         * Enables Time to Live custom settings for the table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status:enabled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status:disabled</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the
         * table.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring
         * data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeToLive.Builder} avoiding the need to
         * create one manually via {@link TimeToLive#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeToLive.Builder#build()} is called immediately and its result
         * is passed to {@link #ttl(TimeToLive)}.
         * 
         * @param ttl
         *        a consumer that will call methods on {@link TimeToLive.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttl(TimeToLive)
         */
        default Builder ttl(Consumer<TimeToLive.Builder> ttl) {
            return ttl(TimeToLive.builder().applyMutation(ttl).build());
        }

        /**
         * <p>
         * The default Time to Live setting in seconds for the table.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl"
         * >Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param defaultTimeToLive
         *        The default Time to Live setting in seconds for the table.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl"
         *        >Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTimeToLive(Integer defaultTimeToLive);

        /**
         * <p>
         * A list of key-value pair tags to be attached to the resource.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to
         * Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pair tags to be attached to the resource. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and
         *        labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pair tags to be attached to the resource.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to
         * Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pair tags to be attached to the resource. </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and
         *        labels to Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pair tags to be attached to the resource.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html">Adding tags and labels to
         * Amazon Keyspaces resources</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.keyspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Enables client-side timestamps for the table. By default, the setting is disabled. You can enable client-side
         * timestamps with the following option:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status: "enabled"</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Once client-side timestamps are enabled for a table, this setting cannot be disabled.
         * </p>
         * 
         * @param clientSideTimestamps
         *        Enables client-side timestamps for the table. By default, the setting is disabled. You can enable
         *        client-side timestamps with the following option:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status: "enabled"</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Once client-side timestamps are enabled for a table, this setting cannot be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSideTimestamps(ClientSideTimestamps clientSideTimestamps);

        /**
         * <p>
         * Enables client-side timestamps for the table. By default, the setting is disabled. You can enable client-side
         * timestamps with the following option:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status: "enabled"</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Once client-side timestamps are enabled for a table, this setting cannot be disabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientSideTimestamps.Builder} avoiding
         * the need to create one manually via {@link ClientSideTimestamps#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientSideTimestamps.Builder#build()} is called immediately and
         * its result is passed to {@link #clientSideTimestamps(ClientSideTimestamps)}.
         * 
         * @param clientSideTimestamps
         *        a consumer that will call methods on {@link ClientSideTimestamps.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientSideTimestamps(ClientSideTimestamps)
         */
        default Builder clientSideTimestamps(Consumer<ClientSideTimestamps.Builder> clientSideTimestamps) {
            return clientSideTimestamps(ClientSideTimestamps.builder().applyMutation(clientSideTimestamps).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesRequest.BuilderImpl implements Builder {
        private String keyspaceName;

        private String tableName;

        private SchemaDefinition schemaDefinition;

        private Comment comment;

        private CapacitySpecification capacitySpecification;

        private EncryptionSpecification encryptionSpecification;

        private PointInTimeRecovery pointInTimeRecovery;

        private TimeToLive ttl;

        private Integer defaultTimeToLive;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ClientSideTimestamps clientSideTimestamps;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            keyspaceName(model.keyspaceName);
            tableName(model.tableName);
            schemaDefinition(model.schemaDefinition);
            comment(model.comment);
            capacitySpecification(model.capacitySpecification);
            encryptionSpecification(model.encryptionSpecification);
            pointInTimeRecovery(model.pointInTimeRecovery);
            ttl(model.ttl);
            defaultTimeToLive(model.defaultTimeToLive);
            tags(model.tags);
            clientSideTimestamps(model.clientSideTimestamps);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final SchemaDefinition.Builder getSchemaDefinition() {
            return schemaDefinition != null ? schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaDefinition.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaDefinition schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final Comment.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        public final void setComment(Comment.BuilderImpl comment) {
            this.comment = comment != null ? comment.build() : null;
        }

        @Override
        public final Builder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        public final CapacitySpecification.Builder getCapacitySpecification() {
            return capacitySpecification != null ? capacitySpecification.toBuilder() : null;
        }

        public final void setCapacitySpecification(CapacitySpecification.BuilderImpl capacitySpecification) {
            this.capacitySpecification = capacitySpecification != null ? capacitySpecification.build() : null;
        }

        @Override
        public final Builder capacitySpecification(CapacitySpecification capacitySpecification) {
            this.capacitySpecification = capacitySpecification;
            return this;
        }

        public final EncryptionSpecification.Builder getEncryptionSpecification() {
            return encryptionSpecification != null ? encryptionSpecification.toBuilder() : null;
        }

        public final void setEncryptionSpecification(EncryptionSpecification.BuilderImpl encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification != null ? encryptionSpecification.build() : null;
        }

        @Override
        public final Builder encryptionSpecification(EncryptionSpecification encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification;
            return this;
        }

        public final PointInTimeRecovery.Builder getPointInTimeRecovery() {
            return pointInTimeRecovery != null ? pointInTimeRecovery.toBuilder() : null;
        }

        public final void setPointInTimeRecovery(PointInTimeRecovery.BuilderImpl pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery != null ? pointInTimeRecovery.build() : null;
        }

        @Override
        public final Builder pointInTimeRecovery(PointInTimeRecovery pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public final TimeToLive.Builder getTtl() {
            return ttl != null ? ttl.toBuilder() : null;
        }

        public final void setTtl(TimeToLive.BuilderImpl ttl) {
            this.ttl = ttl != null ? ttl.build() : null;
        }

        @Override
        public final Builder ttl(TimeToLive ttl) {
            this.ttl = ttl;
            return this;
        }

        public final Integer getDefaultTimeToLive() {
            return defaultTimeToLive;
        }

        public final void setDefaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
        }

        @Override
        public final Builder defaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClientSideTimestamps.Builder getClientSideTimestamps() {
            return clientSideTimestamps != null ? clientSideTimestamps.toBuilder() : null;
        }

        public final void setClientSideTimestamps(ClientSideTimestamps.BuilderImpl clientSideTimestamps) {
            this.clientSideTimestamps = clientSideTimestamps != null ? clientSideTimestamps.build() : null;
        }

        @Override
        public final Builder clientSideTimestamps(ClientSideTimestamps clientSideTimestamps) {
            this.clientSideTimestamps = clientSideTimestamps;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
