/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKeyspaceResponse extends KeyspacesResponse implements
        ToCopyableBuilder<GetKeyspaceResponse.Builder, GetKeyspaceResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(GetKeyspaceResponse::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetKeyspaceResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            RESOURCE_ARN_FIELD));

    private final String keyspaceName;

    private final String resourceArn;

    private GetKeyspaceResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The name of the keyspace.
     * </p>
     * 
     * @return The name of the keyspace.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The ARN of the keyspace.
     * </p>
     * 
     * @return The ARN of the keyspace.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyspaceResponse)) {
            return false;
        }
        GetKeyspaceResponse other = (GetKeyspaceResponse) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKeyspaceResponse").add("KeyspaceName", keyspaceName()).add("ResourceArn", resourceArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKeyspaceResponse, T> g) {
        return obj -> g.apply((GetKeyspaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKeyspaceResponse> {
        /**
         * <p>
         * The name of the keyspace.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The ARN of the keyspace.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl extends KeyspacesResponse.BuilderImpl implements Builder {
        private String keyspaceName;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyspaceResponse model) {
            super(model);
            keyspaceName(model.keyspaceName);
            resourceArn(model.resourceArn);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public GetKeyspaceResponse build() {
            return new GetKeyspaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
