/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The optional auto scaling settings for read and write capacity of a table in provisioned capacity mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingSpecification.Builder, AutoScalingSpecification> {
    private static final SdkField<AutoScalingSettings> WRITE_CAPACITY_AUTO_SCALING_FIELD = SdkField
            .<AutoScalingSettings> builder(MarshallingType.SDK_POJO).memberName("writeCapacityAutoScaling")
            .getter(getter(AutoScalingSpecification::writeCapacityAutoScaling)).setter(setter(Builder::writeCapacityAutoScaling))
            .constructor(AutoScalingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeCapacityAutoScaling").build())
            .build();

    private static final SdkField<AutoScalingSettings> READ_CAPACITY_AUTO_SCALING_FIELD = SdkField
            .<AutoScalingSettings> builder(MarshallingType.SDK_POJO).memberName("readCapacityAutoScaling")
            .getter(getter(AutoScalingSpecification::readCapacityAutoScaling)).setter(setter(Builder::readCapacityAutoScaling))
            .constructor(AutoScalingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readCapacityAutoScaling").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WRITE_CAPACITY_AUTO_SCALING_FIELD, READ_CAPACITY_AUTO_SCALING_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoScalingSettings writeCapacityAutoScaling;

    private final AutoScalingSettings readCapacityAutoScaling;

    private AutoScalingSpecification(BuilderImpl builder) {
        this.writeCapacityAutoScaling = builder.writeCapacityAutoScaling;
        this.readCapacityAutoScaling = builder.readCapacityAutoScaling;
    }

    /**
     * <p>
     * The auto scaling settings for the table's write capacity.
     * </p>
     * 
     * @return The auto scaling settings for the table's write capacity.
     */
    public final AutoScalingSettings writeCapacityAutoScaling() {
        return writeCapacityAutoScaling;
    }

    /**
     * <p>
     * The auto scaling settings for the table's read capacity.
     * </p>
     * 
     * @return The auto scaling settings for the table's read capacity.
     */
    public final AutoScalingSettings readCapacityAutoScaling() {
        return readCapacityAutoScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(writeCapacityAutoScaling());
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityAutoScaling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingSpecification)) {
            return false;
        }
        AutoScalingSpecification other = (AutoScalingSpecification) obj;
        return Objects.equals(writeCapacityAutoScaling(), other.writeCapacityAutoScaling())
                && Objects.equals(readCapacityAutoScaling(), other.readCapacityAutoScaling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingSpecification").add("WriteCapacityAutoScaling", writeCapacityAutoScaling())
                .add("ReadCapacityAutoScaling", readCapacityAutoScaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "writeCapacityAutoScaling":
            return Optional.ofNullable(clazz.cast(writeCapacityAutoScaling()));
        case "readCapacityAutoScaling":
            return Optional.ofNullable(clazz.cast(readCapacityAutoScaling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingSpecification, T> g) {
        return obj -> g.apply((AutoScalingSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingSpecification> {
        /**
         * <p>
         * The auto scaling settings for the table's write capacity.
         * </p>
         * 
         * @param writeCapacityAutoScaling
         *        The auto scaling settings for the table's write capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCapacityAutoScaling(AutoScalingSettings writeCapacityAutoScaling);

        /**
         * <p>
         * The auto scaling settings for the table's write capacity.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingSettings.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #writeCapacityAutoScaling(AutoScalingSettings)}.
         * 
         * @param writeCapacityAutoScaling
         *        a consumer that will call methods on {@link AutoScalingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #writeCapacityAutoScaling(AutoScalingSettings)
         */
        default Builder writeCapacityAutoScaling(Consumer<AutoScalingSettings.Builder> writeCapacityAutoScaling) {
            return writeCapacityAutoScaling(AutoScalingSettings.builder().applyMutation(writeCapacityAutoScaling).build());
        }

        /**
         * <p>
         * The auto scaling settings for the table's read capacity.
         * </p>
         * 
         * @param readCapacityAutoScaling
         *        The auto scaling settings for the table's read capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityAutoScaling(AutoScalingSettings readCapacityAutoScaling);

        /**
         * <p>
         * The auto scaling settings for the table's read capacity.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingSettings.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #readCapacityAutoScaling(AutoScalingSettings)}.
         * 
         * @param readCapacityAutoScaling
         *        a consumer that will call methods on {@link AutoScalingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readCapacityAutoScaling(AutoScalingSettings)
         */
        default Builder readCapacityAutoScaling(Consumer<AutoScalingSettings.Builder> readCapacityAutoScaling) {
            return readCapacityAutoScaling(AutoScalingSettings.builder().applyMutation(readCapacityAutoScaling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoScalingSettings writeCapacityAutoScaling;

        private AutoScalingSettings readCapacityAutoScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingSpecification model) {
            writeCapacityAutoScaling(model.writeCapacityAutoScaling);
            readCapacityAutoScaling(model.readCapacityAutoScaling);
        }

        public final AutoScalingSettings.Builder getWriteCapacityAutoScaling() {
            return writeCapacityAutoScaling != null ? writeCapacityAutoScaling.toBuilder() : null;
        }

        public final void setWriteCapacityAutoScaling(AutoScalingSettings.BuilderImpl writeCapacityAutoScaling) {
            this.writeCapacityAutoScaling = writeCapacityAutoScaling != null ? writeCapacityAutoScaling.build() : null;
        }

        @Override
        public final Builder writeCapacityAutoScaling(AutoScalingSettings writeCapacityAutoScaling) {
            this.writeCapacityAutoScaling = writeCapacityAutoScaling;
            return this;
        }

        public final AutoScalingSettings.Builder getReadCapacityAutoScaling() {
            return readCapacityAutoScaling != null ? readCapacityAutoScaling.toBuilder() : null;
        }

        public final void setReadCapacityAutoScaling(AutoScalingSettings.BuilderImpl readCapacityAutoScaling) {
            this.readCapacityAutoScaling = readCapacityAutoScaling != null ? readCapacityAutoScaling.build() : null;
        }

        @Override
        public final Builder readCapacityAutoScaling(AutoScalingSettings readCapacityAutoScaling) {
            this.readCapacityAutoScaling = readCapacityAutoScaling;
            return this;
        }

        @Override
        public AutoScalingSpecification build() {
            return new AutoScalingSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
