/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The auto scaling policy that scales a table based on the ratio of consumed to provisioned capacity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingScalingPolicyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingScalingPolicyConfiguration.Builder, TargetTrackingScalingPolicyConfiguration> {
    private static final SdkField<Boolean> DISABLE_SCALE_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disableScaleIn").getter(getter(TargetTrackingScalingPolicyConfiguration::disableScaleIn))
            .setter(setter(Builder::disableScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableScaleIn").build()).build();

    private static final SdkField<Integer> SCALE_IN_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scaleInCooldown").getter(getter(TargetTrackingScalingPolicyConfiguration::scaleInCooldown))
            .setter(setter(Builder::scaleInCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInCooldown").build()).build();

    private static final SdkField<Integer> SCALE_OUT_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scaleOutCooldown").getter(getter(TargetTrackingScalingPolicyConfiguration::scaleOutCooldown))
            .setter(setter(Builder::scaleOutCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleOutCooldown").build()).build();

    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("targetValue").getter(getter(TargetTrackingScalingPolicyConfiguration::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLE_SCALE_IN_FIELD,
            SCALE_IN_COOLDOWN_FIELD, SCALE_OUT_COOLDOWN_FIELD, TARGET_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean disableScaleIn;

    private final Integer scaleInCooldown;

    private final Integer scaleOutCooldown;

    private final Double targetValue;

    private TargetTrackingScalingPolicyConfiguration(BuilderImpl builder) {
        this.disableScaleIn = builder.disableScaleIn;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * Specifies if <code>scale-in</code> is enabled.
     * </p>
     * <p>
     * When auto scaling automatically decreases capacity for a table, the table <i>scales in</i>. When scaling policies
     * are set, they can't scale in the table lower than its minimum capacity.
     * </p>
     * 
     * @return Specifies if <code>scale-in</code> is enabled.</p>
     *         <p>
     *         When auto scaling automatically decreases capacity for a table, the table <i>scales in</i>. When scaling
     *         policies are set, they can't scale in the table lower than its minimum capacity.
     */
    public final Boolean disableScaleIn() {
        return disableScaleIn;
    }

    /**
     * <p>
     * Specifies a <code>scale-in</code> cool down period.
     * </p>
     * <p>
     * A cooldown period in seconds between scaling activities that lets the table stabilize before another scaling
     * activity starts.
     * </p>
     * 
     * @return Specifies a <code>scale-in</code> cool down period.</p>
     *         <p>
     *         A cooldown period in seconds between scaling activities that lets the table stabilize before another
     *         scaling activity starts.
     */
    public final Integer scaleInCooldown() {
        return scaleInCooldown;
    }

    /**
     * <p>
     * Specifies a scale out cool down period.
     * </p>
     * <p>
     * A cooldown period in seconds between scaling activities that lets the table stabilize before another scaling
     * activity starts.
     * </p>
     * 
     * @return Specifies a scale out cool down period.</p>
     *         <p>
     *         A cooldown period in seconds between scaling activities that lets the table stabilize before another
     *         scaling activity starts.
     */
    public final Integer scaleOutCooldown() {
        return scaleOutCooldown;
    }

    /**
     * <p>
     * Specifies the target value for the target tracking auto scaling policy.
     * </p>
     * <p>
     * Amazon Keyspaces auto scaling scales up capacity automatically when traffic exceeds this target utilization rate,
     * and then back down when it falls below the target. This ensures that the ratio of consumed capacity to
     * provisioned capacity stays at or near this value. You define <code>targetValue</code> as a percentage. A
     * <code>double</code> between 20 and 90.
     * </p>
     * 
     * @return Specifies the target value for the target tracking auto scaling policy.</p>
     *         <p>
     *         Amazon Keyspaces auto scaling scales up capacity automatically when traffic exceeds this target
     *         utilization rate, and then back down when it falls below the target. This ensures that the ratio of
     *         consumed capacity to provisioned capacity stays at or near this value. You define
     *         <code>targetValue</code> as a percentage. A <code>double</code> between 20 and 90.
     */
    public final Double targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disableScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingPolicyConfiguration)) {
            return false;
        }
        TargetTrackingScalingPolicyConfiguration other = (TargetTrackingScalingPolicyConfiguration) obj;
        return Objects.equals(disableScaleIn(), other.disableScaleIn())
                && Objects.equals(scaleInCooldown(), other.scaleInCooldown())
                && Objects.equals(scaleOutCooldown(), other.scaleOutCooldown())
                && Objects.equals(targetValue(), other.targetValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetTrackingScalingPolicyConfiguration").add("DisableScaleIn", disableScaleIn())
                .add("ScaleInCooldown", scaleInCooldown()).add("ScaleOutCooldown", scaleOutCooldown())
                .add("TargetValue", targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "disableScaleIn":
            return Optional.ofNullable(clazz.cast(disableScaleIn()));
        case "scaleInCooldown":
            return Optional.ofNullable(clazz.cast(scaleInCooldown()));
        case "scaleOutCooldown":
            return Optional.ofNullable(clazz.cast(scaleOutCooldown()));
        case "targetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingScalingPolicyConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingScalingPolicyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingScalingPolicyConfiguration> {
        /**
         * <p>
         * Specifies if <code>scale-in</code> is enabled.
         * </p>
         * <p>
         * When auto scaling automatically decreases capacity for a table, the table <i>scales in</i>. When scaling
         * policies are set, they can't scale in the table lower than its minimum capacity.
         * </p>
         * 
         * @param disableScaleIn
         *        Specifies if <code>scale-in</code> is enabled.</p>
         *        <p>
         *        When auto scaling automatically decreases capacity for a table, the table <i>scales in</i>. When
         *        scaling policies are set, they can't scale in the table lower than its minimum capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableScaleIn(Boolean disableScaleIn);

        /**
         * <p>
         * Specifies a <code>scale-in</code> cool down period.
         * </p>
         * <p>
         * A cooldown period in seconds between scaling activities that lets the table stabilize before another scaling
         * activity starts.
         * </p>
         * 
         * @param scaleInCooldown
         *        Specifies a <code>scale-in</code> cool down period.</p>
         *        <p>
         *        A cooldown period in seconds between scaling activities that lets the table stabilize before another
         *        scaling activity starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInCooldown(Integer scaleInCooldown);

        /**
         * <p>
         * Specifies a scale out cool down period.
         * </p>
         * <p>
         * A cooldown period in seconds between scaling activities that lets the table stabilize before another scaling
         * activity starts.
         * </p>
         * 
         * @param scaleOutCooldown
         *        Specifies a scale out cool down period.</p>
         *        <p>
         *        A cooldown period in seconds between scaling activities that lets the table stabilize before another
         *        scaling activity starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutCooldown(Integer scaleOutCooldown);

        /**
         * <p>
         * Specifies the target value for the target tracking auto scaling policy.
         * </p>
         * <p>
         * Amazon Keyspaces auto scaling scales up capacity automatically when traffic exceeds this target utilization
         * rate, and then back down when it falls below the target. This ensures that the ratio of consumed capacity to
         * provisioned capacity stays at or near this value. You define <code>targetValue</code> as a percentage. A
         * <code>double</code> between 20 and 90.
         * </p>
         * 
         * @param targetValue
         *        Specifies the target value for the target tracking auto scaling policy.</p>
         *        <p>
         *        Amazon Keyspaces auto scaling scales up capacity automatically when traffic exceeds this target
         *        utilization rate, and then back down when it falls below the target. This ensures that the ratio of
         *        consumed capacity to provisioned capacity stays at or near this value. You define
         *        <code>targetValue</code> as a percentage. A <code>double</code> between 20 and 90.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disableScaleIn;

        private Integer scaleInCooldown;

        private Integer scaleOutCooldown;

        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingPolicyConfiguration model) {
            disableScaleIn(model.disableScaleIn);
            scaleInCooldown(model.scaleInCooldown);
            scaleOutCooldown(model.scaleOutCooldown);
            targetValue(model.targetValue);
        }

        public final Boolean getDisableScaleIn() {
            return disableScaleIn;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final Integer getScaleInCooldown() {
            return scaleInCooldown;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final Integer getScaleOutCooldown() {
            return scaleOutCooldown;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        @Override
        public TargetTrackingScalingPolicyConfiguration build() {
            return new TargetTrackingScalingPolicyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
