/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTypeResponse extends KeyspacesResponse implements
        ToCopyableBuilder<GetTypeResponse.Builder, GetTypeResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(GetTypeResponse::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeName").getter(getter(GetTypeResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()).build();

    private static final SdkField<List<FieldDefinition>> FIELD_DEFINITIONS_FIELD = SdkField
            .<List<FieldDefinition>> builder(MarshallingType.LIST)
            .memberName("fieldDefinitions")
            .getter(getter(GetTypeResponse::fieldDefinitions))
            .setter(setter(Builder::fieldDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(GetTypeResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTypeResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> DIRECT_REFERRING_TABLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("directReferringTables")
            .getter(getter(GetTypeResponse::directReferringTables))
            .setter(setter(Builder::directReferringTables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directReferringTables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DIRECT_PARENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("directParentTypes")
            .getter(getter(GetTypeResponse::directParentTypes))
            .setter(setter(Builder::directParentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directParentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_NESTING_DEPTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxNestingDepth").getter(getter(GetTypeResponse::maxNestingDepth))
            .setter(setter(Builder::maxNestingDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxNestingDepth").build()).build();

    private static final SdkField<String> KEYSPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceArn").getter(getter(GetTypeResponse::keyspaceArn)).setter(setter(Builder::keyspaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            TYPE_NAME_FIELD, FIELD_DEFINITIONS_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_FIELD, DIRECT_REFERRING_TABLES_FIELD,
            DIRECT_PARENT_TYPES_FIELD, MAX_NESTING_DEPTH_FIELD, KEYSPACE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyspaceName;

    private final String typeName;

    private final List<FieldDefinition> fieldDefinitions;

    private final Instant lastModifiedTimestamp;

    private final String status;

    private final List<String> directReferringTables;

    private final List<String> directParentTypes;

    private final Integer maxNestingDepth;

    private final String keyspaceArn;

    private GetTypeResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.typeName = builder.typeName;
        this.fieldDefinitions = builder.fieldDefinitions;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.status = builder.status;
        this.directReferringTables = builder.directReferringTables;
        this.directParentTypes = builder.directParentTypes;
        this.maxNestingDepth = builder.maxNestingDepth;
        this.keyspaceArn = builder.keyspaceArn;
    }

    /**
     * <p>
     * The name of the keyspace that contains this type.
     * </p>
     * 
     * @return The name of the keyspace that contains this type.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The name of the type.
     * </p>
     * 
     * @return The name of the type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldDefinitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldDefinitions() {
        return fieldDefinitions != null && !(fieldDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names and types that define this type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldDefinitions} method.
     * </p>
     * 
     * @return The names and types that define this type.
     */
    public final List<FieldDefinition> fieldDefinitions() {
        return fieldDefinitions;
    }

    /**
     * <p>
     * The timestamp that shows when this type was last modified.
     * </p>
     * 
     * @return The timestamp that shows when this type was last modified.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The status of this type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this type.
     * @see TypeStatus
     */
    public final TypeStatus status() {
        return TypeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this type.
     * @see TypeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the DirectReferringTables property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDirectReferringTables() {
        return directReferringTables != null && !(directReferringTables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tables that use this type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDirectReferringTables} method.
     * </p>
     * 
     * @return The tables that use this type.
     */
    public final List<String> directReferringTables() {
        return directReferringTables;
    }

    /**
     * For responses, this returns true if the service returned a value for the DirectParentTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDirectParentTypes() {
        return directParentTypes != null && !(directParentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types that use this type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDirectParentTypes} method.
     * </p>
     * 
     * @return The types that use this type.
     */
    public final List<String> directParentTypes() {
        return directParentTypes;
    }

    /**
     * <p>
     * The level of nesting implemented for this type.
     * </p>
     * 
     * @return The level of nesting implemented for this type.
     */
    public final Integer maxNestingDepth() {
        return maxNestingDepth;
    }

    /**
     * <p>
     * The unique identifier of the keyspace that contains this type in the format of an Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The unique identifier of the keyspace that contains this type in the format of an Amazon Resource Name
     *         (ARN).
     */
    public final String keyspaceArn() {
        return keyspaceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldDefinitions() ? fieldDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDirectReferringTables() ? directReferringTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDirectParentTypes() ? directParentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxNestingDepth());
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTypeResponse)) {
            return false;
        }
        GetTypeResponse other = (GetTypeResponse) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(typeName(), other.typeName())
                && hasFieldDefinitions() == other.hasFieldDefinitions()
                && Objects.equals(fieldDefinitions(), other.fieldDefinitions())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasDirectReferringTables() == other.hasDirectReferringTables()
                && Objects.equals(directReferringTables(), other.directReferringTables())
                && hasDirectParentTypes() == other.hasDirectParentTypes()
                && Objects.equals(directParentTypes(), other.directParentTypes())
                && Objects.equals(maxNestingDepth(), other.maxNestingDepth())
                && Objects.equals(keyspaceArn(), other.keyspaceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTypeResponse").add("KeyspaceName", keyspaceName()).add("TypeName", typeName())
                .add("FieldDefinitions", hasFieldDefinitions() ? fieldDefinitions() : null)
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).add("Status", statusAsString())
                .add("DirectReferringTables", hasDirectReferringTables() ? directReferringTables() : null)
                .add("DirectParentTypes", hasDirectParentTypes() ? directParentTypes() : null)
                .add("MaxNestingDepth", maxNestingDepth()).add("KeyspaceArn", keyspaceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "fieldDefinitions":
            return Optional.ofNullable(clazz.cast(fieldDefinitions()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "directReferringTables":
            return Optional.ofNullable(clazz.cast(directReferringTables()));
        case "directParentTypes":
            return Optional.ofNullable(clazz.cast(directParentTypes()));
        case "maxNestingDepth":
            return Optional.ofNullable(clazz.cast(maxNestingDepth()));
        case "keyspaceArn":
            return Optional.ofNullable(clazz.cast(keyspaceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("typeName", TYPE_NAME_FIELD);
        map.put("fieldDefinitions", FIELD_DEFINITIONS_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("directReferringTables", DIRECT_REFERRING_TABLES_FIELD);
        map.put("directParentTypes", DIRECT_PARENT_TYPES_FIELD);
        map.put("maxNestingDepth", MAX_NESTING_DEPTH_FIELD);
        map.put("keyspaceArn", KEYSPACE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTypeResponse, T> g) {
        return obj -> g.apply((GetTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTypeResponse> {
        /**
         * <p>
         * The name of the keyspace that contains this type.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace that contains this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The name of the type.
         * </p>
         * 
         * @param typeName
         *        The name of the type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The names and types that define this type.
         * </p>
         * 
         * @param fieldDefinitions
         *        The names and types that define this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDefinitions(Collection<FieldDefinition> fieldDefinitions);

        /**
         * <p>
         * The names and types that define this type.
         * </p>
         * 
         * @param fieldDefinitions
         *        The names and types that define this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDefinitions(FieldDefinition... fieldDefinitions);

        /**
         * <p>
         * The names and types that define this type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.FieldDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.keyspaces.model.FieldDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.FieldDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldDefinitions(List<FieldDefinition>)}.
         * 
         * @param fieldDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.FieldDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldDefinitions(java.util.Collection<FieldDefinition>)
         */
        Builder fieldDefinitions(Consumer<FieldDefinition.Builder>... fieldDefinitions);

        /**
         * <p>
         * The timestamp that shows when this type was last modified.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The timestamp that shows when this type was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The status of this type.
         * </p>
         * 
         * @param status
         *        The status of this type.
         * @see TypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this type.
         * </p>
         * 
         * @param status
         *        The status of this type.
         * @see TypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypeStatus
         */
        Builder status(TypeStatus status);

        /**
         * <p>
         * The tables that use this type.
         * </p>
         * 
         * @param directReferringTables
         *        The tables that use this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directReferringTables(Collection<String> directReferringTables);

        /**
         * <p>
         * The tables that use this type.
         * </p>
         * 
         * @param directReferringTables
         *        The tables that use this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directReferringTables(String... directReferringTables);

        /**
         * <p>
         * The types that use this type.
         * </p>
         * 
         * @param directParentTypes
         *        The types that use this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directParentTypes(Collection<String> directParentTypes);

        /**
         * <p>
         * The types that use this type.
         * </p>
         * 
         * @param directParentTypes
         *        The types that use this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directParentTypes(String... directParentTypes);

        /**
         * <p>
         * The level of nesting implemented for this type.
         * </p>
         * 
         * @param maxNestingDepth
         *        The level of nesting implemented for this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNestingDepth(Integer maxNestingDepth);

        /**
         * <p>
         * The unique identifier of the keyspace that contains this type in the format of an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param keyspaceArn
         *        The unique identifier of the keyspace that contains this type in the format of an Amazon Resource Name
         *        (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceArn(String keyspaceArn);
    }

    static final class BuilderImpl extends KeyspacesResponse.BuilderImpl implements Builder {
        private String keyspaceName;

        private String typeName;

        private List<FieldDefinition> fieldDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedTimestamp;

        private String status;

        private List<String> directReferringTables = DefaultSdkAutoConstructList.getInstance();

        private List<String> directParentTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer maxNestingDepth;

        private String keyspaceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTypeResponse model) {
            super(model);
            keyspaceName(model.keyspaceName);
            typeName(model.typeName);
            fieldDefinitions(model.fieldDefinitions);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            status(model.status);
            directReferringTables(model.directReferringTables);
            directParentTypes(model.directParentTypes);
            maxNestingDepth(model.maxNestingDepth);
            keyspaceArn(model.keyspaceArn);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final List<FieldDefinition.Builder> getFieldDefinitions() {
            List<FieldDefinition.Builder> result = FieldListCopier.copyToBuilder(this.fieldDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldDefinitions(Collection<FieldDefinition.BuilderImpl> fieldDefinitions) {
            this.fieldDefinitions = FieldListCopier.copyFromBuilder(fieldDefinitions);
        }

        @Override
        public final Builder fieldDefinitions(Collection<FieldDefinition> fieldDefinitions) {
            this.fieldDefinitions = FieldListCopier.copy(fieldDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDefinitions(FieldDefinition... fieldDefinitions) {
            fieldDefinitions(Arrays.asList(fieldDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldDefinitions(Consumer<FieldDefinition.Builder>... fieldDefinitions) {
            fieldDefinitions(Stream.of(fieldDefinitions).map(c -> FieldDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TypeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getDirectReferringTables() {
            if (directReferringTables instanceof SdkAutoConstructList) {
                return null;
            }
            return directReferringTables;
        }

        public final void setDirectReferringTables(Collection<String> directReferringTables) {
            this.directReferringTables = TableNameListCopier.copy(directReferringTables);
        }

        @Override
        public final Builder directReferringTables(Collection<String> directReferringTables) {
            this.directReferringTables = TableNameListCopier.copy(directReferringTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directReferringTables(String... directReferringTables) {
            directReferringTables(Arrays.asList(directReferringTables));
            return this;
        }

        public final Collection<String> getDirectParentTypes() {
            if (directParentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return directParentTypes;
        }

        public final void setDirectParentTypes(Collection<String> directParentTypes) {
            this.directParentTypes = TypeNameListCopier.copy(directParentTypes);
        }

        @Override
        public final Builder directParentTypes(Collection<String> directParentTypes) {
            this.directParentTypes = TypeNameListCopier.copy(directParentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directParentTypes(String... directParentTypes) {
            directParentTypes(Arrays.asList(directParentTypes));
            return this;
        }

        public final Integer getMaxNestingDepth() {
            return maxNestingDepth;
        }

        public final void setMaxNestingDepth(Integer maxNestingDepth) {
            this.maxNestingDepth = maxNestingDepth;
        }

        @Override
        public final Builder maxNestingDepth(Integer maxNestingDepth) {
            this.maxNestingDepth = maxNestingDepth;
            return this;
        }

        public final String getKeyspaceArn() {
            return keyspaceArn;
        }

        public final void setKeyspaceArn(String keyspaceArn) {
            this.keyspaceArn = keyspaceArn;
        }

        @Override
        public final Builder keyspaceArn(String keyspaceArn) {
            this.keyspaceArn = keyspaceArn;
            return this;
        }

        @Override
        public GetTypeResponse build() {
            return new GetTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
