/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of a keyspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyspaceSummary implements SdkPojo, Serializable, ToCopyableBuilder<KeyspaceSummary.Builder, KeyspaceSummary> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(KeyspaceSummary::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(KeyspaceSummary::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> REPLICATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationStrategy").getter(getter(KeyspaceSummary::replicationStrategyAsString))
            .setter(setter(Builder::replicationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStrategy").build())
            .build();

    private static final SdkField<List<String>> REPLICATION_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("replicationRegions")
            .getter(getter(KeyspaceSummary::replicationRegions))
            .setter(setter(Builder::replicationRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            RESOURCE_ARN_FIELD, REPLICATION_STRATEGY_FIELD, REPLICATION_REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyspaceName;

    private final String resourceArn;

    private final String replicationStrategy;

    private final List<String> replicationRegions;

    private KeyspaceSummary(BuilderImpl builder) {
        this.keyspaceName = builder.keyspaceName;
        this.resourceArn = builder.resourceArn;
        this.replicationStrategy = builder.replicationStrategy;
        this.replicationRegions = builder.replicationRegions;
    }

    /**
     * <p>
     * The name of the keyspace.
     * </p>
     * 
     * @return The name of the keyspace.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * This property specifies if a keyspace is a single Region keyspace or a multi-Region keyspace. The available
     * values are <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationStrategy} will return {@link Rs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #replicationStrategyAsString}.
     * </p>
     * 
     * @return This property specifies if a keyspace is a single Region keyspace or a multi-Region keyspace. The
     *         available values are <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
     * @see Rs
     */
    public final Rs replicationStrategy() {
        return Rs.fromValue(replicationStrategy);
    }

    /**
     * <p>
     * This property specifies if a keyspace is a single Region keyspace or a multi-Region keyspace. The available
     * values are <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationStrategy} will return {@link Rs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #replicationStrategyAsString}.
     * </p>
     * 
     * @return This property specifies if a keyspace is a single Region keyspace or a multi-Region keyspace. The
     *         available values are <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
     * @see Rs
     */
    public final String replicationStrategyAsString() {
        return replicationStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationRegions() {
        return replicationRegions != null && !(replicationRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of replication
     * Regions is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationRegions} method.
     * </p>
     * 
     * @return If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of
     *         replication Regions is returned.
     */
    public final List<String> replicationRegions() {
        return replicationRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationRegions() ? replicationRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyspaceSummary)) {
            return false;
        }
        KeyspaceSummary other = (KeyspaceSummary) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(replicationStrategyAsString(), other.replicationStrategyAsString())
                && hasReplicationRegions() == other.hasReplicationRegions()
                && Objects.equals(replicationRegions(), other.replicationRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyspaceSummary").add("KeyspaceName", keyspaceName()).add("ResourceArn", resourceArn())
                .add("ReplicationStrategy", replicationStrategyAsString())
                .add("ReplicationRegions", hasReplicationRegions() ? replicationRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "replicationStrategy":
            return Optional.ofNullable(clazz.cast(replicationStrategyAsString()));
        case "replicationRegions":
            return Optional.ofNullable(clazz.cast(replicationRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("replicationStrategy", REPLICATION_STRATEGY_FIELD);
        map.put("replicationRegions", REPLICATION_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyspaceSummary, T> g) {
        return obj -> g.apply((KeyspaceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyspaceSummary> {
        /**
         * <p>
         * The name of the keyspace.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param resourceArn
         *        The unique identifier of the keyspace in the format of an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * This property specifies if a keyspace is a single Region keyspace or a multi-Region keyspace. The available
         * values are <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
         * </p>
         * 
         * @param replicationStrategy
         *        This property specifies if a keyspace is a single Region keyspace or a multi-Region keyspace. The
         *        available values are <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
         * @see Rs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Rs
         */
        Builder replicationStrategy(String replicationStrategy);

        /**
         * <p>
         * This property specifies if a keyspace is a single Region keyspace or a multi-Region keyspace. The available
         * values are <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
         * </p>
         * 
         * @param replicationStrategy
         *        This property specifies if a keyspace is a single Region keyspace or a multi-Region keyspace. The
         *        available values are <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
         * @see Rs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Rs
         */
        Builder replicationStrategy(Rs replicationStrategy);

        /**
         * <p>
         * If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of replication
         * Regions is returned.
         * </p>
         * 
         * @param replicationRegions
         *        If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of
         *        replication Regions is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRegions(Collection<String> replicationRegions);

        /**
         * <p>
         * If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of replication
         * Regions is returned.
         * </p>
         * 
         * @param replicationRegions
         *        If the <code>replicationStrategy</code> of the keyspace is <code>MULTI_REGION</code>, a list of
         *        replication Regions is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRegions(String... replicationRegions);
    }

    static final class BuilderImpl implements Builder {
        private String keyspaceName;

        private String resourceArn;

        private String replicationStrategy;

        private List<String> replicationRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KeyspaceSummary model) {
            keyspaceName(model.keyspaceName);
            resourceArn(model.resourceArn);
            replicationStrategy(model.replicationStrategy);
            replicationRegions(model.replicationRegions);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getReplicationStrategy() {
            return replicationStrategy;
        }

        public final void setReplicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
        }

        @Override
        public final Builder replicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
            return this;
        }

        @Override
        public final Builder replicationStrategy(Rs replicationStrategy) {
            this.replicationStrategy(replicationStrategy == null ? null : replicationStrategy.toString());
            return this;
        }

        public final Collection<String> getReplicationRegions() {
            if (replicationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationRegions;
        }

        public final void setReplicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionListCopier.copy(replicationRegions);
        }

        @Override
        public final Builder replicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionListCopier.copy(replicationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRegions(String... replicationRegions) {
            replicationRegions(Arrays.asList(replicationRegions));
            return this;
        }

        @Override
        public KeyspaceSummary build() {
            return new KeyspaceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
