/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The auto scaling settings of a multi-Region table in the specified Amazon Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaAutoScalingSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaAutoScalingSpecification.Builder, ReplicaAutoScalingSpecification> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(ReplicaAutoScalingSpecification::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<AutoScalingSpecification> AUTO_SCALING_SPECIFICATION_FIELD = SdkField
            .<AutoScalingSpecification> builder(MarshallingType.SDK_POJO).memberName("autoScalingSpecification")
            .getter(getter(ReplicaAutoScalingSpecification::autoScalingSpecification))
            .setter(setter(Builder::autoScalingSpecification)).constructor(AutoScalingSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingSpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            AUTO_SCALING_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final AutoScalingSpecification autoScalingSpecification;

    private ReplicaAutoScalingSpecification(BuilderImpl builder) {
        this.region = builder.region;
        this.autoScalingSpecification = builder.autoScalingSpecification;
    }

    /**
     * <p>
     * The Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The auto scaling settings for a multi-Region table in the specified Amazon Web Services Region.
     * </p>
     * 
     * @return The auto scaling settings for a multi-Region table in the specified Amazon Web Services Region.
     */
    public final AutoScalingSpecification autoScalingSpecification() {
        return autoScalingSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaAutoScalingSpecification)) {
            return false;
        }
        ReplicaAutoScalingSpecification other = (ReplicaAutoScalingSpecification) obj;
        return Objects.equals(region(), other.region())
                && Objects.equals(autoScalingSpecification(), other.autoScalingSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaAutoScalingSpecification").add("Region", region())
                .add("AutoScalingSpecification", autoScalingSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "autoScalingSpecification":
            return Optional.ofNullable(clazz.cast(autoScalingSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("autoScalingSpecification", AUTO_SCALING_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaAutoScalingSpecification, T> g) {
        return obj -> g.apply((ReplicaAutoScalingSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaAutoScalingSpecification> {
        /**
         * <p>
         * The Amazon Web Services Region.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The auto scaling settings for a multi-Region table in the specified Amazon Web Services Region.
         * </p>
         * 
         * @param autoScalingSpecification
         *        The auto scaling settings for a multi-Region table in the specified Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingSpecification(AutoScalingSpecification autoScalingSpecification);

        /**
         * <p>
         * The auto scaling settings for a multi-Region table in the specified Amazon Web Services Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingSpecification.Builder}
         * avoiding the need to create one manually via {@link AutoScalingSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #autoScalingSpecification(AutoScalingSpecification)}.
         * 
         * @param autoScalingSpecification
         *        a consumer that will call methods on {@link AutoScalingSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingSpecification(AutoScalingSpecification)
         */
        default Builder autoScalingSpecification(Consumer<AutoScalingSpecification.Builder> autoScalingSpecification) {
            return autoScalingSpecification(AutoScalingSpecification.builder().applyMutation(autoScalingSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private AutoScalingSpecification autoScalingSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaAutoScalingSpecification model) {
            region(model.region);
            autoScalingSpecification(model.autoScalingSpecification);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final AutoScalingSpecification.Builder getAutoScalingSpecification() {
            return autoScalingSpecification != null ? autoScalingSpecification.toBuilder() : null;
        }

        public final void setAutoScalingSpecification(AutoScalingSpecification.BuilderImpl autoScalingSpecification) {
            this.autoScalingSpecification = autoScalingSpecification != null ? autoScalingSpecification.build() : null;
        }

        @Override
        public final Builder autoScalingSpecification(AutoScalingSpecification autoScalingSpecification) {
            this.autoScalingSpecification = autoScalingSpecification;
            return this;
        }

        @Override
        public ReplicaAutoScalingSpecification build() {
            return new ReplicaAutoScalingSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
