/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableResponse extends KeyspacesResponse implements
        ToCopyableBuilder<RestoreTableResponse.Builder, RestoreTableResponse> {
    private static final SdkField<String> RESTORED_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restoredTableARN").getter(getter(RestoreTableResponse::restoredTableARN))
            .setter(setter(Builder::restoredTableARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoredTableARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORED_TABLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restoredTableARN;

    private RestoreTableResponse(BuilderImpl builder) {
        super(builder);
        this.restoredTableARN = builder.restoredTableARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the restored table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the restored table.
     */
    public final String restoredTableARN() {
        return restoredTableARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restoredTableARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableResponse)) {
            return false;
        }
        RestoreTableResponse other = (RestoreTableResponse) obj;
        return Objects.equals(restoredTableARN(), other.restoredTableARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTableResponse").add("RestoredTableARN", restoredTableARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restoredTableARN":
            return Optional.ofNullable(clazz.cast(restoredTableARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restoredTableARN", RESTORED_TABLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableResponse, T> g) {
        return obj -> g.apply((RestoreTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, RestoreTableResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the restored table.
         * </p>
         * 
         * @param restoredTableARN
         *        The Amazon Resource Name (ARN) of the restored table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoredTableARN(String restoredTableARN);
    }

    static final class BuilderImpl extends KeyspacesResponse.BuilderImpl implements Builder {
        private String restoredTableARN;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableResponse model) {
            super(model);
            restoredTableARN(model.restoredTableARN);
        }

        public final String getRestoredTableARN() {
            return restoredTableARN;
        }

        public final void setRestoredTableARN(String restoredTableARN) {
            this.restoredTableARN = restoredTableARN;
        }

        @Override
        public final Builder restoredTableARN(String restoredTableARN) {
            this.restoredTableARN = restoredTableARN;
            return this;
        }

        @Override
        public RestoreTableResponse build() {
            return new RestoreTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
