/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The optional auto scaling settings for a table with provisioned throughput capacity.
 * </p>
 * <p>
 * To turn on auto scaling for a table in <code>throughputMode:PROVISIONED</code>, you must specify the following
 * parameters.
 * </p>
 * <p>
 * Configure the minimum and maximum capacity units. The auto scaling policy ensures that capacity never goes below the
 * minimum or above the maximum range.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>minimumUnits</code>: The minimum level of throughput the table should always be ready to support. The value
 * must be between 1 and the max throughput per second quota for your account (40,000 by default).
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>maximumUnits</code>: The maximum level of throughput the table should always be ready to support. The value
 * must be between 1 and the max throughput per second quota for your account (40,000 by default).
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>scalingPolicy</code>: Amazon Keyspaces supports the <code>target tracking</code> scaling policy. The auto
 * scaling target is the provisioned capacity of the table.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>targetTrackingScalingPolicyConfiguration</code>: To define the target tracking policy, you must define the
 * target value.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>targetValue</code>: The target utilization rate of the table. Amazon Keyspaces auto scaling ensures that the
 * ratio of consumed capacity to provisioned capacity stays at or near this value. You define <code>targetValue</code>
 * as a percentage. A <code>double</code> between 20 and 90. (Required)
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>disableScaleIn</code>: A <code>boolean</code> that specifies if <code>scale-in</code> is disabled or enabled
 * for the table. This parameter is disabled by default. To turn on <code>scale-in</code>, set the <code>boolean</code>
 * value to <code>FALSE</code>. This means that capacity for a table can be automatically scaled down on your behalf.
 * (Optional)
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>scaleInCooldown</code>: A cooldown period in seconds between scaling activities that lets the table stabilize
 * before another scale in activity starts. If no value is provided, the default is 0. (Optional)
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>scaleOutCooldown</code>: A cooldown period in seconds between scaling activities that lets the table stabilize
 * before another scale out activity starts. If no value is provided, the default is 0. (Optional)
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html">Managing
 * throughput capacity automatically with Amazon Keyspaces auto scaling</a> in the <i>Amazon Keyspaces Developer
 * Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingSettings.Builder, AutoScalingSettings> {
    private static final SdkField<Boolean> AUTO_SCALING_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoScalingDisabled").getter(getter(AutoScalingSettings::autoScalingDisabled))
            .setter(setter(Builder::autoScalingDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingDisabled").build())
            .build();

    private static final SdkField<Long> MINIMUM_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("minimumUnits").getter(getter(AutoScalingSettings::minimumUnits)).setter(setter(Builder::minimumUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumUnits").build()).build();

    private static final SdkField<Long> MAXIMUM_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("maximumUnits").getter(getter(AutoScalingSettings::maximumUnits)).setter(setter(Builder::maximumUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumUnits").build()).build();

    private static final SdkField<AutoScalingPolicy> SCALING_POLICY_FIELD = SdkField
            .<AutoScalingPolicy> builder(MarshallingType.SDK_POJO).memberName("scalingPolicy")
            .getter(getter(AutoScalingSettings::scalingPolicy)).setter(setter(Builder::scalingPolicy))
            .constructor(AutoScalingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_DISABLED_FIELD,
            MINIMUM_UNITS_FIELD, MAXIMUM_UNITS_FIELD, SCALING_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean autoScalingDisabled;

    private final Long minimumUnits;

    private final Long maximumUnits;

    private final AutoScalingPolicy scalingPolicy;

    private AutoScalingSettings(BuilderImpl builder) {
        this.autoScalingDisabled = builder.autoScalingDisabled;
        this.minimumUnits = builder.minimumUnits;
        this.maximumUnits = builder.maximumUnits;
        this.scalingPolicy = builder.scalingPolicy;
    }

    /**
     * <p>
     * This optional parameter enables auto scaling for the table if set to <code>false</code>.
     * </p>
     * 
     * @return This optional parameter enables auto scaling for the table if set to <code>false</code>.
     */
    public final Boolean autoScalingDisabled() {
        return autoScalingDisabled;
    }

    /**
     * <p>
     * The minimum level of throughput the table should always be ready to support. The value must be between 1 and the
     * max throughput per second quota for your account (40,000 by default).
     * </p>
     * 
     * @return The minimum level of throughput the table should always be ready to support. The value must be between 1
     *         and the max throughput per second quota for your account (40,000 by default).
     */
    public final Long minimumUnits() {
        return minimumUnits;
    }

    /**
     * <p>
     * Manage costs by specifying the maximum amount of throughput to provision. The value must be between 1 and the max
     * throughput per second quota for your account (40,000 by default).
     * </p>
     * 
     * @return Manage costs by specifying the maximum amount of throughput to provision. The value must be between 1 and
     *         the max throughput per second quota for your account (40,000 by default).
     */
    public final Long maximumUnits() {
        return maximumUnits;
    }

    /**
     * <p>
     * Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy. With this policy, Amazon
     * Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or near the
     * target value that you specify. You define the target value as a percentage between 20 and 90.
     * </p>
     * 
     * @return Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy. With this policy, Amazon
     *         Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or
     *         near the target value that you specify. You define the target value as a percentage between 20 and 90.
     */
    public final AutoScalingPolicy scalingPolicy() {
        return scalingPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(minimumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(maximumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(scalingPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingSettings)) {
            return false;
        }
        AutoScalingSettings other = (AutoScalingSettings) obj;
        return Objects.equals(autoScalingDisabled(), other.autoScalingDisabled())
                && Objects.equals(minimumUnits(), other.minimumUnits()) && Objects.equals(maximumUnits(), other.maximumUnits())
                && Objects.equals(scalingPolicy(), other.scalingPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingSettings").add("AutoScalingDisabled", autoScalingDisabled())
                .add("MinimumUnits", minimumUnits()).add("MaximumUnits", maximumUnits()).add("ScalingPolicy", scalingPolicy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoScalingDisabled":
            return Optional.ofNullable(clazz.cast(autoScalingDisabled()));
        case "minimumUnits":
            return Optional.ofNullable(clazz.cast(minimumUnits()));
        case "maximumUnits":
            return Optional.ofNullable(clazz.cast(maximumUnits()));
        case "scalingPolicy":
            return Optional.ofNullable(clazz.cast(scalingPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("autoScalingDisabled", AUTO_SCALING_DISABLED_FIELD);
        map.put("minimumUnits", MINIMUM_UNITS_FIELD);
        map.put("maximumUnits", MAXIMUM_UNITS_FIELD);
        map.put("scalingPolicy", SCALING_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingSettings, T> g) {
        return obj -> g.apply((AutoScalingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingSettings> {
        /**
         * <p>
         * This optional parameter enables auto scaling for the table if set to <code>false</code>.
         * </p>
         * 
         * @param autoScalingDisabled
         *        This optional parameter enables auto scaling for the table if set to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingDisabled(Boolean autoScalingDisabled);

        /**
         * <p>
         * The minimum level of throughput the table should always be ready to support. The value must be between 1 and
         * the max throughput per second quota for your account (40,000 by default).
         * </p>
         * 
         * @param minimumUnits
         *        The minimum level of throughput the table should always be ready to support. The value must be between
         *        1 and the max throughput per second quota for your account (40,000 by default).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumUnits(Long minimumUnits);

        /**
         * <p>
         * Manage costs by specifying the maximum amount of throughput to provision. The value must be between 1 and the
         * max throughput per second quota for your account (40,000 by default).
         * </p>
         * 
         * @param maximumUnits
         *        Manage costs by specifying the maximum amount of throughput to provision. The value must be between 1
         *        and the max throughput per second quota for your account (40,000 by default).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumUnits(Long maximumUnits);

        /**
         * <p>
         * Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy. With this policy, Amazon
         * Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or near
         * the target value that you specify. You define the target value as a percentage between 20 and 90.
         * </p>
         * 
         * @param scalingPolicy
         *        Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy. With this policy,
         *        Amazon Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays
         *        at or near the target value that you specify. You define the target value as a percentage between 20
         *        and 90.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicy(AutoScalingPolicy scalingPolicy);

        /**
         * <p>
         * Amazon Keyspaces supports the <code>target tracking</code> auto scaling policy. With this policy, Amazon
         * Keyspaces auto scaling ensures that the table's ratio of consumed to provisioned capacity stays at or near
         * the target value that you specify. You define the target value as a percentage between 20 and 90.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingPolicy.Builder} avoiding the
         * need to create one manually via {@link AutoScalingPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #scalingPolicy(AutoScalingPolicy)}.
         * 
         * @param scalingPolicy
         *        a consumer that will call methods on {@link AutoScalingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingPolicy(AutoScalingPolicy)
         */
        default Builder scalingPolicy(Consumer<AutoScalingPolicy.Builder> scalingPolicy) {
            return scalingPolicy(AutoScalingPolicy.builder().applyMutation(scalingPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoScalingDisabled;

        private Long minimumUnits;

        private Long maximumUnits;

        private AutoScalingPolicy scalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingSettings model) {
            autoScalingDisabled(model.autoScalingDisabled);
            minimumUnits(model.minimumUnits);
            maximumUnits(model.maximumUnits);
            scalingPolicy(model.scalingPolicy);
        }

        public final Boolean getAutoScalingDisabled() {
            return autoScalingDisabled;
        }

        public final void setAutoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
        }

        @Override
        public final Builder autoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
            return this;
        }

        public final Long getMinimumUnits() {
            return minimumUnits;
        }

        public final void setMinimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
        }

        @Override
        public final Builder minimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
            return this;
        }

        public final Long getMaximumUnits() {
            return maximumUnits;
        }

        public final void setMaximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
        }

        @Override
        public final Builder maximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
            return this;
        }

        public final AutoScalingPolicy.Builder getScalingPolicy() {
            return scalingPolicy != null ? scalingPolicy.toBuilder() : null;
        }

        public final void setScalingPolicy(AutoScalingPolicy.BuilderImpl scalingPolicy) {
            this.scalingPolicy = scalingPolicy != null ? scalingPolicy.build() : null;
        }

        @Override
        public final Builder scalingPolicy(AutoScalingPolicy scalingPolicy) {
            this.scalingPolicy = scalingPolicy;
            return this;
        }

        @Override
        public AutoScalingSettings build() {
            return new AutoScalingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
